/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.TsFileIdentifier;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossCompactionRecoverTask
extends RewriteCrossSpaceCompactionTask {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private File compactionLogFile;

    public RewriteCrossCompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartitionId, File logFile, AtomicInteger currentTaskNum, TsFileManager tsFileManager) {
        super(logicalStorageGroupName, virtualStorageGroupName, timePartitionId, tsFileManager, null, null, currentTaskNum);
        this.compactionLogFile = logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doCompaction() {
        boolean handleSuccess;
        block20: {
            List<TsFileIdentifier> targetFileIdentifiers;
            List<TsFileIdentifier> sourceFileIdentifiers;
            CompactionLogAnalyzer logAnalyzer;
            block21: {
                block22: {
                    handleSuccess = true;
                    this.LOGGER.info("{} [Compaction][Recover] cross space compaction log is {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    if (!this.compactionLogFile.exists()) break block20;
                    this.LOGGER.info("{} [Compaction][Recover] cross space compaction log file {} exists, start to recover it", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    logAnalyzer = new CompactionLogAnalyzer(this.compactionLogFile);
                    if (this.isOldLog()) {
                        logAnalyzer.analyzeOldCrossCompactionLog();
                    } else {
                        logAnalyzer.analyze();
                    }
                    sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
                    targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
                    if (!targetFileIdentifiers.isEmpty() && !sourceFileIdentifiers.isEmpty()) break block21;
                    this.LOGGER.info("{} [Compaction][Recover] incomplete log file, abort recover", (Object)this.fullStorageGroupName);
                    if (handleSuccess) break block22;
                    this.LOGGER.error("{} [Compaction][Recover] Failed to recover cross space compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e) {
                    this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
            try {
                boolean isAllSourcesFileExisted = true;
                for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                    File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
                    if (sourceFile != null) continue;
                    isAllSourcesFileExisted = false;
                    break;
                }
                if (isAllSourcesFileExisted) {
                    handleSuccess = logAnalyzer.isLogFromOld() ? this.handleWithAllSourceFilesExistFromOld(targetFileIdentifiers) : this.handleWithAllSourceFilesExist(targetFileIdentifiers, sourceFileIdentifiers);
                    break block20;
                }
                handleSuccess = logAnalyzer.isLogFromOld() ? this.handleWithoutAllSourceFilesExistFromOld(targetFileIdentifiers, sourceFileIdentifiers) : this.handleWithoutAllSourceFilesExist(sourceFileIdentifiers);
            }
            catch (IOException e) {
                block23: {
                    try {
                        this.LOGGER.error("recover cross space compaction error", (Throwable)e);
                        if (handleSuccess) break block23;
                    }
                    catch (Throwable throwable) {
                        if (!handleSuccess) {
                            this.LOGGER.error("{} [Compaction][Recover] Failed to recover cross space compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                            this.tsFileManager.setAllowCompaction(false);
                            throw throwable;
                        }
                        if (!this.compactionLogFile.exists()) throw throwable;
                        try {
                            this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                            FileUtils.delete((File)this.compactionLogFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e2});
                            this.tsFileManager.setAllowCompaction(false);
                        }
                        throw throwable;
                    }
                    this.LOGGER.error("{} [Compaction][Recover] Failed to recover cross space compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e3) {
                    this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e3});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
        }
        if (!handleSuccess) {
            this.LOGGER.error("{} [Compaction][Recover] Failed to recover cross space compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
            this.tsFileManager.setAllowCompaction(false);
            return;
        } else {
            if (!this.compactionLogFile.exists()) return;
            try {
                this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                FileUtils.delete((File)this.compactionLogFile);
                return;
            }
            catch (IOException e) {
                this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                this.tsFileManager.setAllowCompaction(false);
            }
        }
        return;
    }

    private boolean handleWithAllSourceFilesExist(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
        this.LOGGER.info("{} [Compaction][Recover] all source files exists, delete all target files.", (Object)this.fullStorageGroupName);
        for (TsFileIdentifier tsFileIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = tsFileIdentifier.getFileFromDataDirs();
            File targetFile = this.getFileFromDataDirs(tsFileIdentifier.getFilePath().replace(".cross", ".tsfile"));
            TsFileResource targetResource = null;
            if (tmpTargetFile != null) {
                targetResource = new TsFileResource(tmpTargetFile);
            } else if (targetFile != null) {
                targetResource = new TsFileResource(targetFile);
            }
            if (targetResource == null || targetResource.remove()) continue;
            this.LOGGER.warn("{} [Compaction][Recover] failed to remove target file {}", (Object)this.fullStorageGroupName, (Object)targetResource);
            return false;
        }
        ArrayList<TsFileResource> sourceTsFileResourceList = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            sourceTsFileResourceList.add(new TsFileResource(sourceFileIdentifier.getFileFromDataDirs()));
        }
        try {
            CompactionUtils.deleteCompactionModsFile(sourceTsFileResourceList, Collections.emptyList());
        }
        catch (Throwable throwable) {
            this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting compaction mods file, set allowCompaction to false", (Object)this.fullStorageGroupName, (Object)throwable);
            return false;
        }
        return true;
    }

    private boolean handleWithoutAllSourceFilesExist(List<TsFileIdentifier> sourceFileIdentifiers) {
        boolean handleSuccess = true;
        ArrayList<TsFileResource> remainSourceTsFileResources = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
            if (sourceFile != null) {
                TsFileResource resource = new TsFileResource(sourceFile);
                resource.setStatus(TsFileResourceStatus.CLOSED);
                remainSourceTsFileResources.add(resource);
            } else {
                File resourceFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource");
                if (resourceFile != null && !resourceFile.delete()) {
                    this.LOGGER.error("{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", (Object)this.fullStorageGroupName, (Object)resourceFile);
                    handleSuccess = false;
                }
            }
            File compactionModFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".compaction.mods");
            File modFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods");
            if (compactionModFile != null && !compactionModFile.delete()) {
                this.LOGGER.error("{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", (Object)this.fullStorageGroupName, (Object)compactionModFile);
                handleSuccess = false;
            }
            if (modFile == null || modFile.delete()) continue;
            this.LOGGER.error("{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", (Object)this.fullStorageGroupName, (Object)modFile);
            handleSuccess = false;
        }
        if (!InnerSpaceCompactionUtils.deleteTsFilesInDisk(remainSourceTsFileResources, this.fullStorageGroupName)) {
            this.LOGGER.error("{} [Compaction][Recover] fail to delete remaining source files.", (Object)this.fullStorageGroupName);
            handleSuccess = false;
        }
        return handleSuccess;
    }

    private boolean handleWithAllSourceFilesExistFromOld(List<TsFileIdentifier> targetFileIdentifiers) {
        for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = targetFileIdentifier.getFileFromDataDirs();
            if (tmpTargetFile == null) continue;
            tmpTargetFile.delete();
        }
        File compactionModsFileFromOld = new File(this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
        if (compactionModsFileFromOld.exists() && !compactionModsFileFromOld.delete()) {
            this.LOGGER.error("{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", (Object)this.fullStorageGroupName, (Object)compactionModsFileFromOld);
            return false;
        }
        return true;
    }

    private boolean handleWithoutAllSourceFilesExistFromOld(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
        try {
            File compactionModsFileFromOld = new File(this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
            ArrayList<TsFileResource> targetFileResources = new ArrayList<TsFileResource>();
            for (int i = 0; i < sourceFileIdentifiers.size(); ++i) {
                File sourceFile;
                TsFileIdentifier sourceFileIdentifier = sourceFileIdentifiers.get(i);
                if (sourceFileIdentifier.isSequence()) {
                    File tmpTargetFile = targetFileIdentifiers.get(i).getFileFromDataDirs();
                    File targetFile = null;
                    if (tmpTargetFile != null) {
                        String sourceFilePath = tmpTargetFile.getPath().replace(".tsfile.merge", ".tsfile");
                        targetFile = TsFileNameGenerator.increaseCrossCompactionCnt(new File(sourceFilePath));
                        FSFactoryProducer.getFSFactory().moveFile(tmpTargetFile, targetFile);
                    } else {
                        File file = TsFileNameGenerator.increaseCrossCompactionCnt(new File(targetFileIdentifiers.get(i).getFilePath().replace(".tsfile.merge", ".tsfile")));
                        targetFile = this.getFileFromDataDirs(file.getPath());
                    }
                    if (targetFile == null) {
                        this.LOGGER.error("{} [Compaction][Recover] target file of source seq file {} does not exist (<0.13).", (Object)this.fullStorageGroupName, (Object)sourceFileIdentifier.getFilePath());
                        return false;
                    }
                    TsFileResource targetResource = new TsFileResource(targetFile);
                    if (!targetResource.resourceFileExists()) {
                        try (TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getAbsolutePath());){
                            FileLoaderUtils.updateTsFileResource(reader, targetResource);
                        }
                        targetResource.serialize();
                    }
                    targetFileResources.add(targetResource);
                    if (compactionModsFileFromOld.exists()) {
                        ModificationFile compactionModsFile = new ModificationFile(compactionModsFileFromOld.getPath());
                        RewriteCrossCompactionRecoverTask.appendCompactionModificationsFromOld(targetResource, compactionModsFile);
                    }
                    if (tmpTargetFile != null) {
                        tmpTargetFile.delete();
                    }
                }
                if ((sourceFile = sourceFileIdentifier.getFileFromDataDirs()) != null) {
                    sourceFile.delete();
                }
                if ((sourceFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource")) != null) {
                    sourceFile.delete();
                }
                if ((sourceFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods")) == null) continue;
                sourceFile.delete();
            }
            if (compactionModsFileFromOld.exists() && !compactionModsFileFromOld.delete()) {
                this.LOGGER.error("{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", (Object)this.fullStorageGroupName, (Object)compactionModsFileFromOld);
                return false;
            }
        }
        catch (Throwable e) {
            this.LOGGER.error("{} [Compaction][Recover] fail to handle with some source files lost from old version.", (Object)this.fullStorageGroupName, (Object)e);
            return false;
        }
        return true;
    }

    public static void appendCompactionModificationsFromOld(TsFileResource resource, ModificationFile compactionModsFile) throws IOException {
        if (compactionModsFile != null) {
            for (Modification modification : compactionModsFile.getModifications()) {
                modification.setFileOffset(Long.MAX_VALUE);
                resource.getModFile().write(modification);
            }
            resource.getModFile().close();
        }
    }

    private File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof RewriteCrossCompactionRecoverTask) {
            return this.compactionLogFile.equals(((RewriteCrossCompactionRecoverTask)other).compactionLogFile);
        }
        return false;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        return this.compactionLogFile.exists();
    }

    private boolean isOldLog() {
        return this.compactionLogFile.getName().equals("merge.log");
    }
}

