/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.query.udf.core.access.LayerPointReaderBackedSingleColumnRow;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerCacheUtils;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowWindowReader;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputColumnSingleReferenceIntermediateLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputColumnSingleReferenceIntermediateLayer.class);
    private final LayerPointReader parentLayerPointReader;
    private final TSDataType dataType;

    public SingleInputColumnSingleReferenceIntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB, LayerPointReader parentLayerPointReader) {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerPointReader = parentLayerPointReader;
        this.dataType = parentLayerPointReader.getDataType();
    }

    @Override
    public LayerPointReader constructPointReader() {
        return this.parentLayerPointReader;
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final Row row;
            private boolean hasCached;
            private boolean isCurrentNull;
            {
                this.row = new LayerPointReaderBackedSingleColumnRow(SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader);
                this.hasCached = false;
                this.isCurrentNull = false;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (!this.hasCached) {
                    this.hasCached = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.next();
                    if (this.hasCached) {
                        this.isCurrentNull = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.isCurrentNull();
                    }
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.isCurrentNull = false;
                SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.readyForNext();
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.getDataType()};
            }

            @Override
            public long currentTime() throws IOException {
                return SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.currentTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() {
                return this.isCurrentNull;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) throws QueryProcessException {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableTVList tvList;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.tvList = ElasticSerializableTVList.newElasticSerializableTVList(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("SingleInputColumnSingleReferenceIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return false;
                }
                int pointsToBeCollected = endIndex - this.tvList.size();
                if (0 < pointsToBeCollected) {
                    LayerCacheUtils.cachePoints(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, this.tvList, pointsToBeCollected);
                    if (this.tvList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, this.tvList.size(), this.tvList.getTime(this.beginIndex), this.tvList.getTime(this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.tvList.getTime(this.beginIndex), this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.tvList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException, IOException {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        long nextWindowTimeBeginGivenByStrategy = strategy.getDisplayWindowBegin();
        if (tvList.size() == 0 && LayerCacheUtils.cachePoint(this.dataType, this.parentLayerPointReader, tvList) && nextWindowTimeBeginGivenByStrategy == Long.MIN_VALUE) {
            nextWindowTimeBeginGivenByStrategy = tvList.getTime(0);
        }
        final long finalNextWindowTimeBeginGivenByStrategy = nextWindowTimeBeginGivenByStrategy;
        final boolean hasAtLeastOneRow = tvList.size() != 0;
        return new LayerRowWindowReader(){
            private boolean hasCached = false;
            private long nextWindowTimeBegin = finalNextWindowTimeBeginGivenByStrategy;
            private int nextIndexBegin = 0;

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                if (!hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (tvList.getTime(tvList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cachePoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList)) {
                }
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != tvList.size() - 1) continue;
                    this.nextIndexBegin = tvList.size();
                }
                int nextIndexEnd = tvList.size();
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (nextWindowTimeEnd > tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd;
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

