/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.protocol.influxdb.meta.TagInfoRecords;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;

public class InfluxDBMetaManager {
    protected final Planner planner;
    private final ServiceProvider serviceProvider = IoTDB.serviceProvider;
    private static final String SELECT_TAG_INFO_SQL = "select database_name,measurement_name,tag_name,tag_order from root.TAG_INFO ";
    private static Map<String, Map<String, Map<String, Integer>>> database2Measurement2TagOrders = new HashMap<String, Map<String, Map<String, Integer>>>();

    public static InfluxDBMetaManager getInstance() {
        return InfluxDBMetaManagerHolder.INSTANCE;
    }

    private InfluxDBMetaManager() {
        database2Measurement2TagOrders = new HashMap<String, Map<String, Map<String, Integer>>>();
        this.planner = this.serviceProvider.getPlanner();
    }

    public void recover() {
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryPlan queryPlan = (QueryPlan)this.planner.parseSQLToPhysicalPlan(SELECT_TAG_INFO_SQL);
            QueryContext queryContext = this.serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), SELECT_TAG_INFO_SQL, 0L);
            QueryDataSet queryDataSet = this.serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
            while (queryDataSet.hasNext()) {
                Map<String, Integer> tagOrders;
                Map<Object, Object> measurement2TagOrders;
                List fields = queryDataSet.next().getFields();
                String databaseName = ((Field)fields.get(0)).getStringValue();
                String measurementName = ((Field)fields.get(1)).getStringValue();
                if (database2Measurement2TagOrders.containsKey(databaseName)) {
                    measurement2TagOrders = database2Measurement2TagOrders.get(databaseName);
                    tagOrders = measurement2TagOrders.containsKey(measurementName) ? (Map)measurement2TagOrders.get(measurementName) : new HashMap();
                } else {
                    measurement2TagOrders = new HashMap();
                    tagOrders = new HashMap<String, Integer>();
                }
                tagOrders.put(((Field)fields.get(2)).getStringValue(), ((Field)fields.get(3)).getIntV());
                measurement2TagOrders.put(measurementName, tagOrders);
                database2Measurement2TagOrders.put(databaseName, measurement2TagOrders);
            }
        }
        catch (IOException | InterruptedException | SQLException | StorageEngineException | MetadataException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(e.getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
    }

    public synchronized Map<String, Map<String, Integer>> createDatabase(String database) {
        Map<String, Map<String, Integer>> measurement2TagOrders = database2Measurement2TagOrders.get(database);
        if (measurement2TagOrders != null) {
            return measurement2TagOrders;
        }
        try {
            SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(new PartialPath("root." + database));
            this.serviceProvider.executeNonQuery(setStorageGroupPlan);
        }
        catch (QueryProcessException e) {
            if (e.getErrorCode() != 300) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException e) {
            throw new InfluxDBException(e.getMessage());
        }
        measurement2TagOrders = new HashMap<String, Map<String, Integer>>();
        database2Measurement2TagOrders.put(database, measurement2TagOrders);
        return measurement2TagOrders;
    }

    public synchronized Map<String, Integer> getTagOrdersWithAutoCreatingSchema(String database, String measurement) {
        return this.createDatabase(database).computeIfAbsent(measurement, m -> new HashMap());
    }

    public synchronized String generatePath(String database, String measurement, Map<String, String> tags) {
        Map<String, Integer> tagKeyToLayerOrders = this.getTagOrdersWithAutoCreatingSchema(database, measurement);
        HashMap<String, Integer> newTagKeyToLayerOrders = new HashMap<String, Integer>(tagKeyToLayerOrders);
        HashMap layerOrderToTagKeysInPath = new HashMap();
        int tagNumber = tagKeyToLayerOrders.size();
        TagInfoRecords newTagInfoRecords = null;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            String tagKey = tag.getKey();
            if (!newTagKeyToLayerOrders.containsKey(tagKey)) {
                if (newTagInfoRecords == null) {
                    newTagInfoRecords = new TagInfoRecords();
                }
                newTagInfoRecords.add(database, measurement, tagKey, ++tagNumber);
                newTagKeyToLayerOrders.put(tagKey, tagNumber);
            }
            layerOrderToTagKeysInPath.put(newTagKeyToLayerOrders.get(tagKey), tagKey);
        }
        if (newTagInfoRecords != null) {
            this.updateTagInfoRecords(newTagInfoRecords);
            database2Measurement2TagOrders.get(database).put(measurement, newTagKeyToLayerOrders);
        }
        StringBuilder path = new StringBuilder("root.").append(database).append(".").append(measurement);
        for (int i = 1; i <= tagNumber; ++i) {
            path.append(".").append(layerOrderToTagKeysInPath.containsKey(i) ? tags.get(layerOrderToTagKeysInPath.get(i)) : "PH");
        }
        return path.toString();
    }

    private void updateTagInfoRecords(TagInfoRecords tagInfoRecords) {
        List<InsertRowPlan> plans = tagInfoRecords.convertToInsertRowPlans();
        for (InsertRowPlan plan : plans) {
            try {
                this.serviceProvider.executeNonQuery(plan);
            }
            catch (StorageEngineException | StorageGroupNotSetException | QueryProcessException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
    }

    private static class InfluxDBMetaManagerHolder {
        private static final InfluxDBMetaManager INSTANCE = new InfluxDBMetaManager();

        private InfluxDBMetaManagerHolder() {
        }
    }
}

