/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE = config.getAllocateMemoryForTimeSeriesMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private final Cache<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final AtomicLong bloomFilterRequestCount = new AtomicLong(0L);
    private final AtomicLong bloomFilterPreventCount = new AtomicLong(0L);
    private final Map<String, WeakReference<String>> devices = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEPARATOR = "$";

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeseriesMetadataCache size = " + MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE).weigher((key, value) -> (int)(RamUsageEstimator.shallowSizeOf((Object)key) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).device) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).measurement) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).tsFilePrefixPath) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).tsFileVersion) + RamUsageEstimator.shallowSizeOf((Object)value) + RamUsageEstimator.sizeOf((Object)value.getMeasurementId()) + RamUsageEstimator.shallowSizeOf((Object)value.getStatistics()) + (value.getChunkMetadataList().get(0) == null ? 0L : ((ChunkMetadata)value.getChunkMetadataList().get(0)).calculateRamSize() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF) * (long)value.getChunkMetadataList().size() + RamUsageEstimator.shallowSizeOf((Object)value.getChunkMetadataList()))).recordStats().build();
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricService.getInstance().getOrCreateAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, this.lruCache, l -> (long)(l.stats().hitRate() * 100.0), new String[]{Tag.NAME.toString(), "timeSeriesMeta"});
            MetricService.getInstance().getOrCreateAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, this.bloomFilterPreventCount, prevent -> {
                if (this.bloomFilterRequestCount.get() == 0L) {
                    return 1L;
                }
                return (long)((double)prevent.get() / (double)this.bloomFilterRequestCount.get() * 100.0);
            }, new String[]{Tag.NAME.toString(), "bloomFilter"});
        }
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeseriesMetadata get(TimeSeriesMetadataCacheKey key, Set<String> allSensors, boolean ignoreNotExists, boolean debug) throws IOException {
        if (!CACHE_ENABLE) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.filePath, true);
            BloomFilter bloomFilter = reader.readBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(key.device + '.' + key.measurement)) {
                return null;
            }
            TimeseriesMetadata timeseriesMetadata = reader.readTimeseriesMetadata(new Path(key.device, key.measurement), ignoreNotExists);
            return timeseriesMetadata == null || timeseriesMetadata.getStatistics().getCount() == 0L ? null : timeseriesMetadata;
        }
        TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
        if (timeseriesMetadata == null) {
            if (debug) {
                DEBUG_LOGGER.info("Cache miss: {}.{} in file: {}", new Object[]{key.device, key.measurement, key.filePath});
                DEBUG_LOGGER.info("Device: {}, all sensors: {}", (Object)key.device, allSensors);
            }
            WeakReference weakReference = this.devices.computeIfAbsent(key.device + SEPARATOR + key.filePath, WeakReference::new);
            synchronized (weakReference) {
                timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                if (timeseriesMetadata == null) {
                    Path path = new Path(key.device, key.measurement);
                    BloomFilter bloomFilter = BloomFilterCache.getInstance().get(new BloomFilterCache.BloomFilterCacheKey(key.filePath), debug);
                    if (bloomFilter != null) {
                        this.bloomFilterRequestCount.incrementAndGet();
                        if (!bloomFilter.contains(path.getFullPath())) {
                            this.bloomFilterPreventCount.incrementAndGet();
                            if (debug) {
                                DEBUG_LOGGER.info("TimeSeries meta data {} is filter by bloomFilter!", (Object)key);
                            }
                            return null;
                        }
                    }
                    TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.filePath, true);
                    List timeSeriesMetadataList = reader.readTimeseriesMetadata(path, allSensors);
                    for (TimeseriesMetadata metadata : timeSeriesMetadataList) {
                        TimeSeriesMetadataCacheKey k = new TimeSeriesMetadataCacheKey(key.filePath, key.device, metadata.getMeasurementId());
                        if (metadata.getStatistics().getCount() != 0L) {
                            this.lruCache.put((Object)k, (Object)metadata);
                        }
                        if (!metadata.getMeasurementId().equals(key.measurement)) continue;
                        timeseriesMetadata = metadata.getStatistics().getCount() == 0L ? null : metadata;
                    }
                }
            }
        }
        if (timeseriesMetadata == null) {
            if (debug) {
                DEBUG_LOGGER.info("The file doesn't have this time series {}.", (Object)key);
            }
            return null;
        }
        if (debug) {
            DEBUG_LOGGER.info("Get timeseries: {}.{}  metadata in file: {}  from cache: {}.", new Object[]{key.device, key.measurement, key.filePath, timeseriesMetadata});
        }
        return new TimeseriesMetadata(timeseriesMetadata);
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey {
        private final String filePath;
        private final String tsFilePrefixPath;
        private final long tsFileVersion;
        private final long compactionVersion;
        private final String device;
        private final String measurement;

        public TimeSeriesMetadataCacheKey(String filePath, String device, String measurement) {
            this.filePath = filePath;
            Pair tsFilePrefixPathAndTsFileVersionPair = FilePathUtils.getTsFilePrefixPathAndTsFileVersionPair((String)filePath);
            this.tsFilePrefixPath = (String)tsFilePrefixPathAndTsFileVersionPair.left;
            this.tsFileVersion = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[0];
            this.compactionVersion = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[1];
            this.device = device;
            this.measurement = measurement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return Objects.equals(this.measurement, that.measurement) && Objects.equals(this.device, that.device) && this.tsFileVersion == that.tsFileVersion && this.compactionVersion == that.compactionVersion && this.tsFilePrefixPath.equals(that.tsFilePrefixPath);
        }

        public int hashCode() {
            return Objects.hash(this.tsFilePrefixPath, this.tsFileVersion, this.compactionVersion, this.device, this.measurement);
        }
    }
}

