/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.doublelive.OperationSyncDDLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncProtector;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.pool.SessionPool;

public class OperationSyncDMLProtector
extends OperationSyncProtector {
    private final OperationSyncDDLProtector ddlProtector;
    private final SessionPool operationSyncSessionPool;

    public OperationSyncDMLProtector(OperationSyncDDLProtector ddlProtector, SessionPool operationSyncSessionPool) {
        this.ddlProtector = ddlProtector;
        this.operationSyncSessionPool = operationSyncSessionPool;
    }

    @Override
    protected void preCheck() {
        while (this.ddlProtector.isAtWork()) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void transmitPhysicalPlan(ByteBuffer planBuffer, PhysicalPlan physicalPlan) {
        while (true) {
            boolean transmitStatus;
            block9: {
                transmitStatus = false;
                if (StorageEngine.isSecondaryAlive().get()) {
                    try {
                        planBuffer.position(0);
                        transmitStatus = this.operationSyncSessionPool.operationSyncTransmit(planBuffer);
                        break block9;
                    }
                    catch (IoTDBConnectionException connectionException) {
                        LOGGER.warn("OperationSyncDMLProtector can't transmit, retrying...", (Throwable)connectionException);
                        break block9;
                    }
                    catch (Exception e) {
                        LOGGER.error("OperationSyncDMLProtector can't transmit", (Throwable)e);
                        break;
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (transmitStatus) break;
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("OperationSyncDMLProtector is interrupted", (Throwable)e);
            }
        }
    }
}

