/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.doublelive.OperationSyncProtector;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncDDLProtector
extends OperationSyncProtector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncDDLProtector.class);
    private final SessionPool operationSyncSessionPool;

    public OperationSyncDDLProtector(SessionPool operationSyncSessionPool) {
        this.operationSyncSessionPool = operationSyncSessionPool;
    }

    @Override
    protected void preCheck() {
    }

    @Override
    protected void transmitPhysicalPlan(ByteBuffer planBuffer, PhysicalPlan physicalPlan) {
        while (true) {
            boolean transmitStatus;
            block9: {
                transmitStatus = false;
                if (StorageEngine.isSecondaryAlive().get()) {
                    try {
                        planBuffer.position(0);
                        transmitStatus = this.operationSyncSessionPool.operationSyncTransmit(planBuffer);
                        break block9;
                    }
                    catch (IoTDBConnectionException connectionException) {
                        LOGGER.warn("OperationSyncDDLProtector can't transmit, retrying...", (Throwable)connectionException);
                        break block9;
                    }
                    catch (Exception e) {
                        LOGGER.error("OperationSyncDDLProtector can't transmit", (Throwable)e);
                        break;
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (transmitStatus) break;
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("OperationSyncDDLProtector is interrupted", (Throwable)e);
            }
        }
    }

    public boolean isAtWork() {
        return this.isProtectorAtWork;
    }
}

