/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.impl;

import com.google.common.base.Joiner;
import java.time.ZoneId;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.rest.GrafanaApiService;
import org.apache.iotdb.db.protocol.rest.NotFoundException;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.model.SQL;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByLevelDataSet;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class GrafanaApiServiceImpl
extends GrafanaApiService {
    private final ServiceProvider serviceProvider = IoTDB.serviceProvider;
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler(this.serviceProvider);
    private final long timePrecision;

    public GrafanaApiServiceImpl() throws QueryProcessException {
        switch (IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                this.timePrecision = 1000000L;
                break;
            }
            case "us": {
                this.timePrecision = 1000L;
                break;
            }
            default: {
                this.timePrecision = 1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response variables(SQL sql, SecurityContext securityContext) {
        RequestValidationHandler.validateSQL(sql);
        PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(sql.getSql());
        if (!(physicalPlan instanceof ShowPlan) && !(physicalPlan instanceof QueryPlan)) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        Response response = this.authorizationHandler.checkAuthority(securityContext, physicalPlan);
        if (response != null) {
            return response;
        }
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryContext queryContext = this.serviceProvider.genQueryContext(queryId, physicalPlan.isDebug(), System.currentTimeMillis(), sql.getSql(), 0L);
            QueryDataSet queryDataSet = this.serviceProvider.createQueryDataSet(queryContext, physicalPlan, 5000);
            Response response2 = QueryDataSetHandler.fillGrafanaVariablesResult(queryDataSet, physicalPlan);
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
            return response2;
        }
        catch (Throwable throwable) {
            try {
                ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                throw throwable;
            }
            catch (Exception e) {
                return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response expression(ExpressionRequest expressionRequest, SecurityContext securityContext) throws NotFoundException {
        try {
            PhysicalPlan physicalPlan;
            Response response;
            RequestValidationHandler.validateExpressionRequest(expressionRequest);
            String expression = Joiner.on((String)",").join((Iterable)expressionRequest.getExpression());
            String prefixPaths = Joiner.on((String)",").join((Iterable)expressionRequest.getPrefixPath());
            long startTime = (long)(expressionRequest.getStartTime().doubleValue() * (double)this.timePrecision);
            long endTime = (long)(expressionRequest.getEndTime().doubleValue() * (double)this.timePrecision);
            String sql = "select " + expression + " from " + prefixPaths + " where timestamp>=" + startTime + " and timestamp<= " + endTime;
            if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getCondition())) {
                sql = sql + " and " + expressionRequest.getCondition();
            }
            if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getControl())) {
                sql = sql + " " + expressionRequest.getControl();
            }
            if ((response = this.authorizationHandler.checkAuthority(securityContext, physicalPlan = this.serviceProvider.getPlanner().parseSQLToGrafanaQueryPlan(sql, ZoneId.systemDefault()))) != null) {
                return response;
            }
            long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
            try {
                QueryContext queryContext = this.serviceProvider.genQueryContext(queryId, physicalPlan.isDebug(), System.currentTimeMillis(), sql, 0L);
                QueryDataSet queryDataSet = this.serviceProvider.createQueryDataSet(queryContext, physicalPlan, 5000);
                if (queryDataSet instanceof GroupByLevelDataSet) {
                    Response response2 = QueryDataSetHandler.fillGroupByLevelDataSet(queryDataSet, 0, this.timePrecision);
                    return response2;
                }
                Response response2 = QueryDataSetHandler.fillDataSetWithTimestamps(queryDataSet, (QueryPlan)physicalPlan, 0, this.timePrecision);
                return response2;
            }
            finally {
                ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
            }
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }

    public Response login(SecurityContext securityContext) throws NotFoundException {
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
    }
}

