/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.virtualSg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.HashVirtualPartitioner;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.VirtualPartitioner;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupManager {
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupManager.class);
    VirtualPartitioner partitioner = HashVirtualPartitioner.getInstance();
    VirtualStorageGroupProcessor[] virtualStorageGroupProcessor;
    private AtomicBoolean[] isVsgReady;
    private AtomicInteger readyVsgNum;
    private AtomicBoolean isSettling = new AtomicBoolean();
    private long monitorSeriesValue;

    public StorageGroupManager() {
        this(false);
    }

    public StorageGroupManager(boolean needRecovering) {
        this.virtualStorageGroupProcessor = new VirtualStorageGroupProcessor[this.partitioner.getPartitionCount()];
        this.isVsgReady = new AtomicBoolean[this.partitioner.getPartitionCount()];
        boolean recoverReady = !needRecovering;
        for (int i = 0; i < this.partitioner.getPartitionCount(); ++i) {
            this.isVsgReady[i] = new AtomicBoolean(recoverReady);
        }
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void syncCloseAllWorkingTsFileProcessors() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void checkTTL() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.checkFilesTTL();
        }
    }

    public void timedFlushSeqMemTable() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.timedFlushSeqMemTable();
        }
    }

    public void timedFlushUnseqMemTable() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.timedFlushUnseqMemTable();
        }
    }

    public void timedCloseTsFileProcessor() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.timedCloseTsFileProcessor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualStorageGroupProcessor getProcessor(PartialPath partialPath, IStorageGroupMNode storageGroupMNode) throws StorageGroupProcessorException, StorageEngineException {
        int loc = this.partitioner.deviceToVirtualStorageGroupId(partialPath);
        VirtualStorageGroupProcessor processor = this.virtualStorageGroupProcessor[loc];
        if (processor == null) {
            if (this.isVsgReady[loc].get()) {
                AtomicBoolean atomicBoolean = this.isVsgReady[loc];
                synchronized (atomicBoolean) {
                    processor = this.virtualStorageGroupProcessor[loc];
                    if (processor == null) {
                        this.virtualStorageGroupProcessor[loc] = processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(loc));
                    }
                }
            } else {
                throw new StorageGroupNotReadyException(storageGroupMNode.getFullPath(), TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode());
            }
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualStorageGroupProcessor getProcessor(int virtualStorageGroupId, IStorageGroupMNode storageGroupMNode) throws StorageGroupProcessorException, StorageEngineException {
        VirtualStorageGroupProcessor processor = this.virtualStorageGroupProcessor[virtualStorageGroupId];
        if (processor == null) {
            if (this.isVsgReady[virtualStorageGroupId].get()) {
                IStorageGroupMNode iStorageGroupMNode = storageGroupMNode;
                synchronized (iStorageGroupMNode) {
                    processor = this.virtualStorageGroupProcessor[virtualStorageGroupId];
                    if (processor == null) {
                        this.virtualStorageGroupProcessor[virtualStorageGroupId] = processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(virtualStorageGroupId));
                    }
                }
            } else {
                throw new StorageGroupNotReadyException(storageGroupMNode.getFullPath(), TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode());
            }
        }
        return processor;
    }

    public void asyncRecover(IStorageGroupMNode storageGroupMNode, ExecutorService pool, List<Future<Void>> futures) {
        this.readyVsgNum = new AtomicInteger(0);
        int i = 0;
        while (i < this.partitioner.getPartitionCount()) {
            int cur = i++;
            Callable<Void> recoverVsgTask = () -> {
                this.isVsgReady[cur].set(false);
                VirtualStorageGroupProcessor processor = null;
                try {
                    processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(cur));
                }
                catch (StorageGroupProcessorException e) {
                    logger.error("Failed to recover virtual storage group {}[{}]", new Object[]{storageGroupMNode.getFullPath(), cur, e});
                }
                this.virtualStorageGroupProcessor[cur] = processor;
                this.isVsgReady[cur].set(true);
                logger.info("Storage Group {} has been recovered {}/{}", new Object[]{storageGroupMNode.getFullPath(), this.readyVsgNum.incrementAndGet(), this.partitioner.getPartitionCount()});
                return null;
            };
            futures.add(pool.submit(recoverVsgTask));
        }
    }

    public long getMonitorSeriesValue() {
        return this.monitorSeriesValue;
    }

    public void setMonitorSeriesValue(long monitorSeriesValue) {
        this.monitorSeriesValue = monitorSeriesValue;
    }

    public void updateMonitorSeriesValue(int successPointsNum) {
        this.monitorSeriesValue += (long)successPointsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(boolean isSeq, boolean isSync) {
        for (VirtualStorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("{} closing sg processor is called for closing {}, seq = {}", new Object[]{isSync ? "sync" : "async", processor.getVirtualStorageGroupId() + "-" + processor.getLogicalStorageGroupName(), isSeq});
            }
            processor.writeLock("VirtualCloseStorageGroupProcessor-204");
            try {
                if (isSeq) {
                    for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors())) {
                        if (isSync) {
                            processor.syncCloseOneTsFileProcessor(true, tsfileProcessor);
                            continue;
                        }
                        processor.asyncCloseOneTsFileProcessor(true, tsfileProcessor);
                    }
                    continue;
                }
                for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors())) {
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(false, tsfileProcessor);
                        continue;
                    }
                    processor.asyncCloseOneTsFileProcessor(false, tsfileProcessor);
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(long partitionId, boolean isSeq, boolean isSync) {
        block3: for (VirtualStorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            logger.info("async closing sg processor is called for closing {}, seq = {}, partitionId = {}", new Object[]{processor.getVirtualStorageGroupId() + "-" + processor.getLogicalStorageGroupName(), isSeq, partitionId});
            processor.writeLock("VirtualCloseStorageGroupProcessor-242");
            try {
                ArrayList<TsFileProcessor> processors = isSeq ? new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors()) : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors());
                for (TsFileProcessor tsfileProcessor : processors) {
                    if (tsfileProcessor.getTimeRangeId() != partitionId) continue;
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                        continue block3;
                    }
                    processor.asyncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                    continue block3;
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex, VirtualStorageGroupProcessor.TimePartitionFilter timePartitionFilter) throws IOException {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.delete(path, startTime, endTime, planIndex, timePartitionFilter);
        }
    }

    public int countUpgradeFiles() {
        int totalUpgradeFileNum = 0;
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            totalUpgradeFileNum += virtualStorageGroupProcessor.countUpgradeFiles();
        }
        return totalUpgradeFileNum;
    }

    public void upgradeAll() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.upgrade();
        }
    }

    public void getResourcesToBeSettled(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.addSettleFilesToList(seqResourcesToBeSettled, unseqResourcesToBeSettled, tsFilePaths);
        }
    }

    public void mergeAll() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.compact();
        }
    }

    public void syncDeleteDataFiles() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.syncDeleteDataFiles();
        }
    }

    public void setTTL(long dataTTL) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.setDataTTL(dataTTL);
        }
    }

    public void deleteStorageGroupSystemFolder(String path) {
        for (VirtualStorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            processor.deleteFolder(path);
        }
    }

    public void getAllClosedStorageGroupTsFile(PartialPath storageGroupName, Map<PartialPath, Map<Long, List<TsFileResource>>> ret) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            List<TsFileResource> allResources = virtualStorageGroupProcessor.getSequenceFileTreeSet();
            allResources.addAll(virtualStorageGroupProcessor.getUnSequenceFileList());
            for (TsFileResource tsfile : allResources) {
                if (!tsfile.isClosed()) continue;
                long partitionNum = tsfile.getTimePartition();
                Map storageGroupFiles = ret.computeIfAbsent(storageGroupName, n -> new HashMap());
                storageGroupFiles.computeIfAbsent(partitionNum, n -> new ArrayList()).add(tsfile);
            }
        }
    }

    public void setPartitionVersionToMax(long partitionId, long newMaxVersion) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.setPartitionFileVersionToMax(partitionId, newMaxVersion);
        }
    }

    public void removePartitions(VirtualStorageGroupProcessor.TimePartitionFilter filter) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.removePartitions(filter);
        }
    }

    public void getWorkingStorageGroupPartitions(String storageGroupName, Map<String, List<Pair<Long, Boolean>>> res) {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            Pair tmpPair;
            if (virtualStorageGroupProcessor == null) continue;
            ArrayList<Pair> partitionIdList = new ArrayList<Pair>();
            for (TsFileProcessor tsFileProcessor : virtualStorageGroupProcessor.getWorkSequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)true);
                partitionIdList.add(tmpPair);
            }
            for (TsFileProcessor tsFileProcessor : virtualStorageGroupProcessor.getWorkUnsequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)false);
                partitionIdList.add(tmpPair);
            }
            res.put(storageGroupName, partitionIdList);
        }
    }

    public void releaseWalDirectByteBufferPool() {
        for (VirtualStorageGroupProcessor virtualStorageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (virtualStorageGroupProcessor == null) continue;
            virtualStorageGroupProcessor.releaseWalDirectByteBufferPool();
        }
    }

    public void reset() {
        Arrays.fill(this.virtualStorageGroupProcessor, null);
    }

    public void stopSchedulerPool() {
        for (VirtualStorageGroupProcessor vsg : this.virtualStorageGroupProcessor) {
            if (vsg == null) continue;
            ThreadUtils.stopThreadPool(vsg.getTimedCompactionScheduleTask(), ThreadName.COMPACTION_SCHEDULE);
            ThreadUtils.stopThreadPool(vsg.getWALTrimScheduleTask(), ThreadName.WAL_TRIM);
        }
    }

    public void setSettling(boolean settling) {
        this.isSettling.set(settling);
    }

    public AtomicBoolean getIsSettling() {
        return this.isSettling;
    }
}

