/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class InnerSpaceCompactionWriter
extends AbstractCompactionWriter {
    private TsFileIOWriter fileWriter;
    private boolean isEmptyFile;

    public InnerSpaceCompactionWriter(TsFileResource targetFileResource) throws IOException {
        this.fileWriter = new TsFileIOWriter(targetFileResource.getTsFile());
        this.isEmptyFile = true;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.flushChunkToFileWriter(this.fileWriter, subTaskId);
    }

    @Override
    public void write(long timestamp, Object value, int subTaskId) throws IOException {
        this.writeDataPoint(timestamp, value, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, subTaskId);
        this.isEmptyFile = false;
    }

    @Override
    public void write(long[] timestamps, Object values) {
    }

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.fileWriter.getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public List<TsFileIOWriter> getFileIOWriter() {
        return Collections.singletonList(this.fileWriter);
    }
}

