/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.doublelive.OperationSyncConsumer;
import org.apache.iotdb.db.doublelive.OperationSyncDDLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncDMLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncLogService;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.db.doublelive.OperationSyncProducer;
import org.apache.iotdb.db.doublelive.OperationSyncWriteTask;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.StorageGroupManager;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.ShutdownException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.session.util.SystemStatus;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEngine
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StorageEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long TTL_CHECK_INTERVAL = 60000L;
    private static final long HEARTBEAT_CHECK_INTERVAL = 30L;
    private static final long SECONDARY_METRIC_INTERVAL = 30L;
    private static final boolean isEnableOperationSync = IoTDBDescriptor.getInstance().getConfig().isEnableOperationSync();
    private static SessionPool operationSyncSessionPool;
    private static OperationSyncProducer operationSyncProducer;
    private static OperationSyncDDLProtector operationSyncDDLProtector;
    private static OperationSyncLogService operationSyncDDLLogService;
    private static AtomicBoolean isSecondaryAlive;
    private static long timePartitionInterval;
    private static boolean enablePartition;
    private final boolean enableMemControl = config.isEnableMemControl();
    private final String systemDir = FilePathUtils.regularizePath((String)config.getSystemDir()) + "storage_groups";
    private final ConcurrentHashMap<PartialPath, StorageGroupManager> processorMap = new ConcurrentHashMap();
    private AtomicBoolean isAllSgReady = new AtomicBoolean(false);
    private ScheduledExecutorService ttlCheckThread;
    private ScheduledExecutorService seqMemtableTimedFlushCheckThread;
    private ScheduledExecutorService unseqMemtableTimedFlushCheckThread;
    private ScheduledExecutorService tsFileTimedCloseCheckThread;
    private TsFileFlushPolicy fileFlushPolicy = new TsFileFlushPolicy.DirectFlushPolicy();
    private ExecutorService recoveryThreadPool;
    private List<CloseFileListener> customCloseFileListeners = new ArrayList<CloseFileListener>();
    private List<FlushListener> customFlushListeners = new ArrayList<FlushListener>();
    ArrayList<BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>>> arrayListBlockQueue;

    private StorageEngine() {
        if (isEnableOperationSync) {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            int cacheNum = config.getOperationSyncProducerCacheNum();
            operationSyncSessionPool = new SessionPool(config.getSecondaryAddress(), config.getSecondaryPort(), config.getSecondaryUser(), config.getSecondaryPassword(), config.getSecondarySessionPoolMaxSize(), config.isRpcThriftCompressionEnable());
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(cacheNum + 5, cacheNum + 5, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5), new ThreadPoolExecutor.AbortPolicy());
            ScheduledExecutorService secondaryCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("secondary-Check");
            secondaryCheckThread.scheduleAtFixedRate(this::checkSecondaryIsLife, 0L, 30L, TimeUnit.SECONDS);
            operationSyncDDLProtector = new OperationSyncDDLProtector(operationSyncSessionPool);
            threadPool.execute(operationSyncDDLProtector);
            operationSyncDDLLogService = new OperationSyncLogService("OperationSyncDDLLog", operationSyncDDLProtector);
            threadPool.execute(operationSyncDDLLogService);
            this.arrayListBlockQueue = new ArrayList(cacheNum);
            for (int i = 0; i < cacheNum; ++i) {
                ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(config.getOperationSyncProducerCacheSize());
                this.arrayListBlockQueue.add(blockingQueue);
            }
            OperationSyncDMLProtector operationSyncDMLProtector = new OperationSyncDMLProtector(operationSyncDDLProtector, operationSyncSessionPool);
            threadPool.execute(operationSyncDMLProtector);
            OperationSyncLogService operationSyncDMLLogService = new OperationSyncLogService("OperationSyncDMLLog", operationSyncDMLProtector);
            operationSyncProducer = new OperationSyncProducer(this.arrayListBlockQueue, operationSyncDMLLogService);
            threadPool.execute(operationSyncDMLLogService);
            for (int i = 0; i < cacheNum; ++i) {
                threadPool.execute(new OperationSyncConsumer(this.arrayListBlockQueue.get(i), operationSyncSessionPool, operationSyncDMLLogService));
            }
            if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                ScheduledExecutorService secondaryMetricThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("secondary-Metric");
                secondaryMetricThread.scheduleAtFixedRate(this::secondaryMetric, 0L, 30L, TimeUnit.SECONDS);
            }
            logger.info("Successfully initialize OperationSync!");
        } else {
            operationSyncSessionPool = null;
            operationSyncProducer = null;
            operationSyncDDLProtector = null;
            operationSyncDDLLogService = null;
            this.arrayListBlockQueue = null;
        }
    }

    public static StorageEngine getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static void initTimePartition() {
        timePartitionInterval = StorageEngine.convertMilliWithPrecision(IoTDBDescriptor.getInstance().getConfig().getPartitionInterval() * 1000L);
    }

    public static void transmitOperationSync(PhysicalPlan physicalPlan) {
        ByteBuffer buffer;
        OperationSyncPlanTypeUtils.OperationSyncPlanType planType = OperationSyncPlanTypeUtils.getOperationSyncPlanType(physicalPlan);
        if (planType == null) {
            return;
        }
        try {
            int size = physicalPlan.getSerializedSize();
            ByteArrayOutputStream operationSyncByteStream = new ByteArrayOutputStream(size);
            DataOutputStream operationSyncSerializeStream = new DataOutputStream(operationSyncByteStream);
            physicalPlan.serialize(operationSyncSerializeStream);
            buffer = ByteBuffer.wrap(operationSyncByteStream.toByteArray());
        }
        catch (IOException e) {
            logger.error("OperationSync can't serialize PhysicalPlan", (Throwable)e);
            return;
        }
        switch (planType) {
            case DDLPlan: {
                OperationSyncWriteTask ddlTask = new OperationSyncWriteTask(buffer, operationSyncSessionPool, operationSyncDDLProtector, operationSyncDDLLogService);
                ddlTask.run();
                break;
            }
            case DMLPlan: {
                operationSyncProducer.put((Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>)new Pair((Object)buffer, (Object)planType), StorageEngine.getDeviceNameByPlan(physicalPlan));
            }
        }
    }

    public static long convertMilliWithPrecision(long milliTime) {
        String timePrecision;
        long result = milliTime;
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                result = milliTime * 1000000L;
                break;
            }
            case "us": {
                result = milliTime * 1000L;
                break;
            }
        }
        return result;
    }

    public static String getDeviceNameByPlan(PhysicalPlan plan) {
        if (plan instanceof InsertPlan) {
            InsertPlan physicalPlan = (InsertPlan)plan;
            if (physicalPlan.getDevicePath() == null) {
                if (physicalPlan.getPaths() != null && physicalPlan.getPaths().size() > 0) {
                    return physicalPlan.getPaths().get(0).getDevice();
                }
                return null;
            }
            return physicalPlan.getDevicePath().getDevice();
        }
        return null;
    }

    public static AtomicBoolean isSecondaryAlive() {
        return isSecondaryAlive;
    }

    public static long getTimePartitionInterval() {
        if (timePartitionInterval == -1L) {
            StorageEngine.initTimePartition();
        }
        return timePartitionInterval;
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        StorageEngine.timePartitionInterval = timePartitionInterval;
    }

    public static long getTimePartition(long time) {
        return enablePartition ? time / timePartitionInterval : 0L;
    }

    public static boolean isEnablePartition() {
        return enablePartition;
    }

    public static void setEnablePartition(boolean enablePartition) {
        StorageEngine.enablePartition = enablePartition;
    }

    public static void blockInsertionIfReject(TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long startTime = System.currentTimeMillis();
        while (SystemInfo.getInstance().isRejected() && (tsFileProcessor == null || !tsFileProcessor.shouldFlush())) {
            try {
                TimeUnit.MILLISECONDS.sleep(config.getCheckPeriodWhenInsertBlocked());
                if (System.currentTimeMillis() - startTime <= (long)config.getMaxWaitingTimeWhenInsertBlocked()) continue;
                throw new WriteProcessRejectException("System rejected over " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isAllSgReady() {
        return this.isAllSgReady.get();
    }

    public void setAllSgReady(boolean allSgReady) {
        this.isAllSgReady.set(allSgReady);
    }

    public void recover() {
        this.setAllSgReady(false);
        this.recoveryThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "Recovery-Thread-Pool");
        List<IStorageGroupMNode> sgNodes = IoTDB.metaManager.getAllStorageGroupNodes();
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        for (IStorageGroupMNode storageGroup : sgNodes) {
            StorageGroupManager storageGroupManager = this.processorMap.computeIfAbsent(storageGroup.getPartialPath(), id -> new StorageGroupManager(true));
            storageGroupManager.asyncRecover(storageGroup, this.recoveryThreadPool, futures);
        }
        Thread recoverEndTrigger = new Thread(() -> {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
            }
            this.recoveryThreadPool.shutdown();
            this.setAllSgReady(true);
        });
        recoverEndTrigger.start();
    }

    @Override
    public void start() {
        if (!enablePartition) {
            timePartitionInterval = Long.MAX_VALUE;
        } else {
            StorageEngine.initTimePartition();
        }
        try {
            FileUtils.forceMkdir((File)SystemFileFactory.INSTANCE.getFile(this.systemDir));
        }
        catch (IOException e) {
            throw new StorageEngineFailureException(e);
        }
        UpgradeUtils.recoverUpgrade();
        this.recover();
        this.ttlCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("TTL-Check");
        this.ttlCheckThread.scheduleAtFixedRate(this::checkTTL, 60000L, 60000L, TimeUnit.MILLISECONDS);
        logger.info("start ttl check thread successfully.");
        this.startTimedService();
    }

    private void checkSecondaryIsLife() {
        try {
            isSecondaryAlive.set(operationSyncSessionPool.getSystemStatus() == SystemStatus.NORMAL);
        }
        catch (IoTDBConnectionException e) {
            isSecondaryAlive.set(false);
        }
    }

    private void secondaryMetric() {
        for (int i = 0; i < this.arrayListBlockQueue.size(); ++i) {
            MetricService.getInstance().getOrCreateGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "OperationSyncProducerQueueSize" + i, Tag.STATUS.toString(), "running"}).set((long)this.arrayListBlockQueue.get(i).size());
        }
    }

    private void checkTTL() {
        try {
            IoTDB.metaManager.checkTTLOnLastCache();
            for (StorageGroupManager processor : this.processorMap.values()) {
                processor.checkTTL();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            logger.error("An error occurred when checking TTL", (Throwable)e);
        }
    }

    private void startTimedService() {
        if (config.isEnableTimedFlushSeqMemtable()) {
            this.seqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(ThreadName.TIMED_FlUSH_SEQ_MEMTABLE.getName());
            this.seqMemtableTimedFlushCheckThread.scheduleAtFixedRate(this::timedFlushSeqMemTable, config.getSeqMemtableFlushCheckInterval(), config.getSeqMemtableFlushCheckInterval(), TimeUnit.MILLISECONDS);
            logger.info("start sequence memtable timed flush check thread successfully.");
        }
        if (config.isEnableTimedFlushUnseqMemtable()) {
            this.unseqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE.getName());
            this.unseqMemtableTimedFlushCheckThread.scheduleAtFixedRate(this::timedFlushUnseqMemTable, config.getUnseqMemtableFlushCheckInterval(), config.getUnseqMemtableFlushCheckInterval(), TimeUnit.MILLISECONDS);
            logger.info("start unsequence memtable timed flush check thread successfully.");
        }
        if (config.isEnableTimedCloseTsFile()) {
            this.tsFileTimedCloseCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(ThreadName.TIMED_CLOSE_TSFILE.getName());
            this.tsFileTimedCloseCheckThread.scheduleAtFixedRate(this::timedCloseTsFileProcessor, config.getCloseTsFileCheckInterval(), config.getCloseTsFileCheckInterval(), TimeUnit.MILLISECONDS);
            logger.info("start tsfile timed close check thread successfully.");
        }
    }

    private void timedFlushSeqMemTable() {
        try {
            for (StorageGroupManager processor : this.processorMap.values()) {
                processor.timedFlushSeqMemTable();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred when timed flushing sequence memtables", (Throwable)e);
        }
    }

    private void timedFlushUnseqMemTable() {
        try {
            for (StorageGroupManager processor : this.processorMap.values()) {
                processor.timedFlushUnseqMemTable();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred when timed flushing unsequence memtables", (Throwable)e);
        }
    }

    private void timedCloseTsFileProcessor() {
        try {
            for (StorageGroupManager processor : this.processorMap.values()) {
                processor.timedCloseTsFileProcessor();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred when timed closing tsfiles interval", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.stopSchedulerPool();
        }
        this.syncCloseAllProcessor();
        ThreadUtils.stopThreadPool(this.ttlCheckThread, ThreadName.TTL_CHECK_SERVICE);
        ThreadUtils.stopThreadPool(this.seqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_SEQ_MEMTABLE);
        ThreadUtils.stopThreadPool(this.unseqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE);
        ThreadUtils.stopThreadPool(this.tsFileTimedCloseCheckThread, ThreadName.TIMED_CLOSE_TSFILE);
        this.recoveryThreadPool.shutdownNow();
        for (PartialPath storageGroup : IoTDB.metaManager.getAllStorageGroupPaths()) {
            this.releaseWalDirectByteBufferPoolInOneStorageGroup(storageGroup);
        }
        this.processorMap.clear();
    }

    @Override
    public void shutdown(long milliseconds) throws ShutdownException {
        try {
            for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
                storageGroupManager.stopSchedulerPool();
            }
            this.forceCloseAllProcessor();
        }
        catch (TsFileProcessorException e) {
            throw new ShutdownException(e);
        }
        this.shutdownTimedService(this.ttlCheckThread, "TTlCheckThread");
        this.shutdownTimedService(this.seqMemtableTimedFlushCheckThread, "SeqMemtableTimedFlushCheckThread");
        this.shutdownTimedService(this.unseqMemtableTimedFlushCheckThread, "UnseqMemtableTimedFlushCheckThread");
        this.shutdownTimedService(this.tsFileTimedCloseCheckThread, "TsFileTimedCloseCheckThread");
        this.recoveryThreadPool.shutdownNow();
        this.processorMap.clear();
    }

    private void shutdownTimedService(ScheduledExecutorService pool, String poolName) {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void rebootTimedService() throws ShutdownException {
        logger.info("Start rebooting all timed service.");
        this.stopTimedServiceAndThrow(this.seqMemtableTimedFlushCheckThread, "SeqMemtableTimedFlushCheckThread");
        this.stopTimedServiceAndThrow(this.unseqMemtableTimedFlushCheckThread, "UnseqMemtableTimedFlushCheckThread");
        this.stopTimedServiceAndThrow(this.tsFileTimedCloseCheckThread, "TsFileTimedCloseCheckThread");
        logger.info("Stop all timed service successfully, and now restart them.");
        this.startTimedService();
        logger.info("Reboot all timed service successfully");
    }

    private void stopTimedServiceAndThrow(ScheduledExecutorService pool, String poolName) throws ShutdownException {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                throw new ShutdownException(e);
            }
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.STORAGE_ENGINE_SERVICE;
    }

    public VirtualStorageGroupProcessor getProcessorDirectly(PartialPath path) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.metaManager.getStorageGroupNodeByPath(path);
            PartialPath storageGroupPath = storageGroupMNode.getPartialPath();
            return this.getStorageGroupProcessorByPath(storageGroupPath, storageGroupMNode);
        }
        catch (StorageGroupProcessorException | MetadataException e) {
            throw new StorageEngineException(e);
        }
    }

    public VirtualStorageGroupProcessor getProcessorDirectly(PartialPath path, int virtualStorageGroupId) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.metaManager.getStorageGroupNodeByPath(path);
            return this.getStorageGroupProcessorById(virtualStorageGroupId, storageGroupMNode);
        }
        catch (StorageGroupProcessorException | MetadataException e) {
            throw new StorageEngineException(e);
        }
    }

    public VirtualStorageGroupProcessor getProcessor(PartialPath path) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.metaManager.getStorageGroupNodeByPath(path);
            return this.getStorageGroupProcessorByPath(path, storageGroupMNode);
        }
        catch (StorageGroupProcessorException | MetadataException e) {
            throw new StorageEngineException(e);
        }
    }

    public List<String> getLockInfo(List<PartialPath> pathList) throws StorageEngineException {
        try {
            ArrayList<String> lockHolderList = new ArrayList<String>(pathList.size());
            for (PartialPath path : pathList) {
                IStorageGroupMNode storageGroupMNode = IoTDB.metaManager.getStorageGroupNodeByPath(path);
                VirtualStorageGroupProcessor virtualStorageGroupProcessor = this.getStorageGroupProcessorByPath(path, storageGroupMNode);
                lockHolderList.add(virtualStorageGroupProcessor.getInsertWriteLockHolder());
            }
            return lockHolderList;
        }
        catch (StorageGroupProcessorException | MetadataException e) {
            throw new StorageEngineException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualStorageGroupProcessor getStorageGroupProcessorByPath(PartialPath devicePath, IStorageGroupMNode storageGroupMNode) throws StorageGroupProcessorException, StorageEngineException {
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
        if (storageGroupManager == null) {
            StorageEngine storageEngine = this;
            synchronized (storageEngine) {
                storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
                if (storageGroupManager == null) {
                    storageGroupManager = new StorageGroupManager();
                    this.processorMap.put(storageGroupMNode.getPartialPath(), storageGroupManager);
                }
            }
        }
        return storageGroupManager.getProcessor(devicePath, storageGroupMNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualStorageGroupProcessor getStorageGroupProcessorById(int virtualStorageGroupId, IStorageGroupMNode storageGroupMNode) throws StorageGroupProcessorException, StorageEngineException {
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
        if (storageGroupManager == null) {
            StorageEngine storageEngine = this;
            synchronized (storageEngine) {
                storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
                if (storageGroupManager == null) {
                    storageGroupManager = new StorageGroupManager();
                    this.processorMap.put(storageGroupMNode.getPartialPath(), storageGroupManager);
                }
            }
        }
        return storageGroupManager.getProcessor(virtualStorageGroupId, storageGroupMNode);
    }

    public VirtualStorageGroupProcessor buildNewStorageGroupProcessor(PartialPath logicalStorageGroupName, IStorageGroupMNode storageGroupMNode, String virtualStorageGroupId) throws StorageGroupProcessorException {
        logger.info("construct a processor instance, the storage group is {}, Thread is {}", (Object)logicalStorageGroupName, (Object)Thread.currentThread().getId());
        VirtualStorageGroupProcessor processor = new VirtualStorageGroupProcessor(this.systemDir + File.separator + logicalStorageGroupName, virtualStorageGroupId, this.fileFlushPolicy, storageGroupMNode.getFullPath());
        processor.setDataTTL(storageGroupMNode.getDataTTL());
        processor.setCustomFlushListeners(this.customFlushListeners);
        processor.setCustomCloseFileListeners(this.customCloseFileListeners);
        return processor;
    }

    public synchronized void reset() {
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.reset();
        }
    }

    public void insert(InsertRowPlan insertRowPlan) throws StorageEngineException, MetadataException {
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessException e) {
                throw new StorageEngineException(e);
            }
        }
        VirtualStorageGroupProcessor virtualStorageGroupProcessor = this.getProcessor(insertRowPlan.getDevicePath());
        this.getSeriesSchemas(insertRowPlan, virtualStorageGroupProcessor);
        try {
            insertRowPlan.transferType();
        }
        catch (QueryProcessException e) {
            throw new StorageEngineException(e);
        }
        try {
            virtualStorageGroupProcessor.insert(insertRowPlan);
        }
        catch (WriteProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    public void insert(InsertRowsOfOneDevicePlan insertRowsOfOneDevicePlan) throws StorageEngineException, MetadataException {
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessException e) {
                throw new StorageEngineException(e);
            }
        }
        VirtualStorageGroupProcessor virtualStorageGroupProcessor = this.getProcessor(insertRowsOfOneDevicePlan.getDevicePath());
        for (InsertRowPlan plan : insertRowsOfOneDevicePlan.getRowPlans()) {
            plan.setMeasurementMNodes(new IMeasurementMNode[plan.getMeasurements().length]);
            this.getSeriesSchemas(plan, virtualStorageGroupProcessor);
        }
        try {
            virtualStorageGroupProcessor.insert(insertRowsOfOneDevicePlan);
        }
        catch (WriteProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    public void insertTablet(InsertTabletPlan insertTabletPlan) throws StorageEngineException, BatchProcessException, MetadataException {
        VirtualStorageGroupProcessor virtualStorageGroupProcessor;
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessRejectException e) {
                Object[] results = new TSStatus[insertTabletPlan.getRowCount()];
                Arrays.fill(results, RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT));
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        try {
            virtualStorageGroupProcessor = this.getProcessor(insertTabletPlan.getDevicePath());
        }
        catch (StorageEngineException e) {
            throw new StorageEngineException(String.format("Get StorageGroupProcessor of device %s failed", insertTabletPlan.getDevicePath()), e);
        }
        this.getSeriesSchemas(insertTabletPlan, virtualStorageGroupProcessor);
        virtualStorageGroupProcessor.insertTablet(insertTabletPlan);
    }

    public void syncCloseAllProcessor() {
        logger.info("Start closing all storage group processor");
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void forceCloseAllProcessor() throws TsFileProcessorException {
        logger.info("Start force closing all storage group processor");
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void closeStorageGroupProcessor(PartialPath storageGroupPath, boolean isSeq, boolean isSync) {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            return;
        }
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupPath);
        storageGroupManager.closeStorageGroupProcessor(isSeq, isSync);
    }

    public void closeStorageGroupProcessor(PartialPath storageGroupPath, long partitionId, boolean isSeq, boolean isSync) throws StorageGroupNotSetException {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
        }
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupPath);
        storageGroupManager.closeStorageGroupProcessor(partitionId, isSeq, isSync);
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex, VirtualStorageGroupProcessor.TimePartitionFilter timePartitionFilter) throws StorageEngineException {
        try {
            List<PartialPath> sgPaths = IoTDB.metaManager.getBelongedStorageGroups(path);
            for (PartialPath storageGroupPath : sgPaths) {
                if (!this.processorMap.containsKey(storageGroupPath)) continue;
                List<PartialPath> possiblePaths = path.alterPrefixPath(storageGroupPath);
                for (PartialPath possiblePath : possiblePaths) {
                    this.processorMap.get(storageGroupPath).delete(possiblePath, startTime, endTime, planIndex, timePartitionFilter);
                }
            }
        }
        catch (IOException | MetadataException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public void deleteTimeseries(PartialPath path, long planIndex, VirtualStorageGroupProcessor.TimePartitionFilter timePartitionFilter) throws StorageEngineException {
        try {
            List<PartialPath> sgPaths = IoTDB.metaManager.getBelongedStorageGroups(path);
            for (PartialPath storageGroupPath : sgPaths) {
                if (!this.processorMap.containsKey(storageGroupPath)) continue;
                List<PartialPath> possiblePaths = path.alterPrefixPath(storageGroupPath);
                for (PartialPath possiblePath : possiblePaths) {
                    this.processorMap.get(storageGroupPath).delete(possiblePath, Long.MIN_VALUE, Long.MAX_VALUE, planIndex, timePartitionFilter);
                }
            }
        }
        catch (IOException | MetadataException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public int countUpgradeFiles() {
        int totalUpgradeFileNum = 0;
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            totalUpgradeFileNum += storageGroupManager.countUpgradeFiles();
        }
        return totalUpgradeFileNum;
    }

    public void upgradeAll() throws StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support file upgrade");
        }
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.upgradeAll();
        }
    }

    public void getResourcesToBeSettled(PartialPath sgPath, List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) throws StorageEngineException {
        StorageGroupManager vsg = this.processorMap.get(sgPath);
        if (vsg == null) {
            throw new StorageEngineException("The Storage Group " + sgPath.toString() + " is not existed.");
        }
        if (!vsg.getIsSettling().compareAndSet(false, true)) {
            throw new StorageEngineException("Storage Group " + sgPath.getFullPath() + " is already being settled now.");
        }
        vsg.getResourcesToBeSettled(seqResourcesToBeSettled, unseqResourcesToBeSettled, tsFilePaths);
    }

    public void setSettling(PartialPath sgPath, boolean isSettling) {
        if (this.processorMap.get(sgPath) == null) {
            return;
        }
        this.processorMap.get(sgPath).setSettling(isSettling);
    }

    public void mergeAll() throws StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support merge");
        }
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.mergeAll();
        }
    }

    public void deleteAllDataFilesInOneStorageGroup(PartialPath storageGroupPath) {
        if (this.processorMap.containsKey(storageGroupPath)) {
            this.syncDeleteDataFiles(storageGroupPath);
        }
    }

    private void syncDeleteDataFiles(PartialPath storageGroupPath) {
        logger.info("Force to delete the data in storage group processor {}", (Object)storageGroupPath);
        this.processorMap.get(storageGroupPath).syncDeleteDataFiles();
    }

    public void releaseWalDirectByteBufferPoolInOneStorageGroup(PartialPath storageGroupPath) {
        if (this.processorMap.containsKey(storageGroupPath)) {
            this.processorMap.get(storageGroupPath).releaseWalDirectByteBufferPool();
        }
    }

    public synchronized boolean deleteAll() {
        logger.info("Start deleting all storage groups' timeseries");
        this.syncCloseAllProcessor();
        for (PartialPath storageGroup : IoTDB.metaManager.getAllStorageGroupPaths()) {
            this.deleteAllDataFilesInOneStorageGroup(storageGroup);
        }
        this.processorMap.clear();
        return true;
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) {
        if (!this.processorMap.containsKey(storageGroup)) {
            return;
        }
        this.processorMap.get(storageGroup).setTTL(dataTTL);
    }

    public void deleteStorageGroup(PartialPath storageGroupPath) {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            return;
        }
        this.deleteAllDataFilesInOneStorageGroup(storageGroupPath);
        this.releaseWalDirectByteBufferPoolInOneStorageGroup(storageGroupPath);
        StorageGroupManager storageGroupManager = this.processorMap.remove(storageGroupPath);
        storageGroupManager.deleteStorageGroupSystemFolder(this.systemDir + File.pathSeparator + storageGroupPath);
        storageGroupManager.stopSchedulerPool();
    }

    public void loadNewTsFileForSync(TsFileResource newTsFileResource) throws StorageEngineException, LoadFileException, IllegalPathException {
        this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(newTsFileResource.getTsFile(), false))).loadNewTsFileForSync(newTsFileResource);
    }

    public void loadNewTsFile(TsFileResource newTsFileResource) throws LoadFileException, StorageEngineException, MetadataException {
        Set<String> deviceSet = newTsFileResource.getDevices();
        if (deviceSet == null || deviceSet.isEmpty()) {
            throw new StorageEngineException("The TsFile is empty, cannot be loaded.");
        }
        String device = deviceSet.iterator().next();
        PartialPath devicePath = new PartialPath(device);
        PartialPath storageGroupPath = IoTDB.metaManager.getBelongedStorageGroup(devicePath);
        this.getProcessorDirectly(storageGroupPath).loadNewTsFile(newTsFileResource);
    }

    public boolean deleteTsfileForSync(File deletedTsfile) throws StorageEngineException, IllegalPathException {
        return this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(deletedTsfile, false))).deleteTsfile(deletedTsfile);
    }

    public boolean deleteTsfile(File deletedTsfile) throws StorageEngineException, IllegalPathException {
        return this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(deletedTsfile, true)), this.getVirtualSgIdByEngineFile(deletedTsfile, true)).deleteTsfile(deletedTsfile);
    }

    public boolean unloadTsfile(File tsfileToBeUnloaded, File targetDir) throws StorageEngineException, IllegalPathException {
        return this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(tsfileToBeUnloaded, true)), this.getVirtualSgIdByEngineFile(tsfileToBeUnloaded, true)).unloadTsfile(tsfileToBeUnloaded, targetDir);
    }

    public String getSgByEngineFile(File file, boolean needCheck) throws IllegalPathException {
        if (needCheck) {
            File dataDir = file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            if (dataDir.exists()) {
                String[] dataDirs;
                for (String dir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
                    try {
                        if (!Files.isSameFile(Paths.get(dir, new String[0]), dataDir.toPath())) continue;
                        return file.getParentFile().getParentFile().getParentFile().getName();
                    }
                    catch (IOException e) {
                        throw new IllegalPathException(file.getAbsolutePath(), e.getMessage());
                    }
                }
            }
            throw new IllegalPathException(file.getAbsolutePath(), "it's not an internal tsfile.");
        }
        return file.getParentFile().getParentFile().getParentFile().getName();
    }

    public int getVirtualSgIdByEngineFile(File file, boolean needCheck) throws IllegalPathException {
        if (needCheck) {
            File dataDir = file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            if (dataDir.exists()) {
                String[] dataDirs;
                for (String dir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
                    try {
                        if (!Files.isSameFile(Paths.get(dir, new String[0]), dataDir.toPath())) continue;
                        return Integer.parseInt(file.getParentFile().getParentFile().getName());
                    }
                    catch (IOException e) {
                        throw new IllegalPathException(file.getAbsolutePath(), e.getMessage());
                    }
                }
            }
            throw new IllegalPathException(file.getAbsolutePath(), "it's not an internal tsfile.");
        }
        return Integer.parseInt(file.getParentFile().getParentFile().getName());
    }

    public Map<PartialPath, Map<Long, List<TsFileResource>>> getAllClosedStorageGroupTsFile() {
        HashMap<PartialPath, Map<Long, List<TsFileResource>>> ret = new HashMap<PartialPath, Map<Long, List<TsFileResource>>>();
        for (Map.Entry<PartialPath, StorageGroupManager> entry : this.processorMap.entrySet()) {
            entry.getValue().getAllClosedStorageGroupTsFile(entry.getKey(), ret);
        }
        return ret;
    }

    public void setFileFlushPolicy(TsFileFlushPolicy fileFlushPolicy) {
        this.fileFlushPolicy = fileFlushPolicy;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, PartialPath storageGroup, long partitionNum) {
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroup);
        if (storageGroupManager == null) {
            return false;
        }
        Iterator<String> partialPathIterator = tsFileResource.getDevices().iterator();
        try {
            return this.getProcessor(new PartialPath(partialPathIterator.next())).isFileAlreadyExist(tsFileResource, partitionNum);
        }
        catch (StorageEngineException | IllegalPathException e) {
            logger.error("can't find processor with: " + tsFileResource, (Throwable)e);
            return false;
        }
    }

    public void setPartitionVersionToMax(PartialPath storageGroup, long partitionId, long newMaxVersion) {
        this.processorMap.get(storageGroup).setPartitionVersionToMax(partitionId, newMaxVersion);
    }

    public void removePartitions(PartialPath storageGroupPath, VirtualStorageGroupProcessor.TimePartitionFilter filter) {
        if (this.processorMap.get(storageGroupPath) != null) {
            this.processorMap.get(storageGroupPath).removePartitions(filter);
        }
    }

    public Map<PartialPath, StorageGroupManager> getProcessorMap() {
        return this.processorMap;
    }

    public Map<String, List<Pair<Long, Boolean>>> getWorkingStorageGroupPartitions() {
        ConcurrentHashMap<String, List<Pair<Long, Boolean>>> res = new ConcurrentHashMap<String, List<Pair<Long, Boolean>>>();
        for (Map.Entry<PartialPath, StorageGroupManager> entry : this.processorMap.entrySet()) {
            entry.getValue().getWorkingStorageGroupPartitions(entry.getKey().getFullPath(), res);
        }
        return res;
    }

    public void registerFlushListener(FlushListener listener) {
        this.customFlushListeners.add(listener);
    }

    public void registerCloseFileListener(CloseFileListener listener) {
        this.customCloseFileListeners.add(listener);
    }

    public Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> mergeLock(List<PartialPath> pathList) throws StorageEngineException {
        HashMap<VirtualStorageGroupProcessor, List> map = new HashMap<VirtualStorageGroupProcessor, List>();
        for (PartialPath path : pathList) {
            map.computeIfAbsent(this.getProcessor(path.getDevicePath()), key -> new ArrayList()).add(path);
        }
        List<VirtualStorageGroupProcessor> list = map.keySet().stream().sorted(Comparator.comparing(VirtualStorageGroupProcessor::getVirtualStorageGroupId)).collect(Collectors.toList());
        list.forEach(VirtualStorageGroupProcessor::readLock);
        return new Pair(list, map);
    }

    public void mergeUnLock(List<VirtualStorageGroupProcessor> list) {
        list.forEach(VirtualStorageGroupProcessor::readUnlock);
    }

    public String getStorageGroupPath(PartialPath path) throws StorageEngineException {
        PartialPath deviceId = path.getDevicePath();
        VirtualStorageGroupProcessor storageGroupProcessor = this.getProcessor(deviceId);
        return storageGroupProcessor.getLogicalStorageGroupName() + File.separator + storageGroupProcessor.getVirtualStorageGroupId();
    }

    protected void getSeriesSchemas(InsertPlan insertPlan, VirtualStorageGroupProcessor processor) throws StorageEngineException, MetadataException {
        try {
            if (config.isEnableIDTable()) {
                processor.getIdTable().getSeriesSchemas(insertPlan);
            } else {
                IoTDB.metaManager.getSeriesSchemasAndReadLockDevice(insertPlan);
                insertPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertPlan.getDevicePath()));
            }
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    static {
        isSecondaryAlive = new AtomicBoolean(false);
        timePartitionInterval = -1L;
        enablePartition = config.isEnablePartition();
    }

    static class InstanceHolder {
        private static final StorageEngine INSTANCE = new StorageEngine();

        private InstanceHolder() {
        }
    }
}

