/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.cluster.client.BaseFactory;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncMetaClient
extends TSMetaService.Client {
    private Node node;
    private ClientCategory category;
    private IClientManager clientManager;

    public SyncMetaClient(TProtocolFactory protocolFactory, Node node, ClientCategory category) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, node.getInternalIp(), ClientUtils.getPort(node, category), ClusterConstant.getConnectionTimeoutInMS()))));
        this.node = node;
        this.category = category;
        this.getInputProtocol().getTransport().open();
    }

    public SyncMetaClient(TProtocolFactory protocolFactory, Node node, ClientCategory category, IClientManager manager) throws TTransportException {
        this(protocolFactory, node, category);
        this.clientManager = manager;
    }

    public void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnSyncClient((RaftService.Client)this, this.node, this.category);
        }
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).getTimeOut();
    }

    public void close() {
        this.getInputProtocol().getTransport().close();
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "Sync" + this.category.getName() + "{node=" + this.node + ",port=" + ClientUtils.getPort(this.node, this.category) + '}';
    }

    public static class SyncMetaClientFactory
    extends BaseFactory<Node, SyncMetaClient> {
        public SyncMetaClientFactory(TProtocolFactory protocolFactory, ClientCategory category) {
            super(protocolFactory, category);
        }

        public SyncMetaClientFactory(TProtocolFactory protocolFactory, ClientCategory category, IClientManager clientManager) {
            super(protocolFactory, category, clientManager);
        }

        @Override
        public void activateObject(Node node, PooledObject<SyncMetaClient> pooledObject) {
            ((SyncMetaClient)((Object)pooledObject.getObject())).setTimeout(ClusterConstant.getConnectionTimeoutInMS());
        }

        public void destroyObject(Node node, PooledObject<SyncMetaClient> pooledObject) {
            ((SyncMetaClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<SyncMetaClient> makeObject(Node node) throws Exception {
            return new DefaultPooledObject((Object)new SyncMetaClient(this.protocolFactory, node, this.category, this.clientPoolManager));
        }

        public boolean validateObject(Node node, PooledObject<SyncMetaClient> pooledObject) {
            return pooledObject.getObject() != null && ((SyncMetaClient)((Object)pooledObject.getObject())).getInputProtocol().getTransport().isOpen();
        }
    }
}

