/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.predefined.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.predefined.logback.MetricsTurboFilter;
import org.slf4j.LoggerFactory;

public class LogbackMetrics
implements IMetricSet,
AutoCloseable {
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private final Map<AbstractMetricManager, MetricsTurboFilter> metricsTurboFilters = new HashMap<AbstractMetricManager, MetricsTurboFilter>();

    public LogbackMetrics() {
        this.loggerContext.addListener(new LoggerContextListener(){

            public boolean isResetResistant() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReset(LoggerContext context) {
                Map map = LogbackMetrics.this.metricsTurboFilters;
                synchronized (map) {
                    for (MetricsTurboFilter metricsTurboFilter : LogbackMetrics.this.metricsTurboFilters.values()) {
                        LogbackMetrics.this.loggerContext.addTurboFilter((TurboFilter)metricsTurboFilter);
                    }
                }
            }

            public void onStart(LoggerContext context) {
            }

            public void onStop(LoggerContext context) {
            }

            public void onLevelChange(Logger logger, Level level) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(AbstractMetricManager metricManager) {
        MetricsTurboFilter filter = new MetricsTurboFilter(metricManager);
        Map<AbstractMetricManager, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            this.metricsTurboFilters.put(metricManager, filter);
            this.loggerContext.addTurboFilter((TurboFilter)filter);
        }
    }

    public static void ignoreMetrics(Runnable r) {
        ignoreMetrics.set(true);
        try {
            r.run();
        }
        finally {
            ignoreMetrics.remove();
        }
    }

    @Override
    public PredefinedMetric getType() {
        return PredefinedMetric.LOGBACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Map<AbstractMetricManager, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            for (MetricsTurboFilter metricsTurboFilter : this.metricsTurboFilters.values()) {
                this.loggerContext.getTurboFilterList().remove((Object)metricsTurboFilter);
            }
        }
    }
}

