/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskAlignedChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.MemAlignedChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;

public class FileLoaderUtils {
    private FileLoaderUtils() {
    }

    public static void checkTsFileResource(TsFileResource tsFileResource) throws IOException {
        if (!tsFileResource.resourceFileExists()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFile().getAbsolutePath());){
                FileLoaderUtils.updateTsFileResource(reader, tsFileResource);
            }
            tsFileResource.serialize();
        } else {
            tsFileResource.deserialize();
        }
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
    }

    public static void updateTsFileResource(TsFileSequenceReader reader, TsFileResource tsFileResource) throws IOException {
        for (Map.Entry entry : reader.getAllTimeseriesMetadata().entrySet()) {
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
        tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
    }

    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        TimeseriesMetadata timeSeriesMetadata;
        if (resource.isClosed()) {
            timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFilePath(), seriesPath.getDevice(), seriesPath.getMeasurement()), allSensors, resource.getTimeIndexType() != 1, context.isDebug());
            if (timeSeriesMetadata != null) {
                timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, seriesPath, context, filter));
            }
        } else {
            timeSeriesMetadata = (TimeseriesMetadata)resource.getTimeSeriesMetadata(seriesPath);
            if (timeSeriesMetadata != null) {
                timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, filter));
            }
        }
        if (timeSeriesMetadata != null) {
            List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath);
            timeSeriesMetadata.setModified(!pathModifications.isEmpty());
            if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                return null;
            }
            if (filter != null && !filter.satisfyStartEndTime(timeSeriesMetadata.getStatistics().getStartTime(), timeSeriesMetadata.getStatistics().getEndTime())) {
                return null;
            }
        }
        return timeSeriesMetadata;
    }

    public static AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, AlignedPath vectorPath, QueryContext context, Filter filter) throws IOException {
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata = null;
        if (resource.isClosed()) {
            if (!resource.getTsFile().exists()) {
                return null;
            }
            TimeSeriesMetadataCache cache = TimeSeriesMetadataCache.getInstance();
            List<String> valueMeasurementList = vectorPath.getMeasurementList();
            HashSet<String> allSensors = new HashSet<String>(valueMeasurementList);
            allSensors.add("");
            boolean isDebug = context.isDebug();
            String filePath = resource.getTsFilePath();
            String deviceId = vectorPath.getDevice();
            TimeseriesMetadata timeColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, ""), allSensors, resource.getTimeIndexType() != 1, isDebug);
            if (timeColumn != null) {
                ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>(valueMeasurementList.size());
                boolean exist = false;
                for (String valueMeasurement : valueMeasurementList) {
                    TimeseriesMetadata valueColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, valueMeasurement), allSensors, resource.getTimeIndexType() != 1, isDebug);
                    exist = exist || valueColumn != null;
                    valueTimeSeriesMetadataList.add(valueColumn);
                }
                if (exist) {
                    alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, valueTimeSeriesMetadataList);
                    alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, vectorPath, context, filter));
                }
            }
        } else {
            alignedTimeSeriesMetadata = (AlignedTimeSeriesMetadata)resource.getTimeSeriesMetadata(vectorPath);
            if (alignedTimeSeriesMetadata != null) {
                alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemAlignedChunkMetadataLoader(resource, vectorPath, context, filter));
            }
        }
        if (alignedTimeSeriesMetadata != null) {
            if (alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime() > alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime()) {
                return null;
            }
            if (filter != null && !filter.satisfyStartEndTime(alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime(), alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime())) {
                return null;
            }
            List valueTimeSeriesMetadataList = alignedTimeSeriesMetadata.getValueTimeseriesMetadataList();
            boolean modified = false;
            for (int i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (valueTimeSeriesMetadataList.get(i) == null) continue;
                List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), vectorPath.getPathWithMeasurement(i));
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).setModified(!pathModifications.isEmpty());
                modified = modified || !pathModifications.isEmpty();
            }
            alignedTimeSeriesMetadata.getTimeseriesMetadata().setModified(modified);
        }
        return alignedTimeSeriesMetadata;
    }

    public static List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) throws IOException {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        if (chunkMetaData == null) {
            throw new IOException("Can't init null chunkMeta");
        }
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        IChunkReader chunkReader = chunkLoader.getChunkReader(chunkMetaData, timeFilter);
        return chunkReader.loadPageReaderList();
    }
}

