/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.sync.receiver.load.FileLoader;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.load.IFileLoader;
import org.apache.iotdb.db.sync.receiver.load.LoadType;
import org.apache.iotdb.db.sync.receiver.recover.ISyncReceiverLogAnalyzer;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReceiverLogAnalyzer
implements ISyncReceiverLogAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncReceiverLogAnalyzer.class);

    private SyncReceiverLogAnalyzer() {
    }

    public static SyncReceiverLogAnalyzer getInstance() {
        return SyncReceiverLogAnalyzerHolder.INSTANCE;
    }

    @Override
    public void recoverAll() throws IOException {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        LOGGER.info("Start to recover all sync state for sync receiver.");
        for (String dataDir : dataDirs) {
            if (!new File(FilePathUtils.regularizePath((String)dataDir) + "sync-receiver").exists()) continue;
            for (File syncFolder : new File(FilePathUtils.regularizePath((String)dataDir) + "sync-receiver").listFiles()) {
                this.recover(syncFolder);
            }
        }
        LOGGER.info("Finish to recover all sync states for sync receiver.");
    }

    private boolean recover(File senderFolder) throws IOException {
        if (!new File(senderFolder, "sync.log").exists()) {
            new File(senderFolder, "load.log").delete();
            FileUtils.deleteDirectory((File)new File(senderFolder, "data"));
            return true;
        }
        if (FileLoaderManager.getInstance().containsFileLoader(senderFolder.getName())) {
            FileLoaderManager.getInstance().getFileLoader(senderFolder.getName()).endSync();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread is interrupted from waiting for ending sync in recovery.");
                Thread.currentThread().interrupt();
            }
        } else {
            this.scanLogger(FileLoader.createFileLoader(senderFolder), new File(senderFolder, "sync.log"), new File(senderFolder, "load.log"));
        }
        return !FileLoaderManager.getInstance().containsFileLoader(senderFolder.getName());
    }

    @Override
    public boolean recover(String senderName) throws IOException {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        boolean recoverComplete = true;
        for (String dataDir : dataDirs) {
            if (!new File(FilePathUtils.regularizePath((String)dataDir) + "sync-receiver").exists()) continue;
            for (File syncFolder : new File(FilePathUtils.regularizePath((String)dataDir) + "sync-receiver").listFiles()) {
                if (!syncFolder.getName().equals(senderName)) continue;
                recoverComplete &= this.recover(syncFolder);
            }
        }
        return recoverComplete;
    }

    @Override
    public void scanLogger(IFileLoader loader, File syncLog, File loadLog) {
        LoadType loadType = LoadType.NONE;
        try (BufferedReader syncReader = new BufferedReader(new FileReader(syncLog));){
            String line;
            try (BufferedReader loadReader = new BufferedReader(new FileReader(loadLog));){
                while ((line = loadReader.readLine()) != null) {
                    if (line.equals("load deleted files start")) {
                        loadType = LoadType.DELETE;
                        continue;
                    }
                    if (line.equals("load tsfile start")) {
                        loadType = LoadType.ADD;
                        continue;
                    }
                    while (!syncReader.readLine().equals(line)) {
                    }
                }
            }
            loader.setCurType(loadType);
            block26: while ((line = syncReader.readLine()) != null) {
                if (line.equals("sync deleted file names start")) {
                    loadType = LoadType.DELETE;
                    continue;
                }
                if (line.equals("sync tsfile start")) {
                    loadType = LoadType.ADD;
                    continue;
                }
                switch (loadType) {
                    case ADD: {
                        loader.addTsfile(new File(line));
                        continue block26;
                    }
                    case DELETE: {
                        loader.addDeletedFileName(new File(line));
                        continue block26;
                    }
                }
                LOGGER.error("Wrong load type {}", (Object)loadType);
            }
            loader.endSync();
        }
        catch (IOException e) {
            LOGGER.error("Can not scan log for recovery", (Throwable)e);
        }
    }

    private static class SyncReceiverLogAnalyzerHolder {
        private static final SyncReceiverLogAnalyzer INSTANCE = new SyncReceiverLogAnalyzer();

        private SyncReceiverLogAnalyzerHolder() {
        }
    }
}

