/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.basic;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.SessionTimeoutManager;
import org.apache.iotdb.db.query.control.tracing.TracingManager;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.QueryFrequencyRecorder;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ServiceProvider.class);
    public static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"IoTDB_AUDIT_LOGGER");
    public static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    public static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    public static final QueryTimeManager QUERY_TIME_MANAGER = QueryTimeManager.getInstance();
    public static final TracingManager TRACING_MANAGER = TracingManager.getInstance();
    public static final QueryFrequencyRecorder QUERY_FREQUENCY_RECORDER = new QueryFrequencyRecorder(CONFIG);
    public static SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final Planner planner = new Planner();
    protected final IPlanExecutor executor;

    public Planner getPlanner() {
        return this.planner;
    }

    public IPlanExecutor getExecutor() {
        return this.executor;
    }

    public ServiceProvider(PlanExecutor executor) throws QueryProcessException {
        this.executor = executor;
    }

    public abstract QueryContext genQueryContext(long var1, boolean var3, long var4, String var6, long var7);

    public abstract boolean executeNonQuery(PhysicalPlan var1) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException;

    public boolean checkLogin(long sessionId) {
        boolean isLoggedIn;
        Long currSessionId = SESSION_MANAGER.getCurrSessionId();
        boolean bl = isLoggedIn = currSessionId != null && currSessionId == sessionId;
        if (!isLoggedIn) {
            LOGGER.info("{}: Not login. ", (Object)"IoTDB");
            return false;
        }
        SessionTimeoutManager.getInstance().refresh(sessionId);
        return isLoggedIn;
    }

    public boolean checkSessionTimeout(long sessionId) {
        return !SessionTimeoutManager.getInstance().isSessionAlive(sessionId);
    }

    public boolean checkAuthorization(PhysicalPlan plan, String username) throws AuthException {
        if (!plan.isAuthenticationRequired()) {
            return true;
        }
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(username, plan.getAuthPaths(), plan.getOperatorType(), targetUser);
    }

    public TSStatus checkAuthority(PhysicalPlan plan, long sessionId) {
        try {
            if (!this.checkAuthorization(plan, SESSION_MANAGER.getUsername(sessionId))) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + (Object)((Object)plan.getOperatorType())));
            }
        }
        catch (AuthException e) {
            LOGGER.warn("meet error while checking authorization.", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNINITIALIZED_AUTH_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CHECK_AUTHORITY, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        return null;
    }

    public BasicOpenSessionResp openSession(String username, String password, String zoneId, TSProtocolVersion tsProtocolVersion, IoTDBConstant.ClientVersion clientVersion) throws TException {
        boolean status;
        IAuthorizer authorizer;
        BasicOpenSessionResp openSessionResp = new BasicOpenSessionResp();
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        String loginMessage = null;
        try {
            status = authorizer.login(username, password);
        }
        catch (AuthException e) {
            LOGGER.info("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        long sessionId = -1L;
        if (status) {
            boolean compatible = this.checkCompatibility(tsProtocolVersion);
            if (!compatible) {
                openSessionResp.setCode(TSStatusCode.INCOMPATIBLE_VERSION.getStatusCode());
                openSessionResp.setMessage("The version is incompatible, please upgrade to " + IoTDBConstant.VERSION);
                return openSessionResp.sessionId(sessionId);
            }
            openSessionResp.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            openSessionResp.setMessage("Login successfully");
            sessionId = SESSION_MANAGER.requestSessionId(username, zoneId, clientVersion);
            LOGGER.info("{}: Login status: {}. User : {}, opens Session-{}", new Object[]{"IoTDB", openSessionResp.getMessage(), username, sessionId});
        } else {
            openSessionResp.setMessage(loginMessage != null ? loginMessage : "Authentication failed.");
            openSessionResp.setCode(TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR.getStatusCode());
            sessionId = SESSION_MANAGER.requestSessionId(username, zoneId, clientVersion);
            AUDIT_LOGGER.info("User {} opens Session failed with an incorrect password", (Object)username);
        }
        SessionTimeoutManager.getInstance().register(sessionId);
        return openSessionResp.sessionId(sessionId);
    }

    public BasicOpenSessionResp openSession(String username, String password, String zoneId, TSProtocolVersion tsProtocolVersion) throws TException {
        return this.openSession(username, password, zoneId, tsProtocolVersion, IoTDBConstant.ClientVersion.V_0_12);
    }

    public boolean closeSession(long sessionId) {
        AUDIT_LOGGER.info("Session-{} is closing", (Object)sessionId);
        SESSION_MANAGER.removeCurrSessionId();
        return SessionTimeoutManager.getInstance().unregister(sessionId);
    }

    public TSStatus closeOperation(long sessionId, long queryId, long statementId, boolean haveStatementId, boolean haveSetQueryId) {
        if (!this.checkLogin(sessionId)) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR, (String)"Log in failed. Either you are not authorized or the session has timed out.");
        }
        if (this.checkSessionTimeout(sessionId)) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SESSION_TIMEOUT, (String)"Session timeout");
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("{}: receive close operation from Session {}", (Object)"IoTDB", (Object)SESSION_MANAGER.getCurrSessionId());
        }
        try {
            if (haveStatementId) {
                if (haveSetQueryId) {
                    SESSION_MANAGER.closeDataset(statementId, queryId);
                } else {
                    SESSION_MANAGER.closeStatement(sessionId, statementId);
                }
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)"statement id not set by client.");
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CLOSE_OPERATION, TSStatusCode.CLOSE_OPERATION_ERROR);
        }
    }

    public QueryDataSet createQueryDataSet(QueryContext context, PhysicalPlan physicalPlan, int fetchSize) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException, MetadataException, SQLException, TException, InterruptedException {
        QueryDataSet queryDataSet = this.executor.processQuery(physicalPlan, context);
        queryDataSet.setFetchSize(fetchSize);
        SESSION_MANAGER.setDataset(context.getQueryId(), queryDataSet);
        return queryDataSet;
    }

    private boolean checkCompatibility(TSProtocolVersion version) {
        return version.equals((Object)CURRENT_RPC_VERSION);
    }
}

