/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.FlushManagerMBean;
import org.apache.iotdb.db.engine.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushManager
implements FlushManagerMBean,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushManager.class);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ConcurrentLinkedDeque<TsFileProcessor> tsFileProcessorQueue = new ConcurrentLinkedDeque();
    private FlushTaskPoolManager flushPool = FlushTaskPoolManager.getInstance();

    @Override
    public void start() throws StartupException {
        FlushSubTaskPoolManager.getInstance().start();
        this.flushPool.start();
        try {
            JMXService.registerMBean(this, ServiceType.FLUSH_SERVICE.getJmxName());
            if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.flushPool, AbstractPoolManager::getWaitingTasksNumber, new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "waiting"});
                MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.flushPool, AbstractPoolManager::getWorkingTasksNumber, new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "running"});
            }
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        FlushSubTaskPoolManager.getInstance().stop();
        FlushTaskPoolManager.getInstance().stop();
        JMXService.deregisterMBean(ServiceType.FLUSH_SERVICE.getJmxName());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.FLUSH_SERVICE;
    }

    @Override
    public int getNumberOfWorkingTasks() {
        return this.flushPool.getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingTasks() {
        return this.flushPool.getWaitingTasksNumber();
    }

    @Override
    public int getNumberOfWorkingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWaitingTasksNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTsFileProcessor(TsFileProcessor tsFileProcessor) {
        TsFileProcessor tsFileProcessor2 = tsFileProcessor;
        synchronized (tsFileProcessor2) {
            if (tsFileProcessor.isManagedByFlushManager()) {
                LOGGER.debug("{} is already in the flushPool, the given processor flushMemtable number = {}", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath(), (Object)tsFileProcessor.getFlushingMemTableSize());
            } else if (tsFileProcessor.getFlushingMemTableSize() > 0) {
                this.tsFileProcessorQueue.add(tsFileProcessor);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} begin to submit a flush thread, flushing memtable size: {}, queue size: {}", new Object[]{tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath(), tsFileProcessor.getFlushingMemTableSize(), this.tsFileProcessorQueue.size()});
                }
                tsFileProcessor.setManagedByFlushManager(true);
                this.flushPool.submit(new FlushThread());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No flushing memetable to do, register TsProcessor {} failed.", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
            }
        }
    }

    private FlushManager() {
    }

    public static FlushManager getInstance() {
        return InstanceHolder.instance;
    }

    public String toString() {
        return String.format("TSProcessors in the queue: %d, TaskPool size %d + %d,", this.tsFileProcessorQueue.size(), this.flushPool.getWorkingTasksNumber(), this.flushPool.getWaitingTasksNumber());
    }

    private static class InstanceHolder {
        private static FlushManager instance = new FlushManager();

        private InstanceHolder() {
        }
    }

    class FlushThread
    extends WrappedRunnable {
        FlushThread() {
        }

        @Override
        public void runMayThrow() {
            TsFileProcessor tsFileProcessor = (TsFileProcessor)FlushManager.this.tsFileProcessorQueue.poll();
            if (null == tsFileProcessor) {
                return;
            }
            tsFileProcessor.flushOneMemTable();
            tsFileProcessor.setManagedByFlushManager(false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Flush Thread re-register TSProcessor {} to the queue.", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
            }
            FlushManager.this.registerTsFileProcessor(tsFileProcessor);
        }
    }
}

