/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.util.List;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public enum CrossCompactionStrategy {
    REWRITE_COMPACTION;


    public static CrossCompactionStrategy getCrossCompactionStrategy(String name) {
        if ("REWRITE_COMPACTION".equalsIgnoreCase(name)) {
            return REWRITE_COMPACTION;
        }
        throw new RuntimeException("Illegal Cross Compaction Strategy " + name);
    }

    public AbstractCrossSpaceCompactionTask getCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartitionId, TsFileManager tsFileManager, List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) {
        switch (this) {
            default: 
        }
        return new RewriteCrossSpaceCompactionTask(logicalStorageGroupName, virtualStorageGroupName, timePartitionId, tsFileManager, selectedSeqTsFileResourceList, selectedUnSeqTsFileResourceList, CompactionTaskManager.currentTaskNum);
    }

    public AbstractCrossSpaceCompactionSelector getCompactionSelector(String logicalStorageGroupName, String virtualGroupId, String storageGroupDir, long timePartition, TsFileManager tsFileManager, CrossSpaceCompactionTaskFactory taskFactory) {
        switch (this) {
            default: 
        }
        return new RewriteCrossSpaceCompactionSelector(logicalStorageGroupName, virtualGroupId, storageGroupDir, timePartition, tsFileManager, taskFactory);
    }
}

