/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncProducer.class);
    private final BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>> operationSyncQueue;

    public OperationSyncProducer(BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>> operationSyncQueue) {
        this.operationSyncQueue = operationSyncQueue;
    }

    public void put(Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType> planPair) {
        try {
            ((ByteBuffer)planPair.left).position(0);
            this.operationSyncQueue.put(planPair);
        }
        catch (InterruptedException e) {
            LOGGER.error("OperationSync cache failed.", (Throwable)e);
        }
    }
}

