/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.doublelive.OperationSyncProtector;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.writelog.io.LogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncLogService
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncLogService.class);
    private static final String logFileDir = IoTDBDescriptor.getInstance().getConfig().getOperationSyncLogDir();
    private static final long logFileValidity = (long)IoTDBDescriptor.getInstance().getConfig().getOperationSyncLogValidity() * 1000L;
    private static final int maxLogFileNum = IoTDBDescriptor.getInstance().getConfig().getOperationSyncLogNum();
    private static final long maxLogFileSize = IoTDBDescriptor.getInstance().getConfig().getOperationSyncMaxLogSize();
    private static long currentLogFileSize = 0L;
    private final OperationSyncProtector protector;
    private final Lock logWriterLock;
    private final String logFileName;
    private int logFileID;
    private long logFileCreateTime;
    private File logFile;
    private LogWriter logWriter;

    public OperationSyncLogService(String logFileName, OperationSyncProtector protector) {
        this.logFileName = logFileName;
        this.protector = protector;
        this.logWriterLock = new ReentrantLock();
        this.logFile = null;
        this.logWriter = null;
        File logDir = new File(logFileDir);
        if (!logDir.exists() && !logDir.mkdirs()) {
            LOGGER.error("Can't make OperationSyncLog file dir: {}", (Object)logDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Integer> logFileIDList = new ArrayList<Integer>();
        for (int ID = 0; ID < maxLogFileNum; ++ID) {
            File file = SystemFileFactory.INSTANCE.getFile(logFileDir + File.separator + this.logFileName + ID);
            if (!file.exists()) continue;
            logFileIDList.add(ID);
        }
        int firstID = 0;
        if (logFileIDList.size() > 0) {
            int i;
            for (i = 0; i < logFileIDList.size() - 1; ++i) {
                if ((Integer)logFileIDList.get(i + 1) - (Integer)logFileIDList.get(i) <= 1) continue;
                firstID = i + 1;
                break;
            }
            for (i = firstID; i < logFileIDList.size(); ++i) {
                this.protector.registerLogFile(logFileDir + File.separator + this.logFileName + logFileIDList.get(i));
            }
            for (i = 0; i < firstID; ++i) {
                this.protector.registerLogFile(logFileDir + File.separator + this.logFileName + logFileIDList.get(i));
            }
            int nextID = firstID == 0 ? (Integer)logFileIDList.get(logFileIDList.size() - 1) + 1 : (Integer)logFileIDList.get(firstID - 1) + 1;
            this.logFileID = nextID % maxLogFileNum;
        } else {
            this.logFileID = 0;
        }
        while (true) {
            this.logWriterLock.lock();
            try {
                if (this.logWriter != null && System.currentTimeMillis() - this.logFileCreateTime > logFileValidity) {
                    this.submitLogFile();
                }
            }
            finally {
                this.logWriterLock.unlock();
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("OperationSyncLogService been interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void submitLogFile() {
        try {
            this.logWriter.force();
        }
        catch (IOException e) {
            LOGGER.error("Can't force logWrite", (Throwable)e);
        }
        OperationSyncLogService.incLogFileSize(this.logFile.length());
        for (int retry = 0; retry < 5; ++retry) {
            try {
                this.logWriter.close();
            }
            catch (IOException e) {
                LOGGER.warn("Can't close OperationSyncLog: {}, retrying...", (Object)this.logFile.getAbsolutePath());
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            LOGGER.info("OperationSyncLog: {} is expired and closed", (Object)this.logFile.getAbsolutePath());
            break;
        }
        this.protector.registerLogFile(logFileDir + File.separator + this.logFileName + (this.logFileID - 1 + maxLogFileNum) % maxLogFileNum);
        this.logWriter = null;
        this.logFile = null;
    }

    private void createLogFile() {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFileDir + File.separator + this.logFileName + this.logFileID);
        while (true) {
            try {
                while (!this.logFile.createNewFile()) {
                }
                this.logFileCreateTime = System.currentTimeMillis();
                this.logWriter = new LogWriter(this.logFile, false);
                LOGGER.info("Create OperationSyncLog: {}", (Object)this.logFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.warn("Can't create OperationSyncLog: {}, retrying...", (Object)this.logFile.getAbsolutePath());
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.logFileID = (this.logFileID + 1) % maxLogFileNum;
    }

    public static synchronized void incLogFileSize(long size) {
        currentLogFileSize += size;
    }

    public void acquireLogWriter() {
        this.logWriterLock.lock();
    }

    public void write(ByteBuffer buffer) throws IOException {
        if (currentLogFileSize < maxLogFileSize) {
            if (this.logWriter == null) {
                this.createLogFile();
            }
            this.logWriter.write(buffer);
        } else {
            LOGGER.error("The OperationSyncLog is full, new PhysicalPlans will be discarded.");
        }
    }

    public void releaseLogWriter() {
        this.logWriterLock.unlock();
    }
}

