/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.doublelive.OperationSyncDDLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.db.doublelive.OperationSyncProducer;
import org.apache.iotdb.db.doublelive.OperationSyncProtector;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.Pair;

public class OperationSyncDMLProtector
extends OperationSyncProtector {
    private final OperationSyncDDLProtector ddlProtector;
    private final OperationSyncProducer producer;

    public OperationSyncDMLProtector(OperationSyncDDLProtector ddlProtector, OperationSyncProducer producer) {
        this.ddlProtector = ddlProtector;
        this.producer = producer;
    }

    @Override
    protected void preCheck() {
        while (this.ddlProtector.isAtWork()) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void transmitPhysicalPlan(ByteBuffer planBuffer, PhysicalPlan physicalPlan) {
        this.producer.put((Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>)new Pair((Object)planBuffer, (Object)OperationSyncPlanTypeUtils.getOperationSyncPlanType(physicalPlan)));
    }
}

