/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.AbstractIoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.tool.ImportCsv;

public abstract class AbstractCli {
    static final String HOST_ARGS = "h";
    static final String HOST_NAME = "host";
    static final String HELP_ARGS = "help";
    static final String PORT_ARGS = "p";
    static final String PORT_NAME = "port";
    static final String PASSWORD_ARGS = "pw";
    private static final String PASSWORD_NAME = "password";
    static final String USERNAME_ARGS = "u";
    static final String USERNAME_NAME = "username";
    private static final String EXECUTE_ARGS = "e";
    private static final String EXECUTE_NAME = "execute";
    private static final String NULL = "null";
    static final int CODE_OK = 0;
    static final int CODE_ERROR = 1;
    static final String ISO8601_ARGS = "disableISO8601";
    static final List<String> AGGREGRATE_TIME_LIST = new ArrayList<String>();
    static final String MAX_PRINT_ROW_COUNT_ARGS = "maxPRC";
    private static final String MAX_PRINT_ROW_COUNT_NAME = "maxPrintRowCount";
    static final String RPC_COMPRESS_ARGS = "c";
    private static final String RPC_COMPRESS_NAME = "rpcCompressed";
    static final String SET_MAX_DISPLAY_NUM = "set max_display_num";
    static final String SET_TIMESTAMP_DISPLAY = "set time_display_type";
    static final String SHOW_TIMESTAMP_DISPLAY = "show time_display_type";
    static final String SET_TIME_ZONE = "set time_zone";
    static final String SHOW_TIMEZONE = "show time_zone";
    static final String SET_FETCH_SIZE = "set fetch_size";
    static final String SHOW_FETCH_SIZE = "show fetch_size";
    private static final String HELP = "help";
    static final String IOTDB_CLI_PREFIX = "IoTDB";
    static final String SCRIPT_HINT = "./start-cli.sh(start-cli.bat if Windows)";
    static final String QUIT_COMMAND = "quit";
    static final String EXIT_COMMAND = "exit";
    private static final String SHOW_METADATA_COMMAND = "show timeseries";
    static final int MAX_HELP_CONSOLE_WIDTH = 88;
    static final String TIMESTAMP_STR = "Time";
    private static final String IMPORT_CMD = "import";
    static int maxPrintRowCount = 1000;
    private static int fetchSize = 1000;
    static String timestampPrecision = "ms";
    static String timeFormat = "default";
    private static boolean continuePrint = false;
    private static int lineCount = 0;
    private static final String SUCCESS_MESSAGE = "The statement is executed successfully.";
    private static boolean isReachEnd = false;
    static String host = "127.0.0.1";
    static String port = "6667";
    static String username;
    static String password;
    static String execute;
    static boolean hasExecuteSQL;
    static Set<String> keywordSet;
    static ServerProperties properties;
    private static boolean cursorBeforeFirst;
    static int lastProcessStatus;

    static void init() {
        keywordSet.add("-h");
        keywordSet.add("-help");
        keywordSet.add("-p");
        keywordSet.add("-pw");
        keywordSet.add("-u");
        keywordSet.add("-e");
        keywordSet.add("-disableISO8601");
        keywordSet.add("-maxPRC");
        keywordSet.add("-c");
    }

    static Options createOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "Display help information(optional)");
        help.setRequired(false);
        options.addOption(help);
        Option timeFormat = new Option(ISO8601_ARGS, false, "Display timestamp in number(optional)");
        timeFormat.setRequired(false);
        options.addOption(timeFormat);
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name (optional, default 127.0.0.1)").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port (optional, default 6667)").build();
        options.addOption(port);
        Option username = Option.builder((String)USERNAME_ARGS).argName(USERNAME_NAME).hasArg().desc("User name (required)").required().build();
        options.addOption(username);
        Option password = Option.builder((String)PASSWORD_ARGS).argName(PASSWORD_NAME).hasArg().desc("password (optional)").build();
        options.addOption(password);
        Option execute = Option.builder((String)EXECUTE_ARGS).argName(EXECUTE_NAME).hasArg().desc("execute statement (optional)").build();
        options.addOption(execute);
        Option maxPrintCount = Option.builder((String)MAX_PRINT_ROW_COUNT_ARGS).argName(MAX_PRINT_ROW_COUNT_NAME).hasArg().desc("Maximum number of rows displayed (optional)").build();
        options.addOption(maxPrintCount);
        Option isRpcCompressed = Option.builder((String)RPC_COMPRESS_ARGS).argName(RPC_COMPRESS_NAME).desc("Rpc Compression enabled or not").build();
        options.addOption(isRpcCompressed);
        return options;
    }

    static String checkRequiredArg(String arg, String name, CommandLine commandLine, boolean isRequired, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (isRequired) {
                String msg = String.format("%s: Required values for option '%s' not provided", IOTDB_CLI_PREFIX, name);
                IoTPrinter.println(msg);
                IoTPrinter.println("Use -help for more information");
                throw new ArgsErrorException(msg);
            }
            if (defaultValue == null) {
                String msg = String.format("%s: Required values for option '%s' is null.", IOTDB_CLI_PREFIX, name);
                throw new ArgsErrorException(msg);
            }
            return defaultValue;
        }
        return str;
    }

    private static void setFetchSize(String fetchSizeString) {
        long tmp = Long.parseLong(fetchSizeString.trim());
        fetchSize = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(fetchSizeString.trim());
    }

    static void setMaxDisplayNumber(String maxDisplayNum) {
        long tmp = Long.parseLong(maxDisplayNum.trim());
        if (tmp > Integer.MAX_VALUE) {
            throw new NumberFormatException();
        }
        if (tmp <= 0L) {
            continuePrint = true;
        } else {
            maxPrintRowCount = Integer.parseInt(maxDisplayNum.trim());
        }
    }

    static String[] removePasswordArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-pw")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        return args;
    }

    static String[] processExecuteArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-e")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        if (index == -1) {
            return args;
        }
        StringBuilder executeCommand = new StringBuilder();
        for (int j = index + 1; j < args.length; ++j) {
            executeCommand.append(args[j]).append(" ");
        }
        executeCommand.deleteCharAt(executeCommand.length() - 1);
        if (executeCommand.charAt(0) == '\'' || executeCommand.charAt(0) == '\"') {
            executeCommand.deleteCharAt(0);
            if (executeCommand.charAt(executeCommand.length() - 1) == '\'' || executeCommand.charAt(executeCommand.length() - 1) == '\"') {
                executeCommand.deleteCharAt(executeCommand.length() - 1);
            }
        }
        execute = executeCommand.toString();
        hasExecuteSQL = true;
        continuePrint = true;
        args = Arrays.copyOfRange(args, 0, index);
        return args;
    }

    static void displayLogo(String version) {
        IoTPrinter.println(" _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  version " + version + "\n                                           \n");
    }

    static void echoStarting() {
        IoTPrinter.println("---------------------");
        IoTPrinter.println("Starting IoTDB Cli");
        IoTPrinter.println("---------------------");
    }

    static OperationResult handleInputCmd(String cmd, IoTDBConnection connection) {
        lastProcessStatus = 0;
        String specialCmd = cmd.toLowerCase().trim();
        if (QUIT_COMMAND.equals(specialCmd) || EXIT_COMMAND.equals(specialCmd)) {
            return OperationResult.STOP_OPER;
        }
        if ("help".equals(specialCmd)) {
            AbstractCli.showHelp();
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIMESTAMP_DISPLAY)) {
            lastProcessStatus = AbstractCli.setTimestampDisplay(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIME_ZONE)) {
            lastProcessStatus = AbstractCli.setTimeZone(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_FETCH_SIZE)) {
            lastProcessStatus = AbstractCli.setFetchSize(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_MAX_DISPLAY_NUM)) {
            lastProcessStatus = AbstractCli.setMaxDisplayNum(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMEZONE)) {
            lastProcessStatus = AbstractCli.showTimeZone(connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMESTAMP_DISPLAY)) {
            IoTPrinter.println("Current time format: " + timeFormat);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_FETCH_SIZE)) {
            IoTPrinter.println("Current fetch size: " + fetchSize);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(IMPORT_CMD)) {
            lastProcessStatus = AbstractCli.importCmd(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        lastProcessStatus = AbstractCli.executeQuery(connection, cmd);
        return OperationResult.NO_OPER;
    }

    private static void showHelp() {
        IoTPrinter.println("    <your-sql>\t\t\t execute your sql statment");
        IoTPrinter.println(String.format("    %s\t\t show how many timeseries are in iotdb", SHOW_METADATA_COMMAND));
        IoTPrinter.println(String.format("    %s=xxx\t eg. long, default, ISO8601, yyyy-MM-dd HH:mm:ss.", SET_TIMESTAMP_DISPLAY));
        IoTPrinter.println(String.format("    %s\t show time display type", SHOW_TIMESTAMP_DISPLAY));
        IoTPrinter.println(String.format("    %s=xxx\t\t eg. +08:00, Asia/Shanghai.", SET_TIME_ZONE));
        IoTPrinter.println(String.format("    %s\t\t show cli time zone", SHOW_TIMEZONE));
        IoTPrinter.println(String.format("    %s=xxx\t\t set fetch size when querying data from server.", SET_FETCH_SIZE));
        IoTPrinter.println(String.format("    %s\t\t show fetch size", SHOW_FETCH_SIZE));
        IoTPrinter.println(String.format("    %s=xxx\t eg. set max lines for cli to ouput, -1 equals to unlimited.", SET_MAX_DISPLAY_NUM));
    }

    private static int setTimestampDisplay(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            IoTPrinter.println(String.format("Time display format error, please input like %s=ISO8601", SET_TIMESTAMP_DISPLAY));
            return 1;
        }
        try {
            timeFormat = RpcUtils.setTimeFormat((String)cmd.split("=")[1]);
        }
        catch (Exception e) {
            IoTPrinter.println(String.format("time display format error, %s", e.getMessage()));
            return 1;
        }
        IoTPrinter.println("Time display type has set to " + cmd.split("=")[1].trim());
        return 0;
    }

    private static int setTimeZone(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            IoTPrinter.println(String.format("Time zone format error, please input like %s=+08:00", SET_TIME_ZONE));
            return 1;
        }
        try {
            connection.setTimeZone(cmd.split("=")[1].trim());
        }
        catch (Exception e) {
            IoTPrinter.println(String.format("Time zone format error: %s", e.getMessage()));
            return 1;
        }
        IoTPrinter.println("Time zone has set to " + values[1].trim());
        return 0;
    }

    private static int setFetchSize(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            IoTPrinter.println(String.format("Fetch size format error, please input like %s=10000", SET_FETCH_SIZE));
            return 1;
        }
        try {
            AbstractCli.setFetchSize(cmd.split("=")[1]);
        }
        catch (Exception e) {
            IoTPrinter.println(String.format("Fetch size format error, %s", e.getMessage()));
            return 1;
        }
        IoTPrinter.println("Fetch size has set to " + values[1].trim());
        return 0;
    }

    private static int setMaxDisplayNum(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            IoTPrinter.println(String.format("Max display number format error, please input like %s = 10000", SET_MAX_DISPLAY_NUM));
            return 1;
        }
        try {
            AbstractCli.setMaxDisplayNumber(cmd.split("=")[1]);
        }
        catch (Exception e) {
            IoTPrinter.println(String.format("Max display number format error, %s", e.getMessage()));
            return 1;
        }
        IoTPrinter.println("Max display number has set to " + values[1].trim());
        return 0;
    }

    private static int showTimeZone(IoTDBConnection connection) {
        try {
            IoTPrinter.println("Current time zone: " + connection.getTimeZone());
        }
        catch (Exception e) {
            IoTPrinter.println("Cannot get time zone from server side because: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int importCmd(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split(" ");
        if (values.length != 2) {
            IoTPrinter.println("Please input like: import /User/myfile. Noted that your file path cannot contain any space character)");
            return 1;
        }
        IoTPrinter.println(cmd.split(" ")[1]);
        try {
            return ImportCsv.importFromTargetPath(host, Integer.parseInt(port), username, password, cmd.split(" ")[1], connection.getTimeZone());
        }
        catch (IoTDBConnectionException e) {
            e.printStackTrace();
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeQuery(IoTDBConnection connection, String cmd) {
        int executeStatus;
        block35: {
            executeStatus = 0;
            long startTime = System.currentTimeMillis();
            try (Statement statement = connection.createStatement();){
                ZoneId zoneId = ZoneId.of(connection.getTimeZone());
                statement.setFetchSize(fetchSize);
                boolean hasResultSet = statement.execute(cmd.trim());
                if (hasResultSet) {
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int columnLength = resultSetMetaData.getColumnCount();
                        ArrayList<Integer> maxSizeList = new ArrayList<Integer>(columnLength);
                        List<List<String>> lists = AbstractCli.cacheResult(resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                        AbstractCli.output(lists, maxSizeList);
                        long costTime = System.currentTimeMillis() - startTime;
                        IoTPrinter.println(String.format("It costs %.3fs", (double)costTime / 1000.0));
                        while (!isReachEnd) {
                            if (continuePrint) {
                                maxSizeList = new ArrayList(columnLength);
                                lists = AbstractCli.cacheResult(resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                                AbstractCli.output(lists, maxSizeList);
                                continue;
                            }
                            IoTPrinter.println(String.format("Reach the max_display_num = %s. Press ENTER to show more, input 'q' to quit.", maxPrintRowCount));
                            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                            try {
                                if (!"".equals(br.readLine())) break;
                                maxSizeList = new ArrayList(columnLength);
                                lists = AbstractCli.cacheResult(resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                                AbstractCli.output(lists, maxSizeList);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                executeStatus = 1;
                            }
                        }
                        if (((AbstractIoTDBJDBCResultSet)resultSet).isSetTracingInfo()) {
                            maxSizeList = new ArrayList(2);
                            lists = AbstractCli.cacheTracingInfo(resultSet, maxSizeList);
                            AbstractCli.outputTracingInfo(lists, maxSizeList);
                        }
                        break block35;
                    }
                }
                IoTPrinter.println("Msg: The statement is executed successfully.");
            }
            catch (Exception e) {
                IoTPrinter.println("Msg: " + e.getMessage());
                executeStatus = 1;
            }
            finally {
                AbstractCli.resetArgs();
            }
        }
        return executeStatus;
    }

    private static List<List<String>> cacheResult(ResultSet resultSet, List<Integer> maxSizeList, int columnCount, ResultSetMetaData resultSetMetaData, ZoneId zoneId) throws SQLException {
        int i;
        int j = 0;
        if (cursorBeforeFirst) {
            isReachEnd = !resultSet.next();
            cursorBeforeFirst = false;
        }
        ArrayList<List<String>> lists = new ArrayList<List<String>>(columnCount);
        if (resultSet instanceof IoTDBJDBCResultSet) {
            boolean printTimestamp;
            int count;
            for (int i2 = 1; i2 <= columnCount; ++i2) {
                ArrayList<String> list = new ArrayList<String>(maxPrintRowCount + 1);
                String columnLabel = resultSetMetaData.getColumnLabel(i2);
                list.add(columnLabel);
                lists.add(list);
                count = IoTPrinter.computeHANCount(columnLabel);
                maxSizeList.add(columnLabel.length() + count);
            }
            boolean bl = printTimestamp = !((IoTDBJDBCResultSet)resultSet).isIgnoreTimeStamp();
            while (j < maxPrintRowCount && !isReachEnd) {
                for (int i3 = 1; i3 <= columnCount; ++i3) {
                    String tmp = printTimestamp && i3 == 1 ? RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)resultSet.getLong(TIMESTAMP_STR), (ZoneId)zoneId) : resultSet.getString(i3);
                    if (tmp == null) {
                        tmp = NULL;
                    }
                    ((List)lists.get(i3 - 1)).add(tmp);
                    count = IoTPrinter.computeHANCount(tmp);
                    int realLength = tmp.length() + count;
                    if (maxSizeList.get(i3 - 1) >= realLength) continue;
                    maxSizeList.set(i3 - 1, realLength);
                }
                ++j;
                isReachEnd = !resultSet.next();
            }
            return lists;
        }
        for (i = 1; i <= columnCount; i += 2) {
            ArrayList<String> timeList = new ArrayList<String>(maxPrintRowCount + 1);
            timeList.add(resultSetMetaData.getColumnLabel(i).substring(0, TIMESTAMP_STR.length()));
            lists.add(timeList);
            ArrayList<String> valueList = new ArrayList<String>(maxPrintRowCount + 1);
            valueList.add(resultSetMetaData.getColumnLabel(i + 1));
            lists.add(valueList);
            maxSizeList.add(TIMESTAMP_STR.length());
            maxSizeList.add(resultSetMetaData.getColumnLabel(i + 1).length());
        }
        while (j < maxPrintRowCount && !isReachEnd) {
            for (i = 1; i <= columnCount; ++i) {
                String tmp = resultSet.getString(i);
                if (tmp == null) {
                    tmp = NULL;
                }
                if (i % 2 != 0 && !tmp.equals(NULL)) {
                    tmp = RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)Long.parseLong(tmp), (ZoneId)zoneId);
                }
                ((List)lists.get(i - 1)).add(tmp);
                if (maxSizeList.get(i - 1) >= tmp.length()) continue;
                maxSizeList.set(i - 1, tmp.length());
            }
            ++j;
            isReachEnd = !resultSet.next();
        }
        return lists;
    }

    private static List<List<String>> cacheTracingInfo(ResultSet resultSet, List<Integer> maxSizeList) throws Exception {
        ArrayList<List<String>> lists = new ArrayList<List<String>>(2);
        lists.add(0, new ArrayList());
        lists.add(1, new ArrayList());
        String ACTIVITY_STR = "Activity";
        String ELAPSED_TIME_STR = "Elapsed Time";
        ((List)lists.get(0)).add(ACTIVITY_STR);
        ((List)lists.get(1)).add(ELAPSED_TIME_STR);
        maxSizeList.add(0, ACTIVITY_STR.length());
        maxSizeList.add(1, ELAPSED_TIME_STR.length());
        List activityList = ((AbstractIoTDBJDBCResultSet)resultSet).getActivityList();
        List elapsedTimeList = ((AbstractIoTDBJDBCResultSet)resultSet).getElapsedTimeList();
        String[] statisticsInfoList = new String[]{"seriesPathNum", "seqFileNum", "unSeqFileNum", "seqChunkInfo", "unSeqChunkInfo", "pageNumInfo"};
        for (int i = 0; i < activityList.size(); ++i) {
            if (i == activityList.size() - 1) {
                for (String infoName : statisticsInfoList) {
                    String info = ((AbstractIoTDBJDBCResultSet)resultSet).getStatisticsInfoByName(infoName);
                    ((List)lists.get(0)).add(info);
                    ((List)lists.get(1)).add("");
                    if (info.length() <= maxSizeList.get(0)) continue;
                    maxSizeList.set(0, info.length());
                }
            }
            String activity = (String)activityList.get(i);
            String elapsedTime = ((Long)elapsedTimeList.get(i)).toString();
            if (activity.length() > maxSizeList.get(0)) {
                maxSizeList.set(0, activity.length());
            }
            if (elapsedTime.length() > maxSizeList.get(1)) {
                maxSizeList.set(1, elapsedTime.length());
            }
            ((List)lists.get(0)).add(activity);
            ((List)lists.get(1)).add(elapsedTime);
        }
        return lists;
    }

    private static void output(List<List<String>> lists, List<Integer> maxSizeList) {
        IoTPrinter.printBlockLine(maxSizeList);
        IoTPrinter.printRow(lists, 0, maxSizeList);
        IoTPrinter.printBlockLine(maxSizeList);
        for (int i = 1; i < lists.get(0).size(); ++i) {
            IoTPrinter.printRow(lists, i, maxSizeList);
        }
        IoTPrinter.printBlockLine(maxSizeList);
        if (isReachEnd) {
            IoTPrinter.printCount(lineCount += lists.get(0).size() - 1);
        } else {
            lineCount += maxPrintRowCount;
        }
    }

    private static void outputTracingInfo(List<List<String>> lists, List<Integer> maxSizeList) {
        IoTPrinter.println();
        IoTPrinter.println("Tracing Activties:");
        IoTPrinter.printBlockLine(maxSizeList);
        IoTPrinter.printRow(lists, 0, maxSizeList);
        IoTPrinter.printBlockLine(maxSizeList);
        for (int i = 1; i < lists.get(0).size(); ++i) {
            IoTPrinter.printRow(lists, i, maxSizeList);
        }
        IoTPrinter.printBlockLine(maxSizeList);
    }

    private static void resetArgs() {
        lineCount = 0;
        cursorBeforeFirst = true;
        isReachEnd = false;
    }

    static boolean processCommand(String s, IoTDBConnection connection) {
        String[] cmds;
        if (s == null) {
            return true;
        }
        block4: for (String cmd : cmds = s.trim().split(";")) {
            if (cmd == null || "".equals(cmd.trim())) continue;
            OperationResult result = AbstractCli.handleInputCmd(cmd, connection);
            switch (result) {
                case STOP_OPER: {
                    return false;
                }
                case CONTINUE_OPER: {
                    continue block4;
                }
            }
        }
        return true;
    }

    static {
        hasExecuteSQL = false;
        keywordSet = new HashSet<String>();
        properties = null;
        cursorBeforeFirst = true;
        lastProcessStatus = 0;
    }

    static enum OperationResult {
        STOP_OPER,
        CONTINUE_OPER,
        NO_OPER;

    }
}

