/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.utils;

import java.util.Map;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionDataSetWrapper;
import org.apache.iotdb.session.pool.SessionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMetricsUtils {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBMetricsUtils.class);
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static final String STORAGE_GROUP = "root." + metricConfig.getIoTDBReporterConfig().getDatabase();

    public static String generatePath(String name, Map<String, String> labels) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STORAGE_GROUP).append(".\"").append(metricConfig.getInstanceHost()).append(":").append(metricConfig.getInstancePort()).append("\"").append(".").append("\"").append(name).append("\"");
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            stringBuilder.append(".").append("\"").append(entry.getKey()).append("=").append(entry.getValue()).append("\"");
        }
        return stringBuilder.toString();
    }

    public static void checkOrCreateStorageGroup(SessionPool session) {
        try (SessionDataSetWrapper result = session.executeQueryStatement("show storage group " + STORAGE_GROUP);){
            if (!result.hasNext()) {
                session.setStorageGroup(STORAGE_GROUP);
            }
        }
        catch (IoTDBConnectionException e) {
            logger.error("CheckOrCreateStorageGroup failed because ", (Throwable)e);
        }
        catch (StatementExecutionException statementExecutionException) {
            // empty catch block
        }
    }
}

