/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReplayer {
    private Logger logger = LoggerFactory.getLogger(LogReplayer.class);
    private String logNodePrefix;
    private String insertFilePath;
    private ModificationFile modFile;
    private TsFileResource currentTsFileResource;
    private IMemTable recoverMemTable;
    private boolean sequence;
    private Map<String, Long> tempStartTimeMap = new HashMap<String, Long>();
    private Map<String, Long> tempEndTimeMap = new HashMap<String, Long>();

    public LogReplayer(String logNodePrefix, String insertFilePath, ModificationFile modFile, TsFileResource currentTsFileResource, IMemTable memTable, boolean sequence) {
        this.logNodePrefix = logNodePrefix;
        this.insertFilePath = insertFilePath;
        this.modFile = modFile;
        this.currentTsFileResource = currentTsFileResource;
        this.recoverMemTable = memTable;
        this.sequence = sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replayLogs(Supplier<ByteBuffer[]> supplier, VirtualStorageGroupProcessor virtualStorageGroupProcessor) {
        WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + FSFactoryProducer.getFSFactory().getFile(this.insertFilePath).getName(), supplier);
        ILogReader logReader = logNode.getLogReader();
        try {
            while (logReader.hasNext()) {
                try {
                    PhysicalPlan plan = logReader.next();
                    if (plan instanceof InsertPlan) {
                        this.replayInsert((InsertPlan)plan, virtualStorageGroupProcessor);
                        continue;
                    }
                    if (!(plan instanceof DeletePlan)) continue;
                    this.replayDelete((DeletePlan)plan);
                }
                catch (PathNotExistException plan) {
                }
                catch (Exception e) {
                    this.logger.warn("recover wal of {} failed", (Object)this.insertFilePath, (Object)e);
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("meet error when redo wal of {}", (Object)this.insertFilePath, (Object)e);
        }
        finally {
            logReader.close();
            try {
                this.modFile.close();
            }
            catch (IOException e) {
                this.logger.error("Cannot close the modifications file {}", (Object)this.modFile.getFilePath(), (Object)e);
            }
        }
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = this.recoverMemTable.getMemTableMap();
        Iterator<Map.Entry<IDeviceID, IWritableMemChunkGroup>> iterator = memTableMap.entrySet().iterator();
        block15: while (iterator.hasNext()) {
            Map.Entry<IDeviceID, IWritableMemChunkGroup> deviceEntry = iterator.next();
            String deviceId = deviceEntry.getKey().toStringID();
            Iterator<Map.Entry<String, IWritableMemChunk>> iterator2 = deviceEntry.getValue().getMemChunkMap().entrySet().iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block15;
                Map.Entry<String, IWritableMemChunk> measurementEntry = iterator2.next();
                IWritableMemChunk memChunk = measurementEntry.getValue();
                this.currentTsFileResource.updateStartTime(deviceId, memChunk.getFirstPoint());
                this.currentTsFileResource.updateEndTime(deviceId, memChunk.getLastPoint());
            }
            break;
        }
        return;
    }

    private void replayDelete(DeletePlan deletePlan) throws IOException, MetadataException {
        List<PartialPath> paths = deletePlan.getPaths();
        for (PartialPath path : paths) {
            for (PartialPath device : IoTDB.metaManager.getBelongedDevices(path)) {
                this.recoverMemTable.delete(path, device, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime());
            }
            this.modFile.write(new Deletion(path, this.currentTsFileResource.getTsFileSize(), deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime()));
        }
    }

    private void replayInsert(InsertPlan plan, VirtualStorageGroupProcessor virtualStorageGroupProcessor) throws WriteProcessException, QueryProcessException {
        if (this.currentTsFileResource != null) {
            Long endTime;
            long maxTime;
            long minTime;
            if (plan instanceof InsertRowPlan) {
                minTime = ((InsertRowPlan)plan).getTime();
                maxTime = ((InsertRowPlan)plan).getTime();
            } else {
                minTime = ((InsertTabletPlan)plan).getMinTime();
                maxTime = ((InsertTabletPlan)plan).getMaxTime();
            }
            String deviceId = plan.isAligned() ? plan.getDevicePath().getDevicePath().getFullPath() : plan.getDevicePath().getFullPath();
            long lastEndTime = this.currentTsFileResource.getEndTime(deviceId);
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= minTime && this.sequence) {
                return;
            }
            Long startTime = this.tempStartTimeMap.get(deviceId);
            if (startTime == null || startTime > minTime) {
                this.tempStartTimeMap.put(deviceId, minTime);
            }
            if ((endTime = this.tempEndTimeMap.get(deviceId)) == null || endTime < maxTime) {
                this.tempEndTimeMap.put(deviceId, maxTime);
            }
        }
        plan.setMeasurementMNodes(new IMeasurementMNode[plan.getMeasurements().length]);
        try {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableIDTable()) {
                virtualStorageGroupProcessor.getIdTable().getSeriesSchemas(plan);
            } else {
                IoTDB.metaManager.getSeriesSchemasAndReadLockDevice(plan);
                plan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(plan.getDevicePath()));
            }
        }
        catch (IOException | MetadataException e) {
            throw new QueryProcessException("can't replay insert logs, ", e);
        }
        this.checkDataTypeAndMarkFailed(plan.getMeasurementMNodes(), plan);
        if (plan instanceof InsertRowPlan) {
            if (plan.isAligned()) {
                this.recoverMemTable.insertAlignedRow((InsertRowPlan)plan);
            } else {
                this.recoverMemTable.insert((InsertRowPlan)plan);
            }
        } else if (plan.isAligned()) {
            this.recoverMemTable.insertAlignedTablet((InsertTabletPlan)plan, 0, ((InsertTabletPlan)plan).getRowCount());
        } else {
            this.recoverMemTable.insertTablet((InsertTabletPlan)plan, 0, ((InsertTabletPlan)plan).getRowCount());
        }
    }

    private void checkDataTypeAndMarkFailed(IMeasurementMNode[] mNodes, InsertPlan tPlan) {
        for (int i = 0; i < mNodes.length; ++i) {
            if (mNodes[i] == null) {
                tPlan.markFailedMeasurementInsertion(i, new PathNotExistException(tPlan.getDevicePath().getFullPath() + '.' + tPlan.getMeasurements()[i]));
                continue;
            }
            if (mNodes[i].getSchema().getType() == tPlan.getDataTypes()[i]) continue;
            tPlan.markFailedMeasurementInsertion(i, new DataTypeMismatchException(mNodes[i].getName(), tPlan.getDataTypes()[i], mNodes[i].getSchema().getType()));
        }
    }
}

