/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.watermark;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.thrift.EncodingUtils;

public class WatermarkDetector {
    public static void main(String[] args) throws IOException, LogicalOperatorException {
        if (args == null || args.length != 8) {
            throw new IOException("Usage: ./detect-watermark.sh [filePath] [secretKey] [watermarkBitString] [embed_row_cycle] [embed_lsb_num] [alpha] [columnIndex] [dataType: int/float/double]");
        }
        String filePath = args[0];
        String secretKey = args[1];
        String watermarkBitString = args[2];
        int embed_row_cycle = Integer.parseInt(args[3]);
        int embed_lsb_num = Integer.parseInt(args[4]);
        double alpha = Double.parseDouble(args[5]);
        int columnIndex = Integer.parseInt(args[6]);
        String dataType = args[7].toLowerCase();
        if (embed_row_cycle < 1 || embed_lsb_num < 1 || alpha < 0.0 || alpha > 1.0 || columnIndex < 1) {
            throw new IOException("Parameter out of range.");
        }
        if (!("int".equals(dataType) || "float".equals(dataType) || "double".equals(dataType))) {
            throw new IOException("invalid parameter: supported data types are int/float/double");
        }
        WatermarkDetector.isWatermarked(filePath, secretKey, watermarkBitString, embed_row_cycle, embed_lsb_num, alpha, columnIndex, dataType);
    }

    public static boolean isWatermarked(String filePath, String secretKey, String watermarkBitString, int embed_row_cycle, int embed_lsb_num, double alpha, int columnIndex, String dataType) throws LogicalOperatorException, IOException {
        boolean isWatermarked;
        System.out.println("-----Watermark detection begins-----");
        int[] trueNums = new int[watermarkBitString.length()];
        int[] falseNums = new int[watermarkBitString.length()];
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line = reader.readLine();
            String[] items = line.split(",");
            if (columnIndex < 1 || columnIndex > items.length - 1) {
                throw new IOException("columnIndex is out of range.");
            }
            while ((line = reader.readLine()) != null) {
                String str;
                items = line.split(",");
                long timestamp = WatermarkDetector.parseTimestamp(items[0]);
                if (GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d", secretKey, timestamp), embed_row_cycle) != 0 || "null".equals(str = items[columnIndex])) continue;
                int targetBitPosition = GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d%s", secretKey, timestamp, secretKey), embed_lsb_num);
                int groupId = GroupedLSBWatermarkEncoder.hashMod(String.format("%d%s", timestamp, secretKey), watermarkBitString.length());
                boolean isTrue = true;
                switch (dataType) {
                    case "int": {
                        isTrue = EncodingUtils.testBit((int)Integer.parseInt(items[columnIndex]), (int)targetBitPosition);
                        break;
                    }
                    case "float": {
                        int floatToIntBits = Float.floatToIntBits(Float.parseFloat(items[columnIndex]));
                        isTrue = EncodingUtils.testBit((int)floatToIntBits, (int)targetBitPosition);
                        break;
                    }
                    case "double": {
                        long doubleToLongBits = Double.doubleToLongBits(Double.parseDouble(items[columnIndex]));
                        isTrue = EncodingUtils.testBit((long)doubleToLongBits, (int)targetBitPosition);
                        break;
                    }
                }
                if (isTrue) {
                    int n = groupId;
                    trueNums[n] = trueNums[n] + 1;
                    continue;
                }
                int n = groupId;
                falseNums[n] = falseNums[n] + 1;
            }
        }
        int cnt = 0;
        int hit_cnt = 0;
        for (int i = 0; i < watermarkBitString.length(); ++i) {
            int res = trueNums[i] - falseNums[i];
            if (res > 0 && watermarkBitString.charAt(i) == '1') {
                ++hit_cnt;
            } else if (res < 0 && watermarkBitString.charAt(i) == '0') {
                ++hit_cnt;
            }
            if (res == 0) continue;
            ++cnt;
        }
        int b = WatermarkDetector.calMin(cnt, alpha);
        System.out.println(String.format("total counted number = %d, detected hit number = %d", cnt, hit_cnt));
        System.out.println(String.format("To reach the significant level %f, the hit number should be not smaller than: %d", alpha, b));
        if (hit_cnt >= b) {
            System.out.println("Therefore the detection result is: watermarked");
            isWatermarked = true;
        } else {
            System.out.println("Therefore the detection result is: not watermarked");
            isWatermarked = false;
        }
        System.out.println("-----Watermark detection finishes-----");
        return isWatermarked;
    }

    private static long parseTimestamp(String str) throws LogicalOperatorException {
        long timestamp;
        try {
            timestamp = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            try {
                ZoneId zoneId = ZoneId.systemDefault();
                timestamp = DatetimeUtils.convertDatetimeStrToLong(str, zoneId);
            }
            catch (LogicalOperatorException e1) {
                throw new LogicalOperatorException("The format of timestamp is not unexpected.");
            }
        }
        return timestamp;
    }

    private static int calMin(int l, double alpha) {
        int b = l;
        BigDecimal sum = new BigDecimal("1");
        BigDecimal thrs = BigDecimal.valueOf(alpha);
        for (int i = 0; i < l; ++i) {
            thrs = thrs.multiply(new BigDecimal("2"));
        }
        while (sum.compareTo(thrs) < 0) {
            sum = sum.add(WatermarkDetector.Comb(l, --b));
        }
        if (++b > l) {
            System.out.println("The total counted number or the alpha is too small to find b that meets the formula: (C(l,b)+C(l,b+1)+C(l,b+2)+...+C(l,l))/2^l < alpha");
        }
        return b;
    }

    private static BigDecimal Comb(int n, int m) {
        BigDecimal res1 = new BigDecimal("1");
        for (int i = n; i > m; --i) {
            res1 = res1.multiply(new BigDecimal(i));
        }
        BigDecimal res2 = new BigDecimal("1");
        for (int i = 2; i <= n - m; ++i) {
            res2 = res2.multiply(new BigDecimal(i));
        }
        return res1.divide(res2, 10, RoundingMode.HALF_EVEN);
    }
}

