/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.security.encrypt;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.iotdb.db.security.encrypt.AsymmetricEncrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestEncrypt
implements AsymmetricEncrypt {
    private static final Logger logger = LoggerFactory.getLogger(MessageDigestEncrypt.class);
    private static final String ENCRYPT_ALGORITHM = "MD5";
    private static final String STRING_ENCODING = "utf-8";

    @Override
    public void init(String providerParameters) {
    }

    @Override
    public String encrypt(String originPassword) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ENCRYPT_ALGORITHM);
            messageDigest.update(originPassword.getBytes(STRING_ENCODING));
            return new String(messageDigest.digest(), STRING_ENCODING);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            logger.error("meet error while encrypting password.", (Throwable)e);
            return originPassword;
        }
    }

    @Override
    public boolean validate(String originPassword, String encryptPassword) {
        if (originPassword == null) {
            return false;
        }
        return this.encrypt(originPassword).equals(encryptPassword);
    }
}

