/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ResultColumn {
    private final Expression expression;
    private final String alias;
    private TSDataType dataType;
    private List<PartialPath> allPathsInExpression;

    public ResultColumn(Expression expression, String alias) {
        this.expression = expression;
        this.alias = alias;
    }

    public ResultColumn(Expression expression) {
        this.expression = expression;
        this.alias = null;
    }

    public void concat(List<PartialPath> prefixPaths, List<ResultColumn> resultColumns, boolean needAliasCheck) throws LogicalOptimizeException {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        this.expression.concat(prefixPaths, resultExpressions);
        if (needAliasCheck && 1 < resultExpressions.size()) {
            throw new LogicalOptimizeException(String.format("alias '%s' can only be matched with one time series", this.alias));
        }
        for (Expression resultExpression : resultExpressions) {
            resultColumns.add(new ResultColumn(resultExpression, this.alias));
        }
    }

    public void removeWildcards(WildcardsRemover wildcardsRemover, List<ResultColumn> resultColumns, boolean needAliasCheck) throws LogicalOptimizeException {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        this.expression.removeWildcards(wildcardsRemover, resultExpressions);
        if (needAliasCheck && 1 < resultExpressions.size()) {
            throw new LogicalOptimizeException(String.format("alias '%s' can only be matched with one time series", this.alias));
        }
        for (Expression resultExpression : resultExpressions) {
            resultColumns.add(new ResultColumn(resultExpression, this.alias));
        }
    }

    public List<PartialPath> collectPaths() {
        if (this.allPathsInExpression == null) {
            HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
            this.expression.collectPaths(pathSet);
            this.allPathsInExpression = new ArrayList<PartialPath>(pathSet);
        }
        return this.allPathsInExpression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getResultColumnName() {
        return this.alias != null ? this.alias : this.expression.getExpressionString();
    }

    public String getExpressionString() {
        return this.expression.getExpressionString();
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public String toString() {
        return "ResultColumn{expression=" + this.expression + ", alias='" + this.alias + '\'' + '}';
    }

    public final int hashCode() {
        return this.alias == null ? this.getResultColumnName().hashCode() : this.alias.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultColumn)) {
            return false;
        }
        return this.getResultColumnName().equals(((ResultColumn)o).getResultColumnName());
    }
}

