/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MinValueAggrResult
extends AggregateResult {
    public MinValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.MIN_VALUE);
        this.reset();
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable minVal = (Comparable)((Object)statistics.getMinValue());
        this.updateResult(minVal);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        while (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            this.updateResult((Comparable)batchIterator.currentValue());
            batchIterator.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable minVal = null;
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null || minVal != null && minVal.compareTo(values[i]) <= 0) continue;
            minVal = (Comparable)values[i];
        }
        this.updateResult(minVal);
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        Comparable minVal = null;
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (minVal != null && minVal.compareTo(value) <= 0) continue;
            minVal = (Comparable)value;
        }
        this.updateResult(minVal);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        if (another.getResult() != null) {
            Object value = another.getResult();
            this.updateResult((Comparable)value);
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }

    private void updateResult(Comparable<Object> minVal) {
        if (minVal == null) {
            return;
        }
        if (!this.hasCandidateResult() || minVal.compareTo(this.getValue()) < 0) {
            this.setValue(minVal);
        }
    }
}

