/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ExtremeAggrResult
extends AggregateResult {
    protected long timestamp = Long.MIN_VALUE;

    public ExtremeAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.EXTREME);
        this.reset();
    }

    public Object getAbsValue(Object v) {
        switch (this.resultDataType) {
            case DOUBLE: {
                return Math.abs((Double)v);
            }
            case FLOAT: {
                return Float.valueOf(Math.abs(((Float)v).floatValue()));
            }
            case INT32: {
                return Math.abs((Integer)v);
            }
            case INT64: {
                return Math.abs((Long)v);
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(this.resultDataType));
    }

    public Comparable<Object> getExtremeValue(Comparable<Object> extVal, Comparable<Object> currentValue) {
        if (currentValue != null) {
            Comparable absCurrentValue = (Comparable)this.getAbsValue(currentValue);
            if (extVal == null) {
                extVal = currentValue;
            } else {
                Comparable absExtVal = (Comparable)this.getAbsValue(extVal);
                if (absExtVal.compareTo(absCurrentValue) < 0 || absExtVal.compareTo(absCurrentValue) == 0 && extVal.compareTo(currentValue) < 0) {
                    extVal = currentValue;
                }
            }
        }
        return extVal;
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable absMinVal;
        Comparable maxVal = (Comparable)((Object)statistics.getMaxValue());
        Comparable minVal = (Comparable)((Object)statistics.getMinValue());
        Comparable absMaxVal = (Comparable)this.getAbsValue(maxVal);
        Comparable extVal = absMaxVal.compareTo(absMinVal = (Comparable)this.getAbsValue(minVal)) >= 0 ? maxVal : minVal;
        this.updateResult(extVal);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        Comparable<Object> extVal = null;
        while (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            extVal = this.getExtremeValue(extVal, (Comparable)batchIterator.currentValue());
            batchIterator.next();
        }
        this.updateResult(extVal);
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable<Object> extVal = null;
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            extVal = this.getExtremeValue(extVal, (Comparable)values[i]);
        }
        this.updateResult(extVal);
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        Comparable<Object> extVal = null;
        while (valueIterator.hasNext()) {
            extVal = this.getExtremeValue(extVal, (Comparable)valueIterator.next());
        }
        this.updateResult(extVal);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        this.updateResult((Comparable)another.getResult());
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.timestamp = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
    }

    private void updateResult(Comparable<Object> extVal) {
        if (extVal == null) {
            return;
        }
        Comparable absExtVal = (Comparable)this.getAbsValue(extVal);
        Comparable candidateResult = (Comparable)this.getValue();
        Comparable absCandidateResult = (Comparable)this.getAbsValue(this.getValue());
        if (!this.hasCandidateResult() || absExtVal.compareTo(absCandidateResult) > 0 || absExtVal.compareTo(absCandidateResult) == 0 && extVal.compareTo(candidateResult) > 0) {
            this.setValue(extVal);
        }
    }
}

