/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.dropwizard.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metrics.metricsUtils;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBReporter
extends ScheduledReporter {
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private final String prefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBReporter.class);
    private final ServiceProvider serviceProvider;
    private final int rpcPort;
    private final String address;

    protected IoTDBReporter(MetricRegistry registry, String prefix, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop) {
        super(registry, "iotdb-reporter", filter, RATE_UNIT, DURATION_UNIT, executor, shutdownExecutorOnStop);
        this.prefix = prefix;
        IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
        this.rpcPort = ioTDBConfig.getRpcPort();
        this.address = ioTDBConfig.getRpcAddress();
        this.serviceProvider = IoTDB.serviceProvider;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.sendGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.sendCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.sendHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.sendMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.sendTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void sendTimer(String name, Timer timer) {
        this.writeSnapshotAndCount(this.prefixed(name), timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L));
    }

    private void sendMeter(String name, Meter meter) {
        double value = meter.getCount();
        this.updateValue(this.prefixed(name), metricsUtils.emptyMap(), value);
    }

    private void sendHistogram(String name, Histogram histogram) {
        this.writeSnapshotAndCount(this.prefixed(name), histogram.getSnapshot(), histogram.getCount(), 1.0);
    }

    private void sendCounter(String name, Counter counter) {
        double value = counter.getCount();
        this.updateValue(this.prefixed(name), metricsUtils.emptyMap(), value);
    }

    private void sendGauge(String name, Gauge gauge) {
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            double value = ((Number)obj).doubleValue();
            this.updateValue(this.prefixed(name), metricsUtils.emptyMap(), value);
        } else if (obj instanceof Boolean) {
            double value = (Boolean)obj != false ? 1.0 : 0.0;
            this.updateValue(this.prefixed(name), metricsUtils.emptyMap(), value);
        } else {
            LOGGER.warn("Invalid type for Gauge {}: {}", (Object)name, (Object)obj.getClass().getName());
        }
    }

    private void writeSnapshotAndCount(String name, Snapshot snapshot, long count, double factor) {
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.5"), snapshot.getMedian() * factor);
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.75"), snapshot.get75thPercentile() * factor);
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.95"), snapshot.get95thPercentile() * factor);
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.98"), snapshot.get98thPercentile() * factor);
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.99"), snapshot.get99thPercentile() * factor);
        this.updateValue(name, metricsUtils.mapOf("quantile", "0.999"), snapshot.get999thPercentile() * factor);
        this.updateValue(name + "_min", metricsUtils.emptyMap(), snapshot.getMin());
        this.updateValue(name + "_max", metricsUtils.emptyMap(), snapshot.getMax());
        this.updateValue(name + "_median", metricsUtils.emptyMap(), snapshot.getMedian());
        this.updateValue(name + "_mean", metricsUtils.emptyMap(), snapshot.getMean());
        this.updateValue(name + "_stddev", metricsUtils.emptyMap(), snapshot.getStdDev());
        this.updateValue(name + "_count", metricsUtils.emptyMap(), count);
    }

    private void updateValue(String name, Map<String, String> labels, double value) {
        try {
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath(metricsUtils.generatePath(this.address, this.rpcPort, name, labels)), System.currentTimeMillis(), new String[]{"value"}, DataTypeUtils.getValueBuffer(new ArrayList<TSDataType>(Arrays.asList(TSDataType.DOUBLE)), new ArrayList<Object>(Arrays.asList(value))), false);
            this.serviceProvider.executeNonQuery(insertRowPlan);
        }
        catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException | QueryProcessException | IoTDBConnectionException e) {
            LOGGER.error("illegal insertRowPlan,reason:" + e.getMessage());
        }
    }

    private String prefixed(String name) {
        return this.prefix == null ? name : this.prefix + name;
    }

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return new Builder(metricRegistry);
    }

    public static class Builder {
        private final MetricRegistry metricRegistry;
        private String prefix;
        private MetricFilter metricFilter;
        private ScheduledExecutorService executorService;
        private boolean shutdownExecutorOnStop;

        private Builder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            this.prefix = null;
            this.metricFilter = MetricFilter.ALL;
            this.executorService = null;
            this.shutdownExecutorOnStop = true;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder filter(MetricFilter metricFilter) {
            this.metricFilter = metricFilter;
            return this;
        }

        public IoTDBReporter build() {
            return new IoTDBReporter(this.metricRegistry, this.prefix, this.metricFilter, this.executorService, this.shutdownExecutorOnStop);
        }
    }
}

