/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.lastCache;

import java.util.HashSet;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(LastCacheManager.class);
    private static final boolean CACHE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();

    public static TimeValuePair getLastCache(IMeasurementMNode node) {
        if (node == null) {
            return null;
        }
        LastCacheManager.checkIsTemplateLastCacheAndSetIfAbsent(node);
        ILastCacheContainer lastCacheContainer = node.getLastCacheContainer();
        return lastCacheContainer.getCachedLast();
    }

    public static void updateLastCache(IMeasurementMNode node, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (node == null) {
            return;
        }
        LastCacheManager.checkIsTemplateLastCacheAndSetIfAbsent(node);
        ILastCacheContainer lastCacheContainer = node.getLastCacheContainer();
        lastCacheContainer.updateCachedLast(timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public static void resetLastCache(IMeasurementMNode node) {
        if (node == null) {
            return;
        }
        LastCacheManager.checkIsTemplateLastCacheAndSetIfAbsent(node);
        ILastCacheContainer lastCacheContainer = node.getLastCacheContainer();
        lastCacheContainer.resetLastCache();
    }

    private static void checkIsTemplateLastCacheAndSetIfAbsent(IMeasurementMNode node) {
        IEntityMNode entityMNode = node.getParent();
        if (entityMNode == null) {
            return;
        }
        String measurement = node.getName();
        if (!entityMNode.hasChild(measurement)) {
            ILastCacheContainer lastCacheContainer = entityMNode.getLastCacheContainer(measurement);
            node.setLastCacheContainer(lastCacheContainer);
        }
    }

    public static void deleteLastCacheByDevice(IEntityMNode node) {
        for (IMNode iMNode : node.getChildren().values()) {
            if (!iMNode.isMeasurement()) continue;
            iMNode.getAsMeasurementMNode().getLastCacheContainer().resetLastCache();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("[tryToDeleteLastCacheByDevice] Last cache for path: {} is set to null", (Object)iMNode.getFullPath());
        }
        for (Map.Entry entry : node.getTemplateLastCaches().entrySet()) {
            ((ILastCacheContainer)entry.getValue()).resetLastCache();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("[tryToDeleteLastCacheByDevice] Last cache for path: {} is set to null", (Object)node.getPartialPath().concatNode((String)entry.getKey()).getFullPath());
        }
    }

    public static void deleteLastCacheByDevice(IEntityMNode node, PartialPath originalPath, long startTime, long endTime) {
        ILastCacheContainer lastCacheContainer;
        PartialPath path;
        for (IMNode iMNode : node.getChildren().values()) {
            if (iMNode == null || !iMNode.isMeasurement()) continue;
            path = iMNode.getPartialPath();
            IMeasurementMNode measurementMNode = iMNode.getAsMeasurementMNode();
            if (!originalPath.matchFullPath(path) || (lastCacheContainer = measurementMNode.getLastCacheContainer()) == null) continue;
            LastCacheManager.deleteLastCache(path, lastCacheContainer, startTime, endTime);
        }
        for (Map.Entry entry : node.getTemplateLastCaches().entrySet()) {
            path = node.getPartialPath().concatNode((String)entry.getKey());
            if (!originalPath.matchFullPath(path) || (lastCacheContainer = (ILastCacheContainer)entry.getValue()) == null) continue;
            LastCacheManager.deleteLastCache(path, lastCacheContainer, startTime, endTime);
        }
    }

    private static void deleteLastCache(PartialPath path, ILastCacheContainer lastCacheContainer, long startTime, long endTime) {
        TimeValuePair lastPair = lastCacheContainer.getCachedLast();
        if (lastPair != null && startTime <= lastPair.getTimestamp() && lastPair.getTimestamp() <= endTime) {
            lastCacheContainer.resetLastCache();
            if (logger.isDebugEnabled()) {
                logger.debug("[tryToDeleteLastCache] Last cache for path: {} is set to null", (Object)path.getFullPath());
            }
        }
    }

    public static long getLastTimeStamp(IMeasurementMNode node, QueryContext queryContext) {
        TimeValuePair last = LastCacheManager.getLastCache(node);
        if (last != null) {
            return LastCacheManager.getLastCache(node).getTimestamp();
        }
        try {
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(node.getPartialPath(), queryContext, null, false);
            HashSet<String> measurementSet = new HashSet<String>();
            measurementSet.add(node.getPartialPath().getFullPath());
            LastPointReader lastReader = new LastPointReader(node.getPartialPath(), node.getSchema().getType(), measurementSet, queryContext, dataSource, Long.MAX_VALUE, null);
            last = lastReader.readLastPoint();
            if (CACHE_ENABLED && last != null && last.getValue() != null) {
                LastCacheManager.updateLastCache(node, last, false, Long.MIN_VALUE);
            }
            return last != null ? last.getTimestamp() : Long.MIN_VALUE;
        }
        catch (Exception e) {
            logger.error("Something wrong happened while trying to get last time value pair of {}", (Object)node.getFullPath(), (Object)e);
            return Long.MIN_VALUE;
        }
    }
}

