/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class AlignedWritableMemChunkGroup
implements IWritableMemChunkGroup {
    private AlignedWritableMemChunk memChunk;

    public AlignedWritableMemChunkGroup(List<IMeasurementSchema> schemaList) {
        this.memChunk = new AlignedWritableMemChunk(schemaList);
    }

    @Override
    public void writeValues(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        this.memChunk.writeAlignedValues(times, columns, bitMaps, schemaList, start, end);
    }

    @Override
    public void release() {
        this.memChunk.release();
    }

    @Override
    public long count() {
        return this.memChunk.count();
    }

    @Override
    public boolean contains(String measurement) {
        if ("".equals(measurement)) {
            return true;
        }
        return this.memChunk.containsMeasurement(measurement);
    }

    @Override
    public void write(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        this.memChunk.writeAlignedValue(insertTime, objectValue, schemaList);
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        if (this.memChunk.count() == 0L) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("", this.memChunk);
    }

    @Override
    public int delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        int deletedPointsNumber = 0;
        Set<String> measurements = this.memChunk.getAllMeasurements();
        ArrayList<String> columnsToBeRemoved = new ArrayList<String>();
        for (String measurement : measurements) {
            PartialPath fullPath = devicePath.concatNode(measurement);
            if (!originalPath.matchFullPath(fullPath)) continue;
            Pair<Integer, Boolean> deleteInfo = this.memChunk.deleteDataFromAColumn(startTimestamp, endTimestamp, measurement);
            deletedPointsNumber += ((Integer)deleteInfo.left).intValue();
            if (!Boolean.TRUE.equals(deleteInfo.right)) continue;
            columnsToBeRemoved.add(measurement);
        }
        for (String columnToBeRemoved : columnsToBeRemoved) {
            this.memChunk.removeColumn(columnToBeRemoved);
        }
        return deletedPointsNumber;
    }

    @Override
    public long getCurrentTVListSize(String measurement) {
        return this.memChunk.getTVList().rowCount();
    }

    public AlignedWritableMemChunk getAlignedMemChunk() {
        return this.memChunk;
    }
}

