/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionTask
extends AbstractCrossSpaceCompactionTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedSeqTsFileResourceList;
    protected List<TsFileResource> selectedUnSeqTsFileResourceList;
    protected TsFileResourceList seqTsFileResourceList;
    protected TsFileResourceList unseqTsFileResourceList;
    protected TsFileManager tsFileManager;
    private File logFile;
    private List<TsFileResource> targetTsfileResourceList;
    private List<TsFileResource> holdReadLockList = new ArrayList<TsFileResource>();
    private List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();

    public RewriteCrossSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartitionId, TsFileManager tsFileManager, List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList, AtomicInteger currentTaskNum) {
        super(logicalStorageGroupName + "-" + virtualStorageGroupName, timePartitionId, currentTaskNum, selectedSeqTsFileResourceList, selectedUnSeqTsFileResourceList);
        this.selectedSeqTsFileResourceList = selectedSeqTsFileResourceList;
        this.selectedUnSeqTsFileResourceList = selectedUnSeqTsFileResourceList;
        this.seqTsFileResourceList = tsFileManager.getSequenceListByTimePartition(this.timePartition);
        this.unseqTsFileResourceList = tsFileManager.getUnsequenceListByTimePartition(this.timePartition);
        this.tsFileManager = tsFileManager;
    }

    @Override
    protected void doCompaction() throws Exception {
        try {
            this.executeCompaction();
        }
        catch (Throwable throwable) {
            logger.error("Meet errors in cross space compaction, {}", (Object)throwable.getMessage());
            CrossSpaceCompactionExceptionHandler.handleException(this.fullStorageGroupName, this.logFile, this.targetTsfileResourceList, this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.tsFileManager, this.timePartition);
            throw throwable;
        }
        finally {
            this.releaseAllLock();
        }
    }

    private void executeCompaction() throws IOException, StorageEngineException, MetadataException, InterruptedException, WriteProcessException {
        if (!this.tsFileManager.isAllowCompaction()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.targetTsfileResourceList = TsFileNameGenerator.getCrossCompactionTargetFileResources(this.selectedSeqTsFileResourceList);
        if (this.targetTsfileResourceList.isEmpty() || this.selectedSeqTsFileResourceList.isEmpty() || this.selectedUnSeqTsFileResourceList.isEmpty()) {
            logger.info("{} [Compaction] Cross space compaction file list is empty, end it", (Object)this.fullStorageGroupName);
            return;
        }
        logger.info("{} [Compaction] CrossSpaceCompactionTask start. Sequence files : {}, unsequence files : {}", new Object[]{this.fullStorageGroupName, this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList});
        this.logFile = new File(this.selectedSeqTsFileResourceList.get(0).getTsFile().getParent() + File.separator + this.targetTsfileResourceList.get(0).getTsFile().getName() + ".cross-compaction.log");
        try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
            compactionLogger.logFiles(this.selectedSeqTsFileResourceList, "source");
            compactionLogger.logFiles(this.selectedUnSeqTsFileResourceList, "source");
            compactionLogger.logFiles(this.targetTsfileResourceList, "target");
            compactionLogger.close();
            CompactionUtils.compact(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList);
            CompactionUtils.moveTargetFile(this.targetTsfileResourceList, false, this.fullStorageGroupName);
            CompactionUtils.combineModsInCompaction(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList);
            this.tsFileManager.replace(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList, this.timePartition, true);
            this.releaseReadAndLockWrite(this.selectedSeqTsFileResourceList);
            this.releaseReadAndLockWrite(this.selectedUnSeqTsFileResourceList);
            this.deleteOldFiles(this.selectedSeqTsFileResourceList);
            this.deleteOldFiles(this.selectedUnSeqTsFileResourceList);
            CompactionUtils.deleteCompactionModsFile(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList);
            if (this.logFile.exists()) {
                FileUtils.delete((File)this.logFile);
            }
            logger.info("{} [Compaction] CrossSpaceCompactionTask Costs {} s", (Object)this.fullStorageGroupName, (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
    }

    private boolean addReadLock(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readLock();
            this.holdReadLockList.add(tsFileResource);
            if (tsFileResource.isCompacting() || !tsFileResource.isClosed() || !tsFileResource.getTsFile().exists() || tsFileResource.isDeleted()) {
                this.releaseAllLock();
                return false;
            }
            tsFileResource.setCompacting(true);
        }
        return true;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        return this.addReadLock(this.selectedSeqTsFileResourceList) && this.addReadLock(this.selectedUnSeqTsFileResourceList);
    }

    private void releaseReadAndLockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readUnlock();
            this.holdReadLockList.remove(tsFileResource);
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    private void releaseAllLock() {
        this.selectedSeqTsFileResourceList.forEach(x -> x.setCompactionCandidate(false));
        this.selectedUnSeqTsFileResourceList.forEach(x -> x.setCompactionCandidate(false));
        for (TsFileResource tsFileResource : this.holdReadLockList) {
            tsFileResource.readUnlock();
            tsFileResource.setCompacting(false);
        }
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
            tsFileResource.setCompacting(false);
        }
        this.holdReadLockList.clear();
        this.holdWriteLockList.clear();
    }

    private void deleteOldFiles(List<TsFileResource> tsFileResourceList) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
            tsFileResource.setDeleted(true);
            tsFileResource.remove();
            logger.info("[CrossSpaceCompaction] Delete TsFile :{}.", (Object)tsFileResource.getTsFile().getAbsolutePath());
        }
    }

    public String getStorageGroupName() {
        return this.fullStorageGroupName;
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof RewriteCrossSpaceCompactionTask) {
            RewriteCrossSpaceCompactionTask otherTask = (RewriteCrossSpaceCompactionTask)other;
            return otherTask.selectedSeqTsFileResourceList.equals(this.selectedSeqTsFileResourceList) && otherTask.selectedUnSeqTsFileResourceList.equals(this.selectedUnSeqTsFileResourceList);
        }
        return false;
    }
}

