/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.concurrent.threadpool.WrappedScheduledExecutorService;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskComparator;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.metrics.Metric;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.Tag;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final CompactionTaskManager INSTANCE = new CompactionTaskManager();
    private WrappedScheduledExecutorService taskExecutionPool;
    public static volatile AtomicInteger currentTaskNum = new AtomicInteger(0);
    private FixedPriorityBlockingQueue<AbstractCompactionTask> candidateCompactionTaskQueue = new FixedPriorityBlockingQueue<AbstractCompactionTask>(1024, new CompactionTaskComparator());
    private Map<String, Set<Future<Void>>> storageGroupTasks = new ConcurrentHashMap<String, Set<Future<Void>>>();
    private Map<String, Map<Long, Set<Future<Void>>>> compactionTaskFutures = new ConcurrentHashMap<String, Map<Long, Set<Future<Void>>>>();
    private List<AbstractCompactionTask> runningCompactionTaskList = new ArrayList<AbstractCompactionTask>();
    private ScheduledExecutorService compactionTaskSubmissionThreadPool;
    private final long TASK_SUBMIT_INTERVAL = IoTDBDescriptor.getInstance().getConfig().getCompactionSubmissionIntervalInMs();
    private final RateLimiter mergeWriteRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);

    public static CompactionTaskManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void start() {
        if (this.taskExecutionPool == null && IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0) {
            this.taskExecutionPool = (WrappedScheduledExecutorService)IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), ThreadName.COMPACTION_SERVICE.getName());
            currentTaskNum = new AtomicInteger(0);
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool(1, ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.compactionTaskSubmissionThreadPool.scheduleWithFixedDelay(this::submitTaskFromTaskQueue, this.TASK_SUBMIT_INTERVAL, this.TASK_SUBMIT_INTERVAL, TimeUnit.MILLISECONDS);
        }
        logger.info("Compaction task manager started.");
    }

    @Override
    public void stop() {
        if (this.taskExecutionPool != null) {
            this.taskExecutionPool.shutdownNow();
            this.compactionTaskSubmissionThreadPool.shutdownNow();
            logger.info("Waiting for task taskExecutionPool to shut down");
            this.waitTermination();
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
        }
    }

    @Override
    public void waitAndStop(long milliseconds) {
        if (this.taskExecutionPool != null) {
            this.awaitTermination(this.taskExecutionPool, milliseconds);
            this.awaitTermination(this.compactionTaskSubmissionThreadPool, milliseconds);
            logger.info("Waiting for task taskExecutionPool to shut down");
            this.waitTermination();
            this.storageGroupTasks.clear();
        }
    }

    public void waitAllCompactionFinish() {
        long sleepingStartTime = 0L;
        long MAX_WAITING_TIME = 120000L;
        if (this.taskExecutionPool != null) {
            while (this.taskExecutionPool.getActiveCount() > 0 || this.taskExecutionPool.getQueue().size() > 0) {
                try {
                    Thread.sleep(200L);
                    if ((sleepingStartTime += 200L) % 10000L == 0L) {
                        logger.warn("Has waiting {} seconds for all compaction task finish", (Object)(sleepingStartTime / 1000L));
                    }
                    if (sleepingStartTime < MAX_WAITING_TIME) continue;
                    return;
                }
                catch (InterruptedException e) {
                    logger.error("thread interrupted while waiting for compaction to end", (Throwable)e);
                    return;
                }
            }
            this.storageGroupTasks.clear();
            logger.info("All compaction task finish");
        }
    }

    private void waitTermination() {
        long startTime = System.currentTimeMillis();
        while (!this.taskExecutionPool.isTerminated()) {
            int timeMillis = 0;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("CompactionMergeTaskPoolManager {} shutdown", (Object)ThreadName.COMPACTION_SERVICE.getName(), (Object)e);
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.info("CompactionManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        this.taskExecutionPool = null;
        this.storageGroupTasks.clear();
        logger.info("CompactionManager stopped");
    }

    private void awaitTermination(ExecutorService service, long milliseconds) {
        try {
            service.shutdown();
            service.awaitTermination(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("CompactionThreadPool can not be closed in {} ms", (Object)milliseconds);
            Thread.currentThread().interrupt();
        }
        service.shutdownNow();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.COMPACTION_SERVICE;
    }

    public synchronized boolean addTaskToWaitingQueue(AbstractCompactionTask compactionTask) throws InterruptedException {
        if (!this.candidateCompactionTaskQueue.contains(compactionTask) && !this.runningCompactionTaskList.contains(compactionTask)) {
            compactionTask.setSourceFilesToCompactionCandidate();
            this.candidateCompactionTaskQueue.put(compactionTask);
            if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                this.addMetrics(compactionTask, true, false);
            }
            return true;
        }
        return false;
    }

    public synchronized void submitTaskFromTaskQueue() {
        try {
            while (currentTaskNum.get() < IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() && !this.candidateCompactionTaskQueue.isEmpty()) {
                AbstractCompactionTask task = this.candidateCompactionTaskQueue.take();
                if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                    this.addMetrics(task, false, false);
                }
                if (task == null || !task.checkValidAndSetMerging()) continue;
                this.submitTask(task.getFullStorageGroupName(), task.getTimePartition(), task);
                this.runningCompactionTaskList.add(task);
                if (!MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) continue;
                this.addMetrics(task, true, true);
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception occurs while submitting compaction task", (Throwable)e);
        }
    }

    public RateLimiter getMergeWriteRateLimiter() {
        this.setWriteMergeRate(IoTDBDescriptor.getInstance().getConfig().getCompactionWriteThroughputMbPerSec());
        return this.mergeWriteRateLimiter;
    }

    private void setWriteMergeRate(double throughoutMbPerSec) {
        double throughout = throughoutMbPerSec * 1024.0 * 1024.0;
        if (throughout == 0.0) {
            throughout = Double.MAX_VALUE;
        }
        if (this.mergeWriteRateLimiter.getRate() != throughout) {
            this.mergeWriteRateLimiter.setRate(throughout);
        }
    }

    public static void mergeRateLimiterAcquire(RateLimiter limiter, long bytesLength) {
        while (bytesLength >= Integer.MAX_VALUE) {
            limiter.acquire(Integer.MAX_VALUE);
            bytesLength -= Integer.MAX_VALUE;
        }
        if (bytesLength > 0L) {
            limiter.acquire((int)bytesLength);
        }
    }

    private void addMetrics(AbstractCompactionTask task, boolean isAdd, boolean isRunning) {
        String taskType = "unknown";
        if (task instanceof AbstractInnerSpaceCompactionTask) {
            taskType = "inner";
        } else if (task instanceof AbstractCrossSpaceCompactionTask) {
            taskType = "cross";
        }
        Gauge gauge = MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + taskType, Tag.STATUS.toString(), isRunning ? "running" : "waiting"});
        if (isAdd) {
            gauge.incr(1L);
        } else {
            gauge.decr(1L);
        }
    }

    public synchronized void removeRunningTaskFromList(AbstractCompactionTask task) {
        this.runningCompactionTaskList.remove(task);
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            this.addMetrics(task, false, true);
        }
    }

    public synchronized void submitTask(String fullStorageGroupName, long timePartition, Callable<Void> compactionMergeTask) throws RejectedExecutionException {
        if (this.taskExecutionPool != null && !this.taskExecutionPool.isTerminated()) {
            Future<Void> future = this.taskExecutionPool.submit(compactionMergeTask);
            this.compactionTaskFutures.computeIfAbsent(fullStorageGroupName, k -> new ConcurrentHashMap()).computeIfAbsent(timePartition, k -> new HashSet()).add(future);
            return;
        }
        logger.warn("A CompactionTask failed to be submitted to CompactionTaskManager because {}", (Object)(this.taskExecutionPool == null ? "taskExecutionPool is null" : "taskExecutionPool is terminated"));
    }

    public void abortCompaction(String fullStorageGroupName) {
        Set subTasks = this.storageGroupTasks.getOrDefault(fullStorageGroupName, Collections.emptySet());
        this.candidateCompactionTaskQueue.clear();
        Iterator subIterator = subTasks.iterator();
        while (subIterator.hasNext()) {
            Future next = (Future)subIterator.next();
            if (!next.isDone() && !next.isCancelled()) {
                next.cancel(true);
            }
            subIterator.remove();
        }
    }

    public int getExecutingTaskCount() {
        return this.taskExecutionPool.getActiveCount() + this.taskExecutionPool.getQueue().size();
    }

    public int getTotalTaskCount() {
        return this.getExecutingTaskCount() + this.candidateCompactionTaskQueue.size();
    }

    public synchronized List<AbstractCompactionTask> getRunningCompactionTaskList() {
        return new ArrayList<AbstractCompactionTask>(this.runningCompactionTaskList);
    }

    public long getFinishTaskNum() {
        return this.taskExecutionPool.getCompletedTaskCount();
    }

    public void restart() throws InterruptedException {
        if (IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0) {
            if (this.taskExecutionPool != null) {
                this.taskExecutionPool.shutdownNow();
                this.taskExecutionPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            this.taskExecutionPool = (WrappedScheduledExecutorService)IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), ThreadName.COMPACTION_SERVICE.getName());
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool(1, ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.clear();
        }
        currentTaskNum = new AtomicInteger(0);
        logger.info("Compaction task manager started.");
    }

    public void clearCandidateQueue() {
        this.candidateCompactionTaskQueue.clear();
    }
}

