/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MonitorType;
import org.apache.iotdb.metrics.utils.PredefinedMetric;
import org.apache.iotdb.metrics.utils.ReporterType;

public class MetricConfig {
    private Boolean enableMetric = false;
    private Integer pushPeriodInSecond = 5;
    private MonitorType monitorType = MonitorType.MICROMETER;
    private List<ReporterType> metricReporterList = Arrays.asList(ReporterType.JMX, ReporterType.PROMETHEUS);
    private MetricLevel metricLevel = MetricLevel.IMPORTANT;
    private List<PredefinedMetric> predefinedMetrics = Collections.singletonList(PredefinedMetric.JVM);
    private String prometheusExporterPort = "9091";

    public void copy(MetricConfig newMetricConfig) {
        this.enableMetric = newMetricConfig.getEnableMetric();
        this.monitorType = newMetricConfig.getMonitorType();
        this.metricReporterList = newMetricConfig.getMetricReporterList();
        this.metricLevel = newMetricConfig.getMetricLevel();
        this.predefinedMetrics = newMetricConfig.getPredefinedMetrics();
        this.prometheusExporterPort = newMetricConfig.getPrometheusExporterPort();
    }

    public Boolean getEnableMetric() {
        return this.enableMetric;
    }

    public void setEnableMetric(Boolean enableMetric) {
        this.enableMetric = enableMetric;
    }

    public Integer getPushPeriodInSecond() {
        return this.pushPeriodInSecond;
    }

    public void setPushPeriodInSecond(Integer pushPeriodInSecond) {
        this.pushPeriodInSecond = pushPeriodInSecond;
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
    }

    public List<ReporterType> getMetricReporterList() {
        return this.metricReporterList;
    }

    public void setMetricReporterList(List<ReporterType> metricReporterList) {
        this.metricReporterList = metricReporterList;
    }

    public MetricLevel getMetricLevel() {
        return this.metricLevel;
    }

    public void setMetricLevel(MetricLevel metricLevel) {
        this.metricLevel = metricLevel;
    }

    public List<PredefinedMetric> getPredefinedMetrics() {
        return this.predefinedMetrics;
    }

    public void setPredefinedMetrics(List<PredefinedMetric> predefinedMetrics) {
        this.predefinedMetrics = predefinedMetrics;
    }

    public String getPrometheusExporterPort() {
        return this.prometheusExporterPort;
    }

    public void setPrometheusExporterPort(String prometheusExporterPort) {
        this.prometheusExporterPort = prometheusExporterPort;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricConfig)) {
            return false;
        }
        MetricConfig anotherMetricConfig = (MetricConfig)obj;
        return this.enableMetric.equals(anotherMetricConfig.getEnableMetric()) && this.pushPeriodInSecond.equals(anotherMetricConfig.getPushPeriodInSecond()) && this.monitorType.equals((Object)anotherMetricConfig.getMonitorType()) && this.metricReporterList.equals(anotherMetricConfig.getMetricReporterList()) && this.metricLevel.equals((Object)anotherMetricConfig.getMetricLevel()) && this.predefinedMetrics.equals(anotherMetricConfig.getPredefinedMetrics()) && this.prometheusExporterPort.equals(anotherMetricConfig.getPrometheusExporterPort());
    }
}

