/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class MetricName {
    public static final String SEPARATOR = ":";
    private String name;
    private MetricLevel metricLevel;
    private Map<String, String> tags;

    public MetricName(String name, String ... tags) {
        this.name = name;
        this.tags = new HashMap<String, String>();
        for (int i = 0; i < tags.length; i += 2) {
            this.tags.put(tags[i], tags[i + 1]);
        }
    }

    public MetricName(String name, MetricLevel metricLevel, String ... tags) {
        this(name, tags);
        this.metricLevel = metricLevel;
    }

    public String toFlatString() {
        StringBuilder stringBuilder = new StringBuilder(this.name).append("_");
        this.tags.forEach((k, v) -> stringBuilder.append((String)k).append(SEPARATOR).append((String)v).append("_"));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public String[] toStringArray() {
        ArrayList<String> allNames = new ArrayList<String>();
        allNames.add(this.name);
        this.tags.forEach((k, v) -> {
            allNames.add((String)k);
            allNames.add((String)v);
        });
        return allNames.toArray(new String[0]);
    }

    public String toString() {
        return "MetricName{name='" + this.name + "', tags=" + this.tags + '}';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricLevel getMetricLevel() {
        return this.metricLevel;
    }

    public void setMetricLevel(MetricLevel metricLevel) {
        this.metricLevel = metricLevel;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricName)) {
            return false;
        }
        MetricName that = (MetricName)obj;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (that.getTags().size() != this.tags.size()) {
            return false;
        }
        Map<String, String> thatTags = that.getTags();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            if (!thatTags.containsKey(entry.getKey())) {
                return false;
            }
            if (thatTags.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }
}

