/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v2.file.footer.ChunkGroupFooterV2;
import org.apache.iotdb.tsfile.v2.file.header.ChunkHeaderV2;
import org.apache.iotdb.tsfile.v2.file.header.PageHeaderV2;
import org.apache.iotdb.tsfile.v2.file.metadata.ChunkMetadataV2;
import org.apache.iotdb.tsfile.v2.file.metadata.MetadataIndexNodeV2;
import org.apache.iotdb.tsfile.v2.file.metadata.TimeseriesMetadataV2;
import org.apache.iotdb.tsfile.v2.file.metadata.TsFileMetadataV2;

public class TsFileSequenceReaderForV2
extends TsFileSequenceReader
implements AutoCloseable {
    private List<Pair<Long, Long>> versionInfo;

    public TsFileSequenceReaderForV2(String file) throws IOException {
        this(file, true);
    }

    public TsFileSequenceReaderForV2(String file, boolean loadMetadataSize) throws IOException {
        super(file, loadMetadataSize);
    }

    public TsFileSequenceReaderForV2(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReaderForV2(TsFileInput input, boolean loadMetadataSize) throws IOException {
        super(input, loadMetadataSize);
    }

    public TsFileSequenceReaderForV2(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        super(input, fileMetadataPos, fileMetadataSize);
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    @Override
    public boolean isComplete() throws IOException {
        return this.tsFileInput.size() >= (long)("TsFile".getBytes().length * 2 + "000002".getBytes().length) && this.readTailMagic().equals(this.readHeadMagic());
    }

    public String readVersionNumberV2() throws IOException {
        ByteBuffer versionNumberBytes = ByteBuffer.allocate("000002".getBytes().length);
        this.tsFileInput.read(versionNumberBytes, "TsFile".getBytes().length);
        versionNumberBytes.flip();
        return new String(versionNumberBytes.array());
    }

    @Override
    public TsFileMetadata readFileMetadata() throws IOException {
        if (this.tsFileMetaData == null || this.versionInfo == null) {
            Pair<TsFileMetadata, List<Pair<Long, Long>>> pair = TsFileMetadataV2.deserializeFrom(this.readData(this.fileMetadataPos, this.fileMetadataSize));
            this.tsFileMetaData = (TsFileMetadata)pair.left;
            this.versionInfo = (List)pair.right;
        }
        return this.tsFileMetaData;
    }

    @Override
    public TimeseriesMetadata readTimeseriesMetadata(Path path, boolean ignoreNotExists) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetV2(deviceMetadataIndexNode, path.getDevice(), MetadataIndexNodeType.INTERNAL_DEVICE, true);
        if (metadataIndexPair == null) {
            if (ignoreNotExists) {
                return null;
            }
            return null;
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            metadataIndexNode = MetadataIndexNodeV2.deserializeFrom(buffer);
            metadataIndexPair = this.getMetadataAndEndOffsetV2(metadataIndexNode, path.getMeasurement(), MetadataIndexNodeType.INTERNAL_MEASUREMENT, false);
        }
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            TimeseriesMetadata timeseriesMetadata = TimeseriesMetadataV2.deserializeFrom(buffer);
            List chunkMetadataList = this.readChunkMetaDataList(timeseriesMetadata);
            timeseriesMetadata.setChunkMetadataList((ArrayList<ChunkMetadata>)chunkMetadataList);
            timeseriesMetadataList.add(timeseriesMetadata);
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        return searchResult >= 0 ? (TimeseriesMetadata)timeseriesMetadataList.get(searchResult) : null;
    }

    @Override
    public List<TimeseriesMetadata> readTimeseriesMetadata(Path path, Set<String> allSensors) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            metadataIndexNode = MetadataIndexNodeV2.deserializeFrom(buffer);
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        }
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            TimeseriesMetadata timeseriesMetadata = TimeseriesMetadataV2.deserializeFrom(buffer);
            List chunkMetadataList = this.readChunkMetaDataList(timeseriesMetadata);
            timeseriesMetadata.setChunkMetadataList((ArrayList<ChunkMetadata>)chunkMetadataList);
            if (!allSensors.contains(timeseriesMetadata.getMeasurementId())) continue;
            timeseriesMetadataList.add(timeseriesMetadata);
        }
        return timeseriesMetadataList;
    }

    @Override
    public List<ITimeSeriesMetadata> readITimeseriesMetadata(String device, Set<String> measurements) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetV2(deviceMetadataIndexNode, device, MetadataIndexNodeType.INTERNAL_DEVICE, false);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<ITimeSeriesMetadata> resultTimeseriesMetadataList = new ArrayList<ITimeSeriesMetadata>();
        ArrayList<String> measurementList = new ArrayList<String>(measurements);
        HashSet<String> measurementsHadFound = new HashSet<String>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (measurementsHadFound.contains(measurementList.get(i))) continue;
            ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
            Pair<MetadataIndexEntry, Long> measurementMetadataIndexPair = metadataIndexPair;
            ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
            MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
            if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                metadataIndexNode = MetadataIndexNodeV2.deserializeFrom(buffer);
                measurementMetadataIndexPair = this.getMetadataAndEndOffsetV2(metadataIndexNode, (String)measurementList.get(i), MetadataIndexNodeType.INTERNAL_MEASUREMENT, false);
            }
            if (measurementMetadataIndexPair == null) {
                return Collections.emptyList();
            }
            buffer = this.readData(((MetadataIndexEntry)measurementMetadataIndexPair.left).getOffset(), (Long)measurementMetadataIndexPair.right);
            while (buffer.hasRemaining()) {
                TimeseriesMetadata timeseriesMetadata = TimeseriesMetadataV2.deserializeFrom(buffer);
                List chunkMetadataList = this.readChunkMetaDataList(timeseriesMetadata);
                timeseriesMetadata.setChunkMetadataList((ArrayList<ChunkMetadata>)chunkMetadataList);
                timeseriesMetadataList.add(timeseriesMetadata);
            }
            for (int j = i; j < measurementList.size(); ++j) {
                int searchResult;
                String current = (String)measurementList.get(j);
                if (!measurementsHadFound.contains(current) && (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, current)) >= 0) {
                    resultTimeseriesMetadataList.add((ITimeSeriesMetadata)timeseriesMetadataList.get(searchResult));
                    measurementsHadFound.add(current);
                }
                if (measurementsHadFound.size() != measurements.size()) continue;
                return resultTimeseriesMetadataList;
            }
        }
        return resultTimeseriesMetadataList;
    }

    @Override
    public List<String> getAllDevices() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        return this.getAllDevicesV2(this.tsFileMetaData.getMetadataIndex());
    }

    private List<String> getAllDevicesV2(MetadataIndexNode metadataIndexNode) throws IOException {
        ArrayList<String> deviceList = new ArrayList<String>();
        int metadataIndexListSize = metadataIndexNode.getChildren().size();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
            for (MetadataIndexEntry index : metadataIndexNode.getChildren()) {
                deviceList.add(index.getName());
            }
        } else {
            for (int i = 0; i < metadataIndexListSize; ++i) {
                ByteBuffer buffer;
                MetadataIndexNode node;
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if ((node = MetadataIndexNodeV2.deserializeFrom(buffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset))).getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceList.addAll(node.getChildren().stream().map(MetadataIndexEntry::getName).collect(Collectors.toList()));
                    continue;
                }
                deviceList.addAll(this.getAllDevicesV2(node));
            }
        }
        return deviceList;
    }

    @Override
    public Map<String, List<ChunkMetadata>> readChunkMetadataInDevice(String device) throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        long start = 0L;
        int size = 0;
        List<TimeseriesMetadata> timeseriesMetadataMap = this.getDeviceTimeseriesMetadataV2(device);
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap) {
            if (start == 0L) {
                start = timeseriesMetadata.getOffsetOfChunkMetaDataList();
            }
            size += timeseriesMetadata.getDataSizeOfChunkMetaDataList();
        }
        ByteBuffer buffer = this.readData(start, size);
        HashMap<String, List<ChunkMetadata>> seriesMetadata = new HashMap<String, List<ChunkMetadata>>();
        while (buffer.hasRemaining()) {
            ChunkMetadata chunkMetadata = ChunkMetadataV2.deserializeFrom(buffer);
            seriesMetadata.computeIfAbsent(chunkMetadata.getMeasurementUid(), key -> new ArrayList()).add(chunkMetadata);
        }
        for (Map.Entry entry : seriesMetadata.entrySet()) {
            this.applyVersion((List)entry.getValue());
        }
        return seriesMetadata;
    }

    private void generateMetadataIndexV2(MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        switch (type) {
            case INTERNAL_DEVICE: 
            case LEAF_DEVICE: 
            case INTERNAL_MEASUREMENT: {
                deviceId = metadataIndex.getName();
                MetadataIndexNode metadataIndexNode = MetadataIndexNodeV2.deserializeFrom(buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                    this.generateMetadataIndexV2(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap);
                }
                break;
            }
            case LEAF_MEASUREMENT: {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadataV2.deserializeFrom(buffer);
                    List chunkMetadataList = this.readChunkMetaDataList(timeseriesMetadata);
                    timeseriesMetadata.setChunkMetadataList((ArrayList<ChunkMetadata>)chunkMetadataList);
                    timeseriesMetadataList.add(timeseriesMetadata);
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            }
        }
    }

    @Override
    public Map<String, List<TimeseriesMetadata>> getAllTimeseriesMetadata() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        HashMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<String, List<TimeseriesMetadata>>();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            this.generateMetadataIndexV2(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap);
        }
        return timeseriesMetadataMap;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadataV2(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetV2(metadataIndexNode, device, MetadataIndexNodeType.INTERNAL_DEVICE, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndexV2((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    private Pair<MetadataIndexEntry, Long> getMetadataAndEndOffsetV2(MetadataIndexNode metadataIndex, String name, MetadataIndexNodeType type, boolean exactSearch) throws IOException {
        if (!metadataIndex.getNodeType().equals((Object)type)) {
            return metadataIndex.getChildIndexEntry(name, exactSearch);
        }
        Pair<MetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry(name, false);
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right);
        return this.getMetadataAndEndOffsetV2(MetadataIndexNodeV2.deserializeFrom(buffer), name, type, false);
    }

    public ChunkGroupHeader readChunkGroupFooter() throws IOException {
        return ChunkGroupFooterV2.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkHeader readChunkHeader() throws IOException {
        return ChunkHeaderV2.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    private ChunkHeader readChunkHeader(long position, int chunkHeaderSize, boolean markerRead) throws IOException {
        return ChunkHeaderV2.deserializeFrom(this.tsFileInput, position, chunkHeaderSize, markerRead);
    }

    private ByteBuffer readChunkV2(long position, int dataSize) throws IOException {
        return this.readData(position, dataSize);
    }

    @Override
    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        int chunkHeadSize = ChunkHeaderV2.getSerializedSize(metaData.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), chunkHeadSize, false);
        ByteBuffer buffer = this.readChunkV2(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        Chunk chunk = new Chunk(header, buffer, metaData.getDeleteIntervalList(), metaData.getStatistics());
        chunk.setFromOldFile(true);
        return chunk;
    }

    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return PageHeaderV2.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type);
    }

    public long readVersion() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        return buffer.getLong();
    }

    public ArrayList<ChunkMetadata> readChunkMetaDataList(TimeseriesMetadata timeseriesMetaData) throws IOException {
        this.readFileMetadata();
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        long startOffsetOfChunkMetadataList = timeseriesMetaData.getOffsetOfChunkMetaDataList();
        int dataSizeOfChunkMetadataList = timeseriesMetaData.getDataSizeOfChunkMetaDataList();
        ByteBuffer buffer = this.readData(startOffsetOfChunkMetadataList, dataSizeOfChunkMetadataList);
        while (buffer.hasRemaining()) {
            chunkMetadataList.add(ChunkMetadataV2.deserializeFrom(buffer));
        }
        chunkMetadataList.trimToSize();
        this.applyVersion(chunkMetadataList);
        return chunkMetadataList;
    }

    private void applyVersion(List<ChunkMetadata> chunkMetadataList) {
        if (this.versionInfo == null || this.versionInfo.isEmpty()) {
            return;
        }
        int versionIndex = 0;
        for (IChunkMetadata iChunkMetadata : chunkMetadataList) {
            while (iChunkMetadata.getOffsetOfChunkHeader() >= (Long)this.versionInfo.get((int)versionIndex).left) {
                ++versionIndex;
            }
            iChunkMetadata.setVersion((Long)this.versionInfo.get((int)versionIndex).right);
        }
    }
}

