/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.controller;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;

public class CachedChunkLoaderImpl
implements IChunkLoader {
    private static final int DEFAULT_CHUNK_CACHE_SIZE = 1000;
    private TsFileSequenceReader reader;
    private LRUCache<ChunkMetadata, Chunk> chunkCache;

    public CachedChunkLoaderImpl(TsFileSequenceReader fileSequenceReader) {
        this(fileSequenceReader, 1000);
    }

    public CachedChunkLoaderImpl(TsFileSequenceReader fileSequenceReader, int cacheSize) {
        this.reader = fileSequenceReader;
        this.chunkCache = new LRUCache<ChunkMetadata, Chunk>(cacheSize){

            @Override
            public Chunk loadObjectByKey(ChunkMetadata metaData) throws IOException {
                return CachedChunkLoaderImpl.this.reader.readMemChunk(metaData);
            }
        };
    }

    @Override
    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        chunkMetaData.setFilePath(this.reader.getFileName());
        Chunk chunk = this.chunkCache.get(chunkMetaData);
        return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

