/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class SeriesReader {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final TimeOrderUtils orderUtils;
    private final PartialPath seriesPath;
    private final Set<String> allSensors;
    private final TSDataType dataType;
    private final QueryContext context;
    private final Filter timeFilter;
    private final Filter valueFilter;
    private final TsFileFilter fileFilter;
    private final QueryDataSource dataSource;
    private int curSeqFileIndex;
    private int curUnseqFileIndex;
    private TimeseriesMetadata firstTimeSeriesMetadata;
    private final List<TimeseriesMetadata> seqTimeSeriesMetadata = new LinkedList<TimeseriesMetadata>();
    private final PriorityQueue<TimeseriesMetadata> unSeqTimeSeriesMetadata;
    private ChunkMetadata firstChunkMetadata;
    private final PriorityQueue<ChunkMetadata> cachedChunkMetadata;
    private VersionPageReader firstPageReader;
    private final List<VersionPageReader> seqPageReaders = new LinkedList<VersionPageReader>();
    private final PriorityQueue<VersionPageReader> unSeqPageReaders;
    private final PriorityMergeReader mergeReader;
    private boolean hasCachedNextOverlappedPage;
    private BatchData cachedBatchData;

    public SeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        this.dataSource = dataSource;
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        this.fileFilter = fileFilter;
        if (ascending) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = new PriorityMergeReader();
            this.curSeqFileIndex = 0;
            this.curUnseqFileIndex = 0;
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = new DescPriorityMergeReader();
            this.curSeqFileIndex = dataSource.getSeqResourcesSize() - 1;
            this.curUnseqFileIndex = 0;
        }
        this.unSeqTimeSeriesMetadata = new PriorityQueue<TimeseriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<ChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    SeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        this.dataSource = new QueryDataSource(seqFileResource, unseqFileResource);
        QueryUtils.fillOrderIndexes(this.dataSource, seriesPath.getDevice(), ascending);
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        this.fileFilter = null;
        if (ascending) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = new PriorityMergeReader();
            this.curSeqFileIndex = 0;
            this.curUnseqFileIndex = 0;
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = new DescPriorityMergeReader();
            this.curSeqFileIndex = this.dataSource.getSeqResourcesSize() - 1;
            this.curUnseqFileIndex = 0;
        }
        this.unSeqTimeSeriesMetadata = new PriorityQueue<TimeseriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<ChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    public boolean isEmpty() throws IOException {
        return !this.hasNextPage() && !this.hasNextChunk() && !this.hasNextFile();
    }

    boolean hasNextFile() throws IOException {
        QueryTimeManager.checkQueryAlive(this.context.getQueryId());
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IOException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return true;
        }
        this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
        return this.firstTimeSeriesMetadata != null;
    }

    boolean isFileOverlapped() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics()) || !this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
    }

    Statistics currentFileStatistics() {
        return this.firstTimeSeriesMetadata.getStatistics();
    }

    boolean currentFileModified() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        return this.firstTimeSeriesMetadata.isModified();
    }

    void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    boolean hasNextChunk() throws IOException {
        QueryTimeManager.checkQueryAlive(this.context.getQueryId());
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return true;
        }
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()), true);
        } else {
            while (!this.cachedChunkMetadata.isEmpty()) {
                this.firstChunkMetadata = this.cachedChunkMetadata.peek();
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()));
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), false);
                if (!this.firstChunkMetadata.equals((Object)this.cachedChunkMetadata.peek())) continue;
                this.firstChunkMetadata = this.cachedChunkMetadata.poll();
                break;
            }
        }
        return this.firstChunkMetadata != null;
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endpointTime, boolean init) throws IOException {
        while (!this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    private void unpackOneTimeSeriesMetadata(TimeseriesMetadata timeSeriesMetadata) throws IOException {
        List<ChunkMetadata> chunkMetadataList = FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata);
        chunkMetadataList.forEach(chunkMetadata -> chunkMetadata.setSeq(timeSeriesMetadata.isSeq()));
        if (IoTDBDescriptor.getInstance().getConfig().isEnablePerformanceTracing()) {
            long totalChunkPointsNum = chunkMetadataList.stream().mapToLong(chunkMetadata -> chunkMetadata.getStatistics().getCount()).sum();
            TracingManager.getInstance().getTracingInfo(this.context.getQueryId()).addChunkInfo(chunkMetadataList.size(), totalChunkPointsNum);
        }
        this.cachedChunkMetadata.addAll(chunkMetadataList);
    }

    boolean isChunkOverlapped() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)chunkStatistics, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics());
    }

    Statistics currentChunkStatistics() {
        return this.firstChunkMetadata.getStatistics();
    }

    boolean currentChunkModified() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        return this.firstChunkMetadata.isModified();
    }

    void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    boolean hasNextPage() throws IOException {
        QueryTimeManager.checkQueryAlive(this.context.getQueryId());
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if ((this.mergeReader.hasNextTimeValuePair() || this.firstPageOverlapped()) && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToPageReaders(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), true);
        } else {
            this.initFirstPageReader();
        }
        if (this.isExistOverlappedPage()) {
            return true;
        }
        while (!(this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
            if (!this.isExistOverlappedPage()) continue;
            return true;
        }
        return this.firstPageReader != null;
    }

    private boolean isExistOverlappedPage() throws IOException {
        if (this.firstPageOverlapped() && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        return false;
    }

    private boolean firstPageOverlapped() throws IOException {
        if (this.firstPageReader == null) {
            return false;
        }
        long endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
        this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
        this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
        return !this.seqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics()) || !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) || this.mergeReader.hasNextTimeValuePair() && this.orderUtils.isOverlapped(this.mergeReader.currentTimeValuePair().getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics());
    }

    private void unpackAllOverlappedChunkMetadataToPageReaders(long endpointTime, boolean init) throws IOException {
        if (this.firstChunkMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstChunkMetadata.getStatistics())) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        boolean hasMeetSeq = false;
        while (!(this.cachedChunkMetadata.isEmpty() || !this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics()) || this.cachedChunkMetadata.peek().isSeq() && hasMeetSeq)) {
            if (this.cachedChunkMetadata.peek().isSeq()) {
                hasMeetSeq = true;
            }
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (!(!init || this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
        }
    }

    private void unpackOneChunkMetaData(ChunkMetadata chunkMetaData) throws IOException {
        List<IPageReader> pageReaderList = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter);
        if (CONFIG.isEnablePerformanceTracing()) {
            this.addTotalPageNumInTracing(pageReaderList.size());
        }
        if (chunkMetaData.isSeq()) {
            if (this.orderUtils.getAscending()) {
                for (IPageReader iPageReader : pageReaderList) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), iPageReader, true));
                }
            } else {
                for (int i = pageReaderList.size() - 1; i >= 0; --i) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), pageReaderList.get(i), true));
                }
            }
        } else {
            pageReaderList.forEach(pageReader -> this.unSeqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), (IPageReader)pageReader, false)));
        }
    }

    private void addTotalPageNumInTracing(int pageNum) {
        TracingManager.getInstance().getTracingInfo(this.context.getQueryId()).addTotalPageNum(pageNum);
    }

    boolean isPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && (this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() <= this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() >= this.firstPageReader.getStatistics().getStartTime())) {
            throw new IOException("overlapped data should be consumed first");
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)firstPageStatistics, (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics());
    }

    Statistics currentPageStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics();
    }

    boolean currentPageModified() throws IOException {
        if (this.firstPageReader == null) {
            throw new IOException("no first page");
        }
        return this.firstPageReader.isModified();
    }

    void skipCurrentPage() {
        this.firstPageReader = null;
    }

    BatchData nextPage() throws IOException {
        if (!this.hasNextPage()) {
            throw new IOException("no next page, neither non-overlapped nor overlapped");
        }
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        if (this.valueFilter != null) {
            this.firstPageReader.setFilter(this.valueFilter);
        }
        BatchData batchData = this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending());
        this.firstPageReader = null;
        return batchData;
    }

    private boolean hasNextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        this.tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader();
        while (this.mergeReader.hasNextTimeValuePair()) {
            this.cachedBatchData = BatchDataFactory.createBatchData((TSDataType)this.dataType, (boolean)this.orderUtils.getAscending(), (boolean)true);
            long currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
            while (this.mergeReader.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.orderUtils.isExcessEndpoint(timeValuePair.getTimestamp(), currentPageEndPointTime)) {
                    if (this.cachedBatchData.hasCurrent() || this.firstPageReader != null || !this.seqPageReaders.isEmpty()) break;
                    currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
                }
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(timeValuePair.getTimestamp());
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedUnseqPageReadersToMergeReader(timeValuePair.getTimestamp());
                timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.firstPageReader != null) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.firstPageReader.getStatistics().getStartTime()) {
                        this.cachedBatchData.flip();
                        this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
                        return this.hasCachedNextOverlappedPage;
                    }
                    if (this.orderUtils.isOverlapped(timeValuePair.getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
                        this.mergeReader.addReader((IPointReader)this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), this.firstPageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics()), this.context);
                        currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, this.firstPageReader);
                        this.firstPageReader = null;
                    }
                }
                if (!this.seqPageReaders.isEmpty()) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.seqPageReaders.get(0).getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.seqPageReaders.get(0).getStatistics().getStartTime()) {
                        this.cachedBatchData.flip();
                        this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
                        return this.hasCachedNextOverlappedPage;
                    }
                    if (this.orderUtils.isOverlapped(timeValuePair.getTimestamp(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics())) {
                        VersionPageReader pageReader = this.seqPageReaders.remove(0);
                        this.mergeReader.addReader((IPointReader)pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()), this.context);
                        currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, pageReader);
                    }
                }
                timeValuePair = this.mergeReader.nextTimeValuePair();
                if (this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
                this.cachedBatchData.putAnObject(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
            }
            this.cachedBatchData.flip();
            this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
            if (this.hasCachedNextOverlappedPage) {
                return true;
            }
            if (!this.mergeReader.hasNextTimeValuePair()) continue;
            return false;
        }
        return false;
    }

    private long updateEndPointTime(long currentPageEndPointTime, VersionPageReader pageReader) {
        if (this.orderUtils.getAscending()) {
            return Math.min(currentPageEndPointTime, pageReader.getStatistics().getEndTime());
        }
        return Math.max(currentPageEndPointTime, pageReader.getStatistics().getStartTime());
    }

    private void tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.unSeqPageReaders.isEmpty() && this.seqPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.initFirstPageReader();
        }
        long currentPageEndpointTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentReadStopTime() : this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedUnseqPageReadersToMergeReader(currentPageEndpointTime);
    }

    private void initFirstPageReader() throws IOException {
        while (this.firstPageReader == null) {
            VersionPageReader firstPageReader = this.getFirstPageReaderFromCachedReaders();
            if (firstPageReader != null) {
                long overlapCheckTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(overlapCheckTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(overlapCheckTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(overlapCheckTime, false);
                if (!firstPageReader.equals(this.getFirstPageReaderFromCachedReaders())) continue;
                this.firstPageReader = firstPageReader;
                if (!this.seqPageReaders.isEmpty() && firstPageReader.equals(this.seqPageReaders.get(0))) {
                    this.seqPageReaders.remove(0);
                    break;
                }
                if (this.unSeqPageReaders.isEmpty() || !firstPageReader.equals(this.unSeqPageReaders.peek())) continue;
                this.unSeqPageReaders.poll();
                break;
            }
            return;
        }
    }

    private VersionPageReader getFirstPageReaderFromCachedReaders() {
        VersionPageReader firstPageReader = null;
        if (!this.seqPageReaders.isEmpty() && !this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) ? this.seqPageReaders.get(0) : this.unSeqPageReaders.peek();
        } else if (!this.seqPageReaders.isEmpty()) {
            firstPageReader = this.seqPageReaders.get(0);
        } else if (!this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.unSeqPageReaders.peek();
        }
        return firstPageReader;
    }

    private void unpackAllOverlappedUnseqPageReadersToMergeReader(long endpointTime) throws IOException {
        while (!this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqPageReaders.peek().data.getStatistics())) {
            this.putPageReaderToMergeReader(this.unSeqPageReaders.poll());
        }
        if (this.firstPageReader != null && !this.firstPageReader.isSeq() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader((IPointReader)pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()), this.context);
    }

    private BatchData nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        throw new IOException("No more batch data");
    }

    private LinkedList<TsFileResource> sortUnSeqFileResources(List<TsFileResource> tsFileResources) {
        return tsFileResources.stream().sorted(this.orderUtils.comparingLong(tsFileResource -> this.orderUtils.getOrderTime((TsFileResource)tsFileResource))).collect(Collectors.toCollection(LinkedList::new));
    }

    private void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextSeqResource()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextUnseqResource()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextUnseqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics());
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getCurrentEndPoint((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics()) ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
    }

    private void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endpointTime) throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (this.orderUtils.hasNextUnseqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextUnseqFileResource(false))) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextUnseqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (this.orderUtils.hasNextSeqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextSeqFileResource(false))) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    private Filter getAnyFilter() {
        return this.timeFilter != null ? this.timeFilter : this.valueFilter;
    }

    void setTimeFilter(long timestamp) {
        ((UnaryFilter)this.timeFilter).setValue((Comparable)Long.valueOf(timestamp));
    }

    Filter getTimeFilter() {
        return this.timeFilter;
    }

    public TimeOrderUtils getOrderUtils() {
        return this.orderUtils;
    }

    public Filter getValueFilter() {
        return this.valueFilter;
    }

    class AscTimeOrderUtils
    implements TimeOrderUtils {
        AscTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getStartTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getStartTime(SeriesReader.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getEndTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getEndTime() >= right.getStartTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time >= right.getStartTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time >= right.getStartTime(SeriesReader.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.min(time, statistics.getEndTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.min(seqStatistics.getEndTime(), unseqStatistics.getEndTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time > endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getStartTime() < unseqStatistics.getStartTime();
        }

        @Override
        public boolean getAscending() {
            return true;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesReader.this.dataSource.hasNextSeqResource(SeriesReader.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesReader.this.dataSource.getSeqResourceByIndex(SeriesReader.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesReader.this.seriesPath.getDevice(), SeriesReader.this.timeFilter, SeriesReader.this.fileFilter, true, SeriesReader.this.context.isDebug()))) {
                SeriesReader.this.curSeqFileIndex++;
            }
            return SeriesReader.this.dataSource.hasNextSeqResource(SeriesReader.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesReader.this.dataSource.hasNextUnseqResource(SeriesReader.this.curUnseqFileIndex) && ((tsFileResource = SeriesReader.this.dataSource.getUnseqResourceByIndex(SeriesReader.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesReader.this.seriesPath.getDevice(), SeriesReader.this.timeFilter, SeriesReader.this.fileFilter, false, SeriesReader.this.context.isDebug()))) {
                SeriesReader.this.curUnseqFileIndex++;
            }
            return SeriesReader.this.dataSource.hasNextUnseqResource(SeriesReader.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesReader.this.dataSource.getSeqResourceByIndex(SeriesReader.this.curSeqFileIndex);
            if (isDelete) {
                SeriesReader.this.curSeqFileIndex++;
                if (CONFIG.isEnablePerformanceTracing()) {
                    TracingManager.getInstance().getTracingInfo(SeriesReader.this.context.getQueryId()).addTsFile(tsFileResource, true);
                }
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesReader.this.dataSource.getUnseqResourceByIndex(SeriesReader.this.curUnseqFileIndex);
            if (isDelete) {
                SeriesReader.this.curUnseqFileIndex++;
                if (CONFIG.isEnablePerformanceTracing()) {
                    TracingManager.getInstance().getTracingInfo(SeriesReader.this.context.getQueryId()).addTsFile(tsFileResource, false);
                }
            }
            return tsFileResource;
        }
    }

    class DescTimeOrderUtils
    implements TimeOrderUtils {
        DescTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getEndTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getEndTime(SeriesReader.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getStartTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getStartTime() <= right.getEndTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time <= right.getEndTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time <= right.getEndTime(SeriesReader.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c2), keyExtractor.applyAsLong(c1));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.max(time, statistics.getStartTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.max(seqStatistics.getStartTime(), unseqStatistics.getStartTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time < endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getEndTime() > unseqStatistics.getEndTime();
        }

        @Override
        public boolean getAscending() {
            return false;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesReader.this.dataSource.hasNextSeqResource(SeriesReader.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesReader.this.dataSource.getSeqResourceByIndex(SeriesReader.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesReader.this.seriesPath.getDevice(), SeriesReader.this.timeFilter, SeriesReader.this.fileFilter, true, SeriesReader.this.context.isDebug()))) {
                SeriesReader.this.curSeqFileIndex--;
            }
            return SeriesReader.this.dataSource.hasNextSeqResource(SeriesReader.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesReader.this.dataSource.hasNextUnseqResource(SeriesReader.this.curUnseqFileIndex) && ((tsFileResource = SeriesReader.this.dataSource.getUnseqResourceByIndex(SeriesReader.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesReader.this.seriesPath.getDevice(), SeriesReader.this.timeFilter, SeriesReader.this.fileFilter, false, SeriesReader.this.context.isDebug()))) {
                SeriesReader.this.curUnseqFileIndex++;
            }
            return SeriesReader.this.dataSource.hasNextUnseqResource(SeriesReader.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesReader.this.dataSource.getSeqResourceByIndex(SeriesReader.this.curSeqFileIndex);
            if (isDelete) {
                SeriesReader.this.curSeqFileIndex--;
                if (CONFIG.isEnablePerformanceTracing()) {
                    TracingManager.getInstance().getTracingInfo(SeriesReader.this.context.getQueryId()).addTsFile(tsFileResource, true);
                }
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesReader.this.dataSource.getUnseqResourceByIndex(SeriesReader.this.curUnseqFileIndex);
            if (isDelete) {
                SeriesReader.this.curUnseqFileIndex++;
                if (CONFIG.isEnablePerformanceTracing()) {
                    TracingManager.getInstance().getTracingInfo(SeriesReader.this.context.getQueryId()).addTsFile(tsFileResource, false);
                }
            }
            return tsFileResource;
        }
    }

    public static interface TimeOrderUtils {
        public long getOrderTime(Statistics<? extends Object> var1);

        public long getOrderTime(TsFileResource var1);

        public long getOverlapCheckTime(Statistics<? extends Object> var1);

        public boolean isOverlapped(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isOverlapped(long var1, Statistics<? extends Object> var3);

        public boolean isOverlapped(long var1, TsFileResource var3);

        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> var1);

        public long getCurrentEndPoint(long var1, Statistics<? extends Object> var3);

        public long getCurrentEndPoint(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isExcessEndpoint(long var1, long var3);

        public boolean isTakeSeqAsFirst(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean getAscending();

        public boolean hasNextSeqResource();

        public boolean hasNextUnseqResource();

        public TsFileResource getNextSeqFileResource(boolean var1);

        public TsFileResource getNextUnseqFileResource(boolean var1);
    }

    private class VersionPageReader {
        protected PriorityMergeReader.MergeReaderPriority version;
        protected IPageReader data;
        protected boolean isSeq;

        VersionPageReader(long version, long offset, IPageReader data, boolean isSeq) {
            this.version = new PriorityMergeReader.MergeReaderPriority(version, offset);
            this.data = data;
            this.isSeq = isSeq;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
            return this.data.getAllSatisfiedPageData(ascending);
        }

        void setFilter(Filter filter) {
            this.data.setFilter(filter);
        }

        boolean isModified() {
            return this.data.isModified();
        }

        public boolean isSeq() {
            return this.isSeq;
        }
    }
}

