/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.pool;

import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.pool.AbstractPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawQueryReadTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawQueryReadTaskPoolManager.class);

    private RawQueryReadTaskPoolManager() {
        int threadCnt = IoTDBDescriptor.getInstance().getConfig().getConcurrentSubRawQueryThread();
        this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.SUB_RAW_QUERY_SERVICE.getName());
    }

    public static RawQueryReadTaskPoolManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "raw query read task";
    }

    @Override
    public void start() {
        if (this.pool == null) {
            int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), IoTDBDescriptor.getInstance().getConfig().getConcurrentSubRawQueryThread());
            this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.SUB_RAW_QUERY_SERVICE.getName());
        }
    }

    @Override
    public void stop() {
        if (this.pool != null) {
            this.close();
            this.pool = null;
        }
    }

    private static class InstanceHolder {
        private static RawQueryReadTaskPoolManager instance = new RawQueryReadTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

