/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.dataset.DirectAlignByTimeDataSet;
import org.apache.iotdb.db.query.pool.RawQueryReadTaskPoolManager;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.ExceptionBatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.common.SignalBatchData;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawQueryDataSetWithoutValueFilter
extends QueryDataSet
implements DirectAlignByTimeDataSet {
    protected List<ManagedSeriesReader> seriesReaderList;
    protected TimeSelector timeHeap;
    protected final BlockingQueue<BatchData>[] blockingQueueArray;
    protected boolean[] noMoreDataInQueueArray;
    protected BatchData[] cachedBatchDataArray;
    protected int[] batchDataLengthList;
    private static final int BLOCKING_QUEUE_CAPACITY = IoTDBDescriptor.getInstance().getConfig().getRawQueryBlockingQueueCapacity();
    private final long queryId;
    protected final int originalRowOffset;
    private static final RawQueryReadTaskPoolManager TASK_POOL_MANAGER = RawQueryReadTaskPoolManager.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(RawQueryDataSetWithoutValueFilter.class);

    public RawQueryDataSetWithoutValueFilter(long queryId, RawDataQueryPlan queryPlan, List<ManagedSeriesReader> readers) throws IOException, InterruptedException {
        super(new ArrayList<PartialPath>(queryPlan.getDeduplicatedPaths()), queryPlan.getDeduplicatedDataTypes(), queryPlan.isAscending());
        this.rowLimit = queryPlan.getRowLimit();
        this.originalRowOffset = queryPlan.getRowOffset();
        this.rowOffset = queryPlan.getRowOffset();
        this.withoutAnyNull = queryPlan.isWithoutAnyNull();
        this.withoutAllNull = queryPlan.isWithoutAllNull();
        if (this.rowLimit != 0 && !this.withoutAllNull && !this.withoutAnyNull) {
            this.batchDataLengthList = new int[readers.size()];
        }
        this.queryId = queryId;
        this.seriesReaderList = readers;
        this.blockingQueueArray = new BlockingQueue[readers.size()];
        for (int i = 0; i < this.seriesReaderList.size(); ++i) {
            this.blockingQueueArray[i] = new LinkedBlockingQueue<BatchData>(BLOCKING_QUEUE_CAPACITY);
        }
        this.cachedBatchDataArray = new BatchData[readers.size()];
        this.noMoreDataInQueueArray = new boolean[readers.size()];
        this.init();
    }

    public RawQueryDataSetWithoutValueFilter(long queryId) {
        this.queryId = queryId;
        this.originalRowOffset = 0;
        this.blockingQueueArray = new BlockingQueue[0];
        this.timeHeap = new TimeSelector(0, this.ascending);
    }

    private void init() throws IOException, InterruptedException {
        int i;
        this.timeHeap = new TimeSelector(this.seriesReaderList.size() << 1, this.ascending);
        for (i = 0; i < this.seriesReaderList.size(); ++i) {
            ManagedSeriesReader reader = this.seriesReaderList.get(i);
            reader.setHasRemaining(true);
            reader.setManagedByQueryManager(true);
            TASK_POOL_MANAGER.submit(this.generateReadTaskForGivenReader(reader, i));
        }
        for (i = 0; i < this.seriesReaderList.size(); ++i) {
            QueryTimeManager.checkQueryAlive(this.queryId);
            this.fillCache(i);
            if (this.cachedBatchDataArray[i] == null || !this.cachedBatchDataArray[i].hasCurrent()) continue;
            long time = this.cachedBatchDataArray[i].currentTime();
            this.timeHeap.add(time);
        }
    }

    protected ReadTask generateReadTaskForGivenReader(ManagedSeriesReader reader, int seriesIndex) {
        return new ReadTask(reader, this.blockingQueueArray[seriesIndex], ((Path)this.paths.get(seriesIndex)).getFullPath(), this.batchDataLengthList, seriesIndex, this.rowLimit + this.originalRowOffset);
    }

    @Override
    public TSQueryDataSet fillBuffer(int fetchSize, WatermarkEncoder encoder) throws IOException, InterruptedException {
        int remaining;
        int seriesNum = this.seriesReaderList.size();
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        PublicBAOS timeBAOS = new PublicBAOS();
        PublicBAOS[] valueBAOSList = new PublicBAOS[seriesNum];
        PublicBAOS[] bitmapBAOSList = new PublicBAOS[seriesNum];
        for (int seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
            valueBAOSList[seriesIndex] = new PublicBAOS();
            bitmapBAOSList[seriesIndex] = new PublicBAOS();
        }
        int[] currentBitmapList = new int[seriesNum];
        int rowCount = 0;
        while (!(rowCount >= fetchSize || this.rowLimit > 0 && this.alreadyReturnedRowNum >= this.rowLimit || this.timeHeap.isEmpty())) {
            int seriesIndex;
            long minTime = this.timeHeap.pollFirst();
            if (this.withoutAnyNull && this.filterRowRecord(seriesNum, minTime)) continue;
            if (this.rowOffset == 0) {
                timeBAOS.write(BytesUtils.longToBytes((long)minTime));
            }
            for (seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
                if (this.cachedBatchDataArray[seriesIndex] == null || !this.cachedBatchDataArray[seriesIndex].hasCurrent() || this.cachedBatchDataArray[seriesIndex].currentTime() != minTime) {
                    if (this.rowOffset != 0) continue;
                    currentBitmapList[seriesIndex] = currentBitmapList[seriesIndex] << 1;
                    continue;
                }
                if (this.rowOffset == 0) {
                    currentBitmapList[seriesIndex] = currentBitmapList[seriesIndex] << 1 | 1;
                    TSDataType type = this.cachedBatchDataArray[seriesIndex].getDataType();
                    switch (type) {
                        case INT32: {
                            int intValue = this.cachedBatchDataArray[seriesIndex].getInt();
                            if (encoder != null && encoder.needEncode(minTime)) {
                                intValue = encoder.encodeInt(intValue, minTime);
                            }
                            ReadWriteIOUtils.write((int)intValue, (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        case INT64: {
                            long longValue = this.cachedBatchDataArray[seriesIndex].getLong();
                            if (encoder != null && encoder.needEncode(minTime)) {
                                longValue = encoder.encodeLong(longValue, minTime);
                            }
                            ReadWriteIOUtils.write((long)longValue, (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        case FLOAT: {
                            float floatValue = this.cachedBatchDataArray[seriesIndex].getFloat();
                            if (encoder != null && encoder.needEncode(minTime)) {
                                floatValue = encoder.encodeFloat(floatValue, minTime);
                            }
                            ReadWriteIOUtils.write((float)floatValue, (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        case DOUBLE: {
                            double doubleValue = this.cachedBatchDataArray[seriesIndex].getDouble();
                            if (encoder != null && encoder.needEncode(minTime)) {
                                doubleValue = encoder.encodeDouble(doubleValue, minTime);
                            }
                            ReadWriteIOUtils.write((double)doubleValue, (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        case BOOLEAN: {
                            ReadWriteIOUtils.write((Boolean)this.cachedBatchDataArray[seriesIndex].getBoolean(), (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        case TEXT: {
                            ReadWriteIOUtils.write((Binary)this.cachedBatchDataArray[seriesIndex].getBinary(), (OutputStream)valueBAOSList[seriesIndex]);
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                        }
                    }
                }
                this.prepareForNext(seriesIndex);
            }
            if (this.rowOffset == 0) {
                if (++rowCount % 8 == 0) {
                    for (seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
                        ReadWriteIOUtils.write((byte)((byte)currentBitmapList[seriesIndex]), (OutputStream)bitmapBAOSList[seriesIndex]);
                        currentBitmapList[seriesIndex] = 0;
                    }
                }
                if (this.rowLimit <= 0) continue;
                ++this.alreadyReturnedRowNum;
                continue;
            }
            --this.rowOffset;
        }
        if (rowCount > 0 && (remaining = rowCount % 8) != 0) {
            for (int seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
                ReadWriteIOUtils.write((byte)((byte)(currentBitmapList[seriesIndex] << 8 - remaining)), (OutputStream)bitmapBAOSList[seriesIndex]);
            }
        }
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeBAOS.size());
        timeBuffer.put(timeBAOS.getBuf(), 0, timeBAOS.size());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        ArrayList<ByteBuffer> valueBufferList = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> bitmapBufferList = new ArrayList<ByteBuffer>();
        for (int seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
            this.putPBOSToBuffer(valueBAOSList, valueBufferList, seriesIndex);
            this.putPBOSToBuffer(bitmapBAOSList, bitmapBufferList, seriesIndex);
        }
        tsQueryDataSet.setValueList(valueBufferList);
        tsQueryDataSet.setBitmapList(bitmapBufferList);
        return tsQueryDataSet;
    }

    private boolean filterRowRecord(int seriesNum, long minTime) throws IOException, InterruptedException {
        int seriesIndex;
        boolean hasNull = false;
        for (seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
            if (this.cachedBatchDataArray[seriesIndex] != null && this.cachedBatchDataArray[seriesIndex].hasCurrent() && this.cachedBatchDataArray[seriesIndex].currentTime() == minTime) continue;
            hasNull = true;
            break;
        }
        if (hasNull) {
            for (seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
                if (this.cachedBatchDataArray[seriesIndex] == null || !this.cachedBatchDataArray[seriesIndex].hasCurrent() || this.cachedBatchDataArray[seriesIndex].currentTime() != minTime) continue;
                this.prepareForNext(seriesIndex);
            }
            return true;
        }
        return false;
    }

    private void prepareForNext(int seriesIndex) throws IOException, InterruptedException {
        this.cachedBatchDataArray[seriesIndex].next();
        QueryTimeManager.checkQueryAlive(this.queryId);
        if (!this.cachedBatchDataArray[seriesIndex].hasCurrent() && !this.noMoreDataInQueueArray[seriesIndex]) {
            this.fillCache(seriesIndex);
        }
        if (this.cachedBatchDataArray[seriesIndex].hasCurrent()) {
            this.timeHeap.add(this.cachedBatchDataArray[seriesIndex].currentTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillCache(int seriesIndex) throws IOException, InterruptedException {
        BatchData batchData = this.blockingQueueArray[seriesIndex].take();
        if (batchData instanceof SignalBatchData) {
            this.noMoreDataInQueueArray[seriesIndex] = true;
        } else {
            if (batchData instanceof ExceptionBatchData) {
                ExceptionBatchData exceptionBatchData = (ExceptionBatchData)batchData;
                LOGGER.error("exception happened in producer thread", exceptionBatchData.getThrowable());
                if (exceptionBatchData.getThrowable() instanceof IOException) {
                    throw (IOException)exceptionBatchData.getThrowable();
                }
                if (exceptionBatchData.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)exceptionBatchData.getThrowable();
                }
                throw new RuntimeException("some other unknown errors!");
            }
            this.cachedBatchDataArray[seriesIndex] = batchData;
            ManagedSeriesReader managedSeriesReader = this.seriesReaderList.get(seriesIndex);
            synchronized (managedSeriesReader) {
                ManagedSeriesReader reader;
                if (this.blockingQueueArray[seriesIndex].remainingCapacity() > 0 && !(reader = this.seriesReaderList.get(seriesIndex)).isManagedByQueryManager() && reader.hasRemaining()) {
                    reader.setManagedByQueryManager(true);
                    TASK_POOL_MANAGER.submit(this.generateReadTaskForGivenReader(reader, seriesIndex));
                }
            }
        }
    }

    private void putPBOSToBuffer(PublicBAOS[] bitmapBAOSList, List<ByteBuffer> bitmapBufferList, int tsIndex) {
        ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapBAOSList[tsIndex].size());
        bitmapBuffer.put(bitmapBAOSList[tsIndex].getBuf(), 0, bitmapBAOSList[tsIndex].size());
        bitmapBuffer.flip();
        bitmapBufferList.add(bitmapBuffer);
    }

    public boolean hasNextWithoutConstraint() {
        return !this.timeHeap.isEmpty();
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        long minTime = this.timeHeap.pollFirst();
        RowRecord record = new RowRecord(minTime);
        int seriesNumber = this.seriesReaderList.size();
        for (int seriesIndex = 0; seriesIndex < seriesNumber; ++seriesIndex) {
            if (this.cachedBatchDataArray[seriesIndex] == null || !this.cachedBatchDataArray[seriesIndex].hasCurrent() || this.cachedBatchDataArray[seriesIndex].currentTime() != minTime) {
                record.addField(null);
                continue;
            }
            TSDataType dataType = (TSDataType)this.dataTypes.get(seriesIndex);
            record.addField(this.cachedBatchDataArray[seriesIndex].currentValue(), dataType);
            this.cacheNext(seriesIndex);
        }
        return record;
    }

    protected void cacheNext(int seriesIndex) throws IOException {
        this.cachedBatchDataArray[seriesIndex].next();
        QueryTimeManager.checkQueryAlive(this.queryId);
        if (!this.cachedBatchDataArray[seriesIndex].hasCurrent() && !this.noMoreDataInQueueArray[seriesIndex]) {
            try {
                this.fillCache(seriesIndex);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while taking from the blocking queue: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOGGER.error("Got IOException", (Throwable)e);
                throw e;
            }
        }
        if (this.cachedBatchDataArray[seriesIndex].hasCurrent()) {
            this.timeHeap.add(this.cachedBatchDataArray[seriesIndex].currentTime());
        }
    }

    protected class ReadTask
    extends WrappedRunnable {
        private final ManagedSeriesReader reader;
        private final String pathName;
        private final BlockingQueue<BatchData> blockingQueue;
        private int[] batchDataLengthList;
        private final int seriesIndex;
        private final int fetchLimit;

        public ReadTask(ManagedSeriesReader reader, BlockingQueue<BatchData> blockingQueue, String pathName, int[] batchDataLengthList, int seriesIndex, int fetchLimit) {
            this.reader = reader;
            this.blockingQueue = blockingQueue;
            this.pathName = pathName;
            this.batchDataLengthList = batchDataLengthList;
            this.seriesIndex = seriesIndex;
            this.fetchLimit = fetchLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runMayThrow() {
            try {
                QueryTimeManager.checkQueryAlive(RawQueryDataSetWithoutValueFilter.this.queryId);
                ManagedSeriesReader managedSeriesReader = this.reader;
                synchronized (managedSeriesReader) {
                    while (this.reader.hasNextBatch()) {
                        BatchData batchData = this.reader.nextBatch();
                        if (batchData.isEmpty()) continue;
                        this.blockingQueue.put(batchData);
                        if (this.batchDataLengthList != null) {
                            int n = this.seriesIndex;
                            this.batchDataLengthList[n] = this.batchDataLengthList[n] + batchData.length();
                            if (this.batchDataLengthList[this.seriesIndex] >= this.fetchLimit) {
                                if (this.blockingQueue.remainingCapacity() > 0) break;
                                this.reader.setManagedByQueryManager(false);
                                return;
                            }
                        }
                        if (this.blockingQueue.remainingCapacity() > 0) {
                            TASK_POOL_MANAGER.submit(this);
                        } else {
                            this.reader.setManagedByQueryManager(false);
                        }
                        return;
                    }
                    this.blockingQueue.put((BatchData)SignalBatchData.getInstance());
                    this.reader.setHasRemaining(false);
                    this.reader.setManagedByQueryManager(false);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while putting into the blocking queue: ", (Throwable)e);
                Thread.currentThread().interrupt();
                this.reader.setHasRemaining(false);
            }
            catch (IOException e) {
                this.putExceptionBatchData(e, String.format("Something gets wrong while reading from the series reader %s: ", this.pathName));
            }
            catch (Throwable e) {
                this.putExceptionBatchData(e, "Something gets wrong: ");
            }
        }

        private void putExceptionBatchData(Throwable e, String logMessage) {
            try {
                LOGGER.warn(logMessage, e);
                this.reader.setHasRemaining(false);
                this.blockingQueue.put((BatchData)new ExceptionBatchData(e));
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Interrupted while putting ExceptionBatchData into the blocking queue: ", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }
    }
}

