/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;

public class RawDataQueryPlan
extends QueryPlan {
    private List<PartialPath> deduplicatedPaths = new ArrayList<PartialPath>();
    private List<TSDataType> deduplicatedDataTypes = new ArrayList<TSDataType>();
    private IExpression expression = null;
    private Map<String, Set<String>> deviceToMeasurements = new HashMap<String, Set<String>>();

    public RawDataQueryPlan() {
    }

    public RawDataQueryPlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression expression) throws QueryProcessException {
        this.setExpressionAndUpdateDeviceMeasurements(expression, true);
    }

    public void setExpressionAndUpdateDeviceMeasurements(IExpression expression, boolean update) {
        this.expression = expression;
        if (update) {
            this.updateDeviceMeasurementsUsingExpression(expression);
        }
    }

    public void updateDeviceMeasurementsUsingExpression(IExpression expression) {
        if (expression instanceof SingleSeriesExpression) {
            Path path = ((SingleSeriesExpression)expression).getSeriesPath();
            this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        } else if (expression instanceof IBinaryExpression) {
            this.updateDeviceMeasurementsUsingExpression(((IBinaryExpression)expression).getLeft());
            this.updateDeviceMeasurementsUsingExpression(((IBinaryExpression)expression).getRight());
        }
    }

    public List<PartialPath> getDeduplicatedPaths() {
        return this.deduplicatedPaths;
    }

    public void addDeduplicatedPaths(PartialPath path) {
        this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        this.deduplicatedPaths.add(path);
    }

    public void setDeduplicatedPaths(List<PartialPath> deduplicatedPaths) {
        this.deviceToMeasurements.clear();
        deduplicatedPaths.forEach(path -> this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement()));
        this.deduplicatedPaths = deduplicatedPaths;
    }

    public List<TSDataType> getDeduplicatedDataTypes() {
        return this.deduplicatedDataTypes;
    }

    public void addDeduplicatedDataTypes(TSDataType dataType) {
        this.deduplicatedDataTypes.add(dataType);
    }

    public void setDeduplicatedDataTypes(List<TSDataType> deduplicatedDataTypes) {
        this.deduplicatedDataTypes = deduplicatedDataTypes;
    }

    public Set<String> getAllMeasurementsInDevice(String device) {
        return this.deviceToMeasurements.getOrDefault(device, Collections.emptySet());
    }

    public void addFilterPathInDeviceToMeasurements(Path path) {
        this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
    }

    public Map<String, Set<String>> getDeviceToMeasurements() {
        return this.deviceToMeasurements;
    }
}

