/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.rpc.TSStatusCode;

public class StorageGroupAlreadySetException
extends MetadataException {
    private static final long serialVersionUID = 9110669164701929779L;
    private boolean hasChild = false;

    public StorageGroupAlreadySetException(String path) {
        super(StorageGroupAlreadySetException.getMessage(path, false), TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode());
    }

    public StorageGroupAlreadySetException(String path, boolean hasChild) {
        super(StorageGroupAlreadySetException.getMessage(path, hasChild), TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode());
        this.hasChild = hasChild;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    private static String getMessage(String path, boolean hasChild) {
        if (hasChild) {
            return String.format("some children of %s have already been set to storage group", path);
        }
        return String.format("%s has already been set to storage group", path);
    }
}

