/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.engine.merge.manage.MergeContext;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.MergeFileTask;
import org.apache.iotdb.db.engine.merge.task.MergeMultiChunkTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.MergeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask
implements Callable<Void> {
    public static final String MERGE_SUFFIX = ".merge";
    private static final Logger logger = LoggerFactory.getLogger(MergeTask.class);
    MergeResource resource;
    String storageGroupSysDir;
    String storageGroupName;
    MergeLogger mergeLogger;
    MergeContext mergeContext = new MergeContext();
    int concurrentMergeSeriesNum;
    String taskName;
    boolean fullMerge;
    States states = States.START;
    MergeMultiChunkTask chunkTask;
    MergeFileTask fileTask;
    private MergeCallback callback;

    MergeTask(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName) {
        this.resource = new MergeResource(seqFiles, unseqFiles);
        this.storageGroupSysDir = storageGroupSysDir;
        this.callback = callback;
        this.taskName = taskName;
        this.fullMerge = fullMerge;
        this.concurrentMergeSeriesNum = 1;
        this.storageGroupName = storageGroupName;
    }

    public MergeTask(MergeResource mergeResource, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, int concurrentMergeSeriesNum, String storageGroupName) {
        this.resource = mergeResource;
        this.storageGroupSysDir = storageGroupSysDir;
        this.callback = callback;
        this.taskName = taskName;
        this.fullMerge = fullMerge;
        this.concurrentMergeSeriesNum = concurrentMergeSeriesNum;
        this.storageGroupName = storageGroupName;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.doMerge();
        }
        catch (Throwable e) {
            logger.error("Runtime exception in merge {}", (Object)this.taskName, (Object)e);
            this.abort();
        }
        return null;
    }

    private void abort() throws IOException {
        this.states = States.ABORTED;
        this.cleanUp(false);
        for (TsFileResource resource : this.resource.getSeqFiles()) {
            resource.setMerging(false);
        }
        for (TsFileResource resource : this.resource.getUnseqFiles()) {
            resource.setMerging(false);
        }
        this.callback.call(Collections.emptyList(), Collections.emptyList(), new File(this.storageGroupSysDir, "merge.log"));
    }

    private void doMerge() throws IOException, MetadataException {
        if (this.resource.getSeqFiles().isEmpty()) {
            logger.info("{} no sequence file to merge into, so will abort task.", (Object)this.taskName);
            this.abort();
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} starts to merge seqFiles: {}, unseqFiles: {}", new Object[]{this.taskName, this.resource.getSeqFiles(), this.resource.getUnseqFiles()});
        }
        long startTime = System.currentTimeMillis();
        long totalFileSize = MergeUtils.collectFileSizes(this.resource.getSeqFiles(), this.resource.getUnseqFiles());
        this.mergeLogger = new MergeLogger(this.storageGroupSysDir);
        this.mergeLogger.logFiles(this.resource);
        Set<PartialPath> devices = IoTDB.metaManager.getDevices(new PartialPath(this.storageGroupName));
        ArrayList<PartialPath> unmergedSeries = new ArrayList<PartialPath>();
        for (PartialPath device : devices) {
            MNode deviceNode = IoTDB.metaManager.getNodeByPath(device);
            for (Map.Entry<String, MNode> entry : deviceNode.getChildren().entrySet()) {
                if (!(entry.getValue() instanceof MeasurementMNode)) continue;
                PartialPath path = device.concatNode(entry.getKey());
                unmergedSeries.add(path);
            }
        }
        this.chunkTask = new MergeMultiChunkTask(this.mergeContext, this.taskName, this.mergeLogger, this.resource, this.fullMerge, unmergedSeries, this.concurrentMergeSeriesNum, this.storageGroupName);
        this.states = States.MERGE_CHUNKS;
        this.chunkTask.mergeSeries();
        if (Thread.interrupted()) {
            logger.info("Merge task {} aborted", (Object)this.taskName);
            this.abort();
            return;
        }
        this.fileTask = new MergeFileTask(this.taskName, this.mergeContext, this.mergeLogger, this.resource, this.resource.getSeqFiles());
        this.states = States.MERGE_FILES;
        this.chunkTask = null;
        this.fileTask.mergeFiles();
        if (Thread.interrupted()) {
            logger.info("Merge task {} aborted", (Object)this.taskName);
            this.abort();
            return;
        }
        this.states = States.CLEAN_UP;
        this.fileTask = null;
        this.cleanUp(true);
        if (logger.isInfoEnabled()) {
            double elapsedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            double byteRate = (double)totalFileSize / elapsedTime / 1024.0 / 1024.0;
            double seriesRate = (double)unmergedSeries.size() / elapsedTime;
            double chunkRate = (double)this.mergeContext.getTotalChunkWritten() / elapsedTime;
            double fileRate = (double)(this.resource.getSeqFiles().size() + this.resource.getUnseqFiles().size()) / elapsedTime;
            double ptRate = (double)this.mergeContext.getTotalPointWritten() / elapsedTime;
            logger.info("{} ends after {}s, byteRate: {}MB/s, seriesRate {}/s, chunkRate: {}/s, fileRate: {}/s, ptRate: {}/s", new Object[]{this.taskName, elapsedTime, byteRate, seriesRate, chunkRate, fileRate, ptRate});
        }
    }

    void cleanUp(boolean executeCallback) throws IOException {
        logger.info("{} is cleaning up", (Object)this.taskName);
        this.resource.clear();
        this.mergeContext.clear();
        if (this.mergeLogger != null) {
            this.mergeLogger.close();
        }
        for (TsFileResource seqFile : this.resource.getSeqFiles()) {
            File mergeFile = new File(seqFile.getTsFilePath() + MERGE_SUFFIX);
            mergeFile.delete();
            seqFile.setMerging(false);
        }
        for (TsFileResource unseqFile : this.resource.getUnseqFiles()) {
            unseqFile.setMerging(false);
        }
        File logFile = new File(this.storageGroupSysDir, "merge.log");
        if (executeCallback) {
            this.callback.call(this.resource.getSeqFiles(), this.resource.getUnseqFiles(), logFile);
        } else {
            logFile.delete();
        }
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public String getProgress() {
        switch (this.states) {
            case ABORTED: {
                return "Aborted";
            }
            case CLEAN_UP: {
                return "Cleaning up";
            }
            case MERGE_FILES: {
                return "Merging files: " + this.fileTask.getProgress();
            }
            case MERGE_CHUNKS: {
                return "Merging series: " + this.chunkTask.getProgress();
            }
        }
        return "Just started";
    }

    public String getTaskName() {
        return this.taskName;
    }

    static enum States {
        START,
        MERGE_CHUNKS,
        MERGE_FILES,
        CLEAN_UP,
        ABORTED;

    }
}

