/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.recover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeFileInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class MergeLogger {
    public static final String MERGE_LOG_NAME = "merge.log";
    static final String STR_SEQ_FILES = "seqFiles";
    static final String STR_UNSEQ_FILES = "unseqFiles";
    private BufferedWriter logStream;

    public MergeLogger(String storageGroupDir) throws IOException {
        this.logStream = new BufferedWriter(new FileWriter(new File(storageGroupDir, MERGE_LOG_NAME), true));
    }

    public void close() throws IOException {
        this.logStream.close();
    }

    public void logFiles(MergeResource resource) throws IOException {
        this.logSeqFiles(resource.getSeqFiles());
        this.logUnseqFiles(resource.getUnseqFiles());
        this.logStream.flush();
    }

    private void logSeqFiles(List<TsFileResource> seqFiles) throws IOException {
        this.logStream.write(STR_SEQ_FILES);
        this.logStream.newLine();
        for (TsFileResource tsFileResource : seqFiles) {
            this.logStream.write(MergeFileInfo.getFileInfoFromFile(tsFileResource.getTsFile()).toString());
            this.logStream.newLine();
        }
        this.logStream.flush();
    }

    private void logUnseqFiles(List<TsFileResource> unseqFiles) throws IOException {
        this.logStream.write(STR_UNSEQ_FILES);
        this.logStream.newLine();
        for (TsFileResource tsFileResource : unseqFiles) {
            this.logStream.write(MergeFileInfo.getFileInfoFromFile(tsFileResource.getTsFile()).toString());
            this.logStream.newLine();
        }
        this.logStream.flush();
    }
}

