/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeFileInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.compaction.InvalidCompactionLogException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeLogAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(MergeLogAnalyzer.class);
    private MergeResource resource;
    private String taskName;
    private File logFile;
    private String currLine;
    private Status status;

    public MergeLogAnalyzer(MergeResource resource, String taskName, File logFile, String storageGroupName) {
        this.resource = resource;
        this.taskName = taskName;
        this.logFile = logFile;
    }

    public Status analyze() throws IOException, MetadataException {
        this.status = Status.NONE;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            this.currLine = bufferedReader.readLine();
            if (this.currLine != null) {
                this.status = Status.All_SOURCE_FILES_EXIST;
                this.analyzeSeqFiles(bufferedReader);
                this.analyzeUnseqFiles(bufferedReader);
            }
        }
        return this.status;
    }

    private void analyzeSeqFiles(BufferedReader bufferedReader) throws IOException {
        if (!"seqFiles".equals(this.currLine)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<TsFileResource> mergeSeqFiles = new ArrayList<TsFileResource>();
        boolean allSourceFileExists = true;
        while ((this.currLine = bufferedReader.readLine()) != null && !"unseqFiles".equals(this.currLine)) {
            Iterator<TsFileResource> iterator = this.resource.getSeqFiles().iterator();
            MergeFileInfo toMatchedInfo = null;
            try {
                toMatchedInfo = MergeFileInfo.getFileInfoFromString(this.currLine);
            }
            catch (InvalidCompactionLogException e) {
                logger.warn("Invalid file info line {}", (Object)this.currLine);
                continue;
            }
            boolean currentFileFound = false;
            while (iterator.hasNext()) {
                TsFileResource seqFile = iterator.next();
                if (!MergeFileInfo.getFileInfoFromFile(seqFile.getTsFile()).equals(toMatchedInfo)) continue;
                mergeSeqFiles.add(seqFile);
                iterator.remove();
                if (!seqFile.getTsFile().exists()) break;
                currentFileFound = true;
                break;
            }
            if (currentFileFound) continue;
            mergeSeqFiles.add(new TsFileResource(new File(this.resource.getSeqFiles().get(0).getTsFile().getParent(), toMatchedInfo.filename)));
            allSourceFileExists = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} seq files after {}ms", new Object[]{this.taskName, mergeSeqFiles.size(), System.currentTimeMillis() - startTime});
        }
        if (!allSourceFileExists) {
            this.status = Status.SOME_SOURCE_FILES_LOST;
        }
        this.resource.setSeqFiles(mergeSeqFiles);
    }

    private void analyzeUnseqFiles(BufferedReader bufferedReader) throws IOException {
        if (!"unseqFiles".equals(this.currLine)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<TsFileResource> mergeUnseqFiles = new ArrayList<TsFileResource>();
        boolean allSourceFileExists = true;
        while ((this.currLine = bufferedReader.readLine()) != null) {
            Iterator<TsFileResource> iterator = this.resource.getUnseqFiles().iterator();
            MergeFileInfo toMatchInfo = null;
            try {
                toMatchInfo = MergeFileInfo.getFileInfoFromString(this.currLine);
            }
            catch (InvalidCompactionLogException e) {
                logger.warn("Invalid file info line {}", (Object)this.currLine);
                break;
            }
            boolean currentFileFound = false;
            while (iterator.hasNext()) {
                TsFileResource unseqFile = iterator.next();
                if (!MergeFileInfo.getFileInfoFromFile(unseqFile.getTsFile()).equals(toMatchInfo)) continue;
                mergeUnseqFiles.add(unseqFile);
                iterator.remove();
                if (!unseqFile.getTsFile().exists()) break;
                currentFileFound = true;
                break;
            }
            if (currentFileFound) continue;
            mergeUnseqFiles.add(new TsFileResource(new File(this.resource.getSeqFiles().get(0).getTsFile().getParent().replace("sequence", "unsequence"), toMatchInfo.filename)));
            allSourceFileExists = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} unseq files after {}ms", new Object[]{this.taskName, mergeUnseqFiles.size(), System.currentTimeMillis() - startTime});
        }
        if (!allSourceFileExists) {
            this.status = Status.SOME_SOURCE_FILES_LOST;
        }
        this.resource.setUnseqFiles(mergeUnseqFiles);
    }

    public static enum Status {
        NONE,
        All_SOURCE_FILES_EXIST,
        SOME_SOURCE_FILES_LOST;

    }
}

