/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class WritableMemChunk
implements IWritableMemChunk {
    private MeasurementSchema schema;
    private TVList list;

    public WritableMemChunk(MeasurementSchema schema, TVList list) {
        this.schema = schema;
        this.list = list;
    }

    @Override
    public void write(long insertTime, Object objectValue) {
        switch (this.schema.getType()) {
            case BOOLEAN: {
                this.putBoolean(insertTime, (Boolean)objectValue);
                break;
            }
            case INT32: {
                this.putInt(insertTime, (Integer)objectValue);
                break;
            }
            case INT64: {
                this.putLong(insertTime, (Long)objectValue);
                break;
            }
            case FLOAT: {
                this.putFloat(insertTime, ((Float)objectValue).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(insertTime, (Double)objectValue);
                break;
            }
            case TEXT: {
                this.putBinary(insertTime, (Binary)objectValue);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + this.schema.getType());
            }
        }
    }

    @Override
    public void write(long[] times, Object valueList, TSDataType dataType, int start, int end) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                this.putBooleans(times, boolValues, start, end);
                break;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                this.putInts(times, intValues, start, end);
                break;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                this.putLongs(times, longValues, start, end);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                this.putFloats(times, floatValues, start, end);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                this.putDoubles(times, doubleValues, start, end);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                this.putBinaries(times, binaryValues, start, end);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
            }
        }
    }

    @Override
    public void putLong(long t, long v) {
        this.list.putLong(t, v);
    }

    @Override
    public void putInt(long t, int v) {
        this.list.putInt(t, v);
    }

    @Override
    public void putFloat(long t, float v) {
        this.list.putFloat(t, v);
    }

    @Override
    public void putDouble(long t, double v) {
        this.list.putDouble(t, v);
    }

    @Override
    public void putBinary(long t, Binary v) {
        this.list.putBinary(t, v);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        this.list.putBoolean(t, v);
    }

    @Override
    public void putLongs(long[] t, long[] v, int start, int end) {
        this.list.putLongs(t, v, start, end);
    }

    @Override
    public void putInts(long[] t, int[] v, int start, int end) {
        this.list.putInts(t, v, start, end);
    }

    @Override
    public void putFloats(long[] t, float[] v, int start, int end) {
        this.list.putFloats(t, v, start, end);
    }

    @Override
    public void putDoubles(long[] t, double[] v, int start, int end) {
        this.list.putDoubles(t, v, start, end);
    }

    @Override
    public void putBinaries(long[] t, Binary[] v, int start, int end) {
        this.list.putBinaries(t, v, start, end);
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, int start, int end) {
        this.list.putBooleans(t, v, start, end);
    }

    @Override
    public synchronized TVList getSortedTVListForQuery() {
        this.sortTVList();
        this.list.increaseReferenceCount();
        return this.list;
    }

    private void sortTVList() {
        if (this.list.getReferenceCount() > 0 && !this.list.isSorted()) {
            this.list = this.list.clone();
        }
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public synchronized TVList getSortedTVListForFlush() {
        this.sortTVList();
        return this.list;
    }

    @Override
    public TVList getTVList() {
        return this.list;
    }

    @Override
    public long count() {
        return this.list.size();
    }

    @Override
    public MeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public long getFirstPoint() {
        if (this.list.size() == 0) {
            return Long.MAX_VALUE;
        }
        return this.getSortedTVListForQuery().getTimeValuePair(0).getTimestamp();
    }

    @Override
    public long getLastPoint() {
        if (this.list.size() == 0) {
            return Long.MIN_VALUE;
        }
        return this.getSortedTVListForQuery().getTimeValuePair(this.getSortedTVListForQuery().size() - 1).getTimestamp();
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        return this.list.delete(lowerBound, upperBound);
    }

    public String toString() {
        int size = this.getSortedTVListForQuery().size();
        StringBuilder out = new StringBuilder("MemChunk Size: " + size + System.lineSeparator());
        if (size != 0) {
            out.append("Data type:").append(this.schema.getType()).append(System.lineSeparator());
            out.append("First point:").append(this.getSortedTVListForQuery().getTimeValuePair(0)).append(System.lineSeparator());
            out.append("Last point:").append(this.getSortedTVListForQuery().getTimeValuePair(size - 1)).append(System.lineSeparator());
        }
        return out.toString();
    }
}

