/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.chunk.ChunkGroupWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileWriter
implements AutoCloseable {
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final Logger LOG = LoggerFactory.getLogger(TsFileWriter.class);
    protected final Schema schema;
    private final TsFileIOWriter fileWriter;
    private final int pageSize;
    private long recordCount = 0L;
    private Map<String, IChunkGroupWriter> groupWriters = new HashMap<String, IChunkGroupWriter>();
    private long recordCountForNextMemCheck = 100L;
    private long chunkGroupSizeThreshold;

    public TsFileWriter(File file) throws IOException {
        this(new TsFileIOWriter(file), new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileIOWriter fileWriter) throws IOException {
        this(fileWriter, new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema) throws IOException {
        this(new TsFileIOWriter(file), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileOutput output, Schema schema) throws IOException {
        this(new TsFileIOWriter(output), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema, TSFileConfig conf) throws IOException {
        this(new TsFileIOWriter(file), schema, conf);
    }

    protected TsFileWriter(TsFileIOWriter fileWriter, Schema schema, TSFileConfig conf) throws IOException {
        if (!fileWriter.canWrite()) {
            throw new IOException("the given file Writer does not support writing any more. Maybe it is an complete TsFile");
        }
        this.fileWriter = fileWriter;
        this.schema = fileWriter instanceof RestorableTsFileIOWriter ? new Schema(((RestorableTsFileIOWriter)fileWriter).getKnownSchema()) : schema;
        this.pageSize = conf.getPageSizeInByte();
        this.chunkGroupSizeThreshold = conf.getGroupSizeInByte();
        config.setTSFileStorageFs(conf.getTSFileStorageFs());
        if ((long)this.pageSize >= this.chunkGroupSizeThreshold) {
            LOG.warn("TsFile's page size {} is greater than chunk group size {}, please enlarge the chunk group size or decrease page size. ", (Object)this.pageSize, (Object)this.chunkGroupSizeThreshold);
        }
    }

    public void registerDeviceTemplate(String templateName, Map<String, MeasurementSchema> template) {
        this.schema.registerDeviceTemplate(templateName, template);
    }

    public void registerDevice(String deviceId, String templateName) {
        this.schema.registerDevice(deviceId, templateName);
    }

    public void registerTimeseries(Path path, MeasurementSchema measurementSchema) throws WriteProcessException {
        if (this.schema.containsTimeseries(path)) {
            throw new WriteProcessException("given timeseries has exists! " + path);
        }
        this.schema.registerTimeseries(path, measurementSchema);
    }

    private boolean checkIsTimeSeriesExist(TSRecord record) throws WriteProcessException {
        IChunkGroupWriter groupWriter;
        if (!this.groupWriters.containsKey(record.deviceId)) {
            groupWriter = new ChunkGroupWriterImpl(record.deviceId);
            this.groupWriters.put(record.deviceId, groupWriter);
        } else {
            groupWriter = this.groupWriters.get(record.deviceId);
        }
        for (DataPoint dp : record.dataPointList) {
            String measurementId = dp.getMeasurementId();
            Path path = new Path(record.deviceId, measurementId);
            if (this.schema.containsTimeseries(path)) {
                groupWriter.tryToAddSeriesWriter(this.schema.getSeriesSchema(path), this.pageSize);
                continue;
            }
            if (this.schema.getDeviceTemplates() != null && this.schema.getDeviceTemplates().size() == 1) {
                Map<String, MeasurementSchema> template = this.schema.getDeviceTemplates().entrySet().iterator().next().getValue();
                if (!template.containsKey(path.getMeasurement())) continue;
                groupWriter.tryToAddSeriesWriter(template.get(path.getMeasurement()), this.pageSize);
                continue;
            }
            throw new NoMeasurementException("input path is invalid: " + path);
        }
        return true;
    }

    private void checkIsTimeSeriesExist(Tablet tablet) throws WriteProcessException {
        IChunkGroupWriter groupWriter;
        if (!this.groupWriters.containsKey(tablet.deviceId)) {
            groupWriter = new ChunkGroupWriterImpl(tablet.deviceId);
            this.groupWriters.put(tablet.deviceId, groupWriter);
        } else {
            groupWriter = this.groupWriters.get(tablet.deviceId);
        }
        String deviceId = tablet.deviceId;
        for (MeasurementSchema timeseries : tablet.getSchemas()) {
            String measurementId = timeseries.getMeasurementId();
            Path path = new Path(deviceId, measurementId);
            if (this.schema.containsTimeseries(path)) {
                groupWriter.tryToAddSeriesWriter(this.schema.getSeriesSchema(path), this.pageSize);
                continue;
            }
            if (this.schema.getDeviceTemplates() != null && this.schema.getDeviceTemplates().size() == 1) {
                Map<String, MeasurementSchema> template = this.schema.getDeviceTemplates().entrySet().iterator().next().getValue();
                if (!template.containsKey(path.getMeasurement())) continue;
                groupWriter.tryToAddSeriesWriter(template.get(path.getMeasurement()), this.pageSize);
                continue;
            }
            throw new NoMeasurementException("input measurement is invalid: " + measurementId);
        }
    }

    public boolean write(TSRecord record) throws IOException, WriteProcessException {
        this.checkIsTimeSeriesExist(record);
        this.groupWriters.get(record.deviceId).write(record.time, record.dataPointList);
        ++this.recordCount;
        return this.checkMemorySizeAndMayFlushChunks();
    }

    public boolean write(Tablet tablet) throws IOException, WriteProcessException {
        this.checkIsTimeSeriesExist(tablet);
        this.groupWriters.get(tablet.deviceId).write(tablet);
        this.recordCount += (long)tablet.rowSize;
        return this.checkMemorySizeAndMayFlushChunks();
    }

    private long calculateMemSizeForAllGroup() {
        long memTotalSize = 0L;
        for (IChunkGroupWriter group : this.groupWriters.values()) {
            memTotalSize += group.updateMaxGroupMemSize();
        }
        return memTotalSize;
    }

    private boolean checkMemorySizeAndMayFlushChunks() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.calculateMemSizeForAllGroup();
            assert (memSize > 0L);
            if (memSize > this.chunkGroupSizeThreshold) {
                LOG.debug("start to flush chunk groups, memory space occupy:{}", (Object)memSize);
                this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
                return this.flushAllChunkGroups();
            }
            this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
            return false;
        }
        return false;
    }

    public boolean flushAllChunkGroups() throws IOException {
        if (this.recordCount > 0L) {
            for (Map.Entry<String, IChunkGroupWriter> entry : this.groupWriters.entrySet()) {
                String deviceId = entry.getKey();
                IChunkGroupWriter groupWriter = entry.getValue();
                this.fileWriter.startChunkGroup(deviceId);
                long pos = this.fileWriter.getPos();
                long dataSize = groupWriter.flushToFileWriter(this.fileWriter);
                if (this.fileWriter.getPos() - pos != dataSize) {
                    throw new IOException(String.format("Flushed data size is inconsistent with computation! Estimated: %d, Actual: %d", dataSize, this.fileWriter.getPos() - pos));
                }
                this.fileWriter.endChunkGroup();
            }
            this.reset();
        }
        return false;
    }

    private void reset() {
        this.groupWriters.clear();
        this.recordCount = 0L;
    }

    @Override
    public void close() throws IOException {
        LOG.info("start close file");
        this.flushAllChunkGroups();
        this.fileWriter.endFile();
    }

    public TsFileIOWriter getIOWriter() {
        return this.fileWriter;
    }
}

