/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class QueryUtils {
    private QueryUtils() {
    }

    public static void modifyChunkMetaData(List<ChunkMetadata> chunkMetaData, List<Modification> modifications) {
        for (int metaIndex = 0; metaIndex < chunkMetaData.size(); ++metaIndex) {
            ChunkMetadata metaData2 = chunkMetaData.get(metaIndex);
            for (Modification modification : modifications) {
                if (metaData2.isFromOldTsFile()) {
                    if (modification.getFileOffset() <= metaData2.getVersion()) continue;
                    QueryUtils.doModifyChunkMetaData(modification, metaData2);
                    continue;
                }
                if (modification.getFileOffset() <= metaData2.getOffsetOfChunkHeader()) continue;
                QueryUtils.doModifyChunkMetaData(modification, metaData2);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (metaData.isModified() || !range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    private static void doModifyChunkMetaData(Modification modification, ChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            metaData.insertIntoSortedDeletions(deletion.getStartTime(), deletion.getEndTime());
        }
    }

    public static void fillOrderIndexes(QueryDataSource dataSource, String deviceId, boolean ascending) {
        List<TsFileResource> unseqResources = dataSource.getUnseqResources();
        int[] orderIndex = new int[unseqResources.size() + 1];
        AtomicInteger index = new AtomicInteger();
        Map<Integer, Long> intToOrderTimeMap = unseqResources.stream().collect(Collectors.toMap(key -> index.getAndIncrement(), resource -> resource.getOrderTime(deviceId, ascending)));
        index.set(0);
        intToOrderTimeMap.entrySet().stream().sorted((t1, t2) -> ascending ? Long.compare((Long)t1.getValue(), (Long)t2.getValue()) : Long.compare((Long)t2.getValue(), (Long)t1.getValue())).collect(Collectors.toList()).forEach(item -> {
            orderIndex[index.getAndIncrement()] = (Integer)item.getKey();
        });
        dataSource.setUnSeqFileOrderIndex(orderIndex);
    }
}

