/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.transfer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.exception.SyncDeviceOwnerConflictException;
import org.apache.iotdb.db.sync.conf.SyncConstant;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.manage.ISyncFileManager;
import org.apache.iotdb.db.sync.sender.manage.SyncFileManager;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogger;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogger;
import org.apache.iotdb.db.sync.sender.transfer.ISyncClient;
import org.apache.iotdb.db.utils.SyncUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TSocketWrapper;
import org.apache.iotdb.service.sync.thrift.ConfirmInfo;
import org.apache.iotdb.service.sync.thrift.SyncService;
import org.apache.iotdb.service.sync.thrift.SyncStatus;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClient
implements ISyncClient {
    private static final Logger logger = LoggerFactory.getLogger(SyncClient.class);
    private static SyncSenderConfig config = SyncSenderDescriptor.getInstance().getConfig();
    private static final IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
    private static final int TIMEOUT_MS = 2000;
    private long schemaFilePos;
    private TTransport transport;
    private SyncService.Client serviceClient;
    private Map<String, Map<Long, Set<Long>>> allSG;
    private Map<String, Map<Long, Map<Long, Set<File>>>> toBeSyncedFilesMap;
    private Map<String, Map<Long, Map<Long, Set<File>>>> deletedFilesMap;
    private Map<String, Map<Long, Map<Long, Set<File>>>> lastLocalFilesMap;
    private volatile boolean syncStatus = false;
    private ISyncSenderLogger syncLog;
    private boolean isSyncConnect = false;
    private ISyncFileManager syncFileManager = SyncFileManager.getInstance();
    private ScheduledExecutorService executorService;
    private TConfiguration tConfiguration = TConfigurationConst.defaultTConfiguration;

    private SyncClient() {
        this.init();
    }

    public static SyncClient getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static void main(String[] args) throws IOException {
        Thread.currentThread().setName(ThreadName.SYNC_CLIENT.getName());
        SyncClient fileSenderImpl = new SyncClient();
        fileSenderImpl.verifySingleton();
        fileSenderImpl.startMonitor();
        fileSenderImpl.startTimedTask();
    }

    @Override
    public void verifySingleton() throws IOException {
        File lockFile = this.getLockFile();
        if (!lockFile.getParentFile().exists()) {
            lockFile.getParentFile().mkdirs();
        }
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        if (!this.lockInstance(lockFile)) {
            logger.error("Sync client is already running.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockInstance(File lockFile) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(lockFile, "rw");
            FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                RandomAccessFile randomAccessFile2 = randomAccessFile;
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        fileLock.release();
                        randomAccessFile2.close();
                    }
                    catch (Exception e) {
                        logger.error("Unable to remove lock file: {}", (Object)lockFile, (Object)e);
                    }
                }));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("Unable to create and/or lock file: {}", (Object)lockFile, (Object)e);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception e) {
                    logger.error("Unable to close randomAccessFile: {}", (Object)randomAccessFile, (Object)e);
                }
            }
        }
        return false;
    }

    @Override
    public void init() {
        if (this.executorService == null) {
            this.executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(2, "sync-client-timer");
        }
    }

    @Override
    public void startMonitor() {
        this.executorService.scheduleWithFixedDelay(() -> {
            if (this.syncStatus) {
                logger.info("Sync process for receiver {} is in execution!", (Object)config.getSyncReceiverName());
            }
        }, SyncConstant.SYNC_MONITOR_DELAY, SyncConstant.SYNC_MONITOR_PERIOD, TimeUnit.SECONDS);
    }

    @Override
    public void startTimedTask() {
        this.executorService.scheduleWithFixedDelay(() -> {
            try {
                this.syncAll();
            }
            catch (Exception e) {
                logger.error("Sync failed", (Throwable)e);
            }
            finally {
                if (this.transport != null && this.transport.isOpen()) {
                    this.transport.close();
                }
                this.isSyncConnect = false;
            }
        }, 0L, SyncConstant.SYNC_PROCESS_PERIOD, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    @Override
    public void syncAll() throws SyncConnectionException, IOException, TException {
        this.establishConnection(config.getServerIp(), config.getServerPort());
        this.confirmIdentity();
        this.serviceClient.startSync();
        this.syncSchema();
        String[] dataDirs = ioTDBConfig.getDataDirs();
        logger.info("There are {} data dirs to be synced.", (Object)dataDirs.length);
        for (int i = 0; i < dataDirs.length; ++i) {
            String dataDir = dataDirs[i];
            logger.info("Start to sync data in data dir {}, the process is {}/{}", new Object[]{dataDir, i + 1, dataDirs.length});
            config.update(dataDir);
            this.checkRecovery();
            this.syncFileManager.getValidFiles(dataDir);
            this.allSG = this.syncFileManager.getAllSGs();
            this.lastLocalFilesMap = this.syncFileManager.getLastLocalFilesMap();
            this.deletedFilesMap = this.syncFileManager.getDeletedFilesMap();
            this.toBeSyncedFilesMap = this.syncFileManager.getToBeSyncedFilesMap();
            if (SyncUtils.isEmpty(this.deletedFilesMap) && SyncUtils.isEmpty(this.toBeSyncedFilesMap)) {
                logger.info("There has no data to sync in data dir {}", (Object)dataDir);
                continue;
            }
            this.sync();
            this.endSync();
            logger.info("Finish to sync data in data dir {}, the process is {}/{}", new Object[]{dataDir, i + 1, dataDirs.length});
        }
        try {
            this.serviceClient.endSync();
            this.transport.close();
            logger.info("Sync process has finished.");
        }
        catch (TException e) {
            logger.error("Unable to connect to receiver.", (Throwable)e);
        }
    }

    private void checkRecovery() throws IOException {
        new SyncSenderLogAnalyzer(config.getSenderFolderPath()).recover();
    }

    @Override
    public void establishConnection(String serverIp, int serverPort) throws SyncConnectionException {
        RpcTransportFactory.setDefaultBufferCapacity((int)ioTDBConfig.getThriftDefaultBufferSize());
        RpcTransportFactory.setThriftMaxFrameSize((int)ioTDBConfig.getThriftMaxFrameSize());
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport((TTransport)TSocketWrapper.wrap((TConfiguration)this.tConfiguration, (String)serverIp, (int)serverPort, (int)2000));
            Object protocol = ioTDBConfig.isRpcThriftCompressionEnable() ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
            this.serviceClient = new SyncService.Client((TProtocol)protocol);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            this.isSyncConnect = true;
        }
        catch (TTransportException e) {
            logger.error("Cannot connect to the receiver.");
            throw new SyncConnectionException(e);
        }
    }

    private boolean reconnect() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        try {
            this.establishConnection(config.getServerIp(), config.getServerPort());
            this.confirmIdentity();
            this.serviceClient.startSync();
        }
        catch (SyncConnectionException | TException e) {
            logger.warn("Can not reconnect to receiver {}. Caused by ", (Object)config.getSyncReceiverName(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public void confirmIdentity() throws SyncConnectionException {
        try (Socket socket = new Socket(config.getServerIp(), config.getServerPort());){
            ConfirmInfo info = new ConfirmInfo(socket.getLocalAddress().getHostAddress(), this.getOrCreateUUID(this.getUuidFile()), ioTDBConfig.getPartitionInterval(), ioTDBConfig.getIoTDBMajorVersion());
            SyncStatus status = this.serviceClient.check(info);
            if (status.code != 1) {
                throw new SyncConnectionException("The receiver rejected the synchronization task because " + status.msg);
            }
        }
        catch (Exception e) {
            logger.error("Cannot confirm identity with the receiver.");
            throw new SyncConnectionException(e);
        }
    }

    private String getOrCreateUUID(File uuidFile) throws IOException {
        String uuid;
        block16: {
            if (!uuidFile.getParentFile().exists()) {
                uuidFile.getParentFile().mkdirs();
            }
            if (!uuidFile.exists()) {
                try (FileOutputStream out = new FileOutputStream(uuidFile);){
                    uuid = this.generateUUID();
                    out.write(uuid.getBytes());
                    break block16;
                }
                catch (IOException e) {
                    logger.error("Cannot insert UUID to file {}", (Object)uuidFile.getPath());
                    throw new IOException(e);
                }
            }
            try (BufferedReader bf = new BufferedReader(new FileReader(uuidFile.getAbsolutePath()));){
                uuid = bf.readLine();
            }
            catch (IOException e) {
                logger.error("Cannot read UUID from file{}", (Object)uuidFile.getPath());
                throw new IOException(e);
            }
        }
        return uuid;
    }

    private String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    @Override
    public void syncSchema() throws SyncConnectionException, TException {
        if (!this.getSchemaLogFile().exists()) {
            logger.info("Schema file {} doesn't exist.", (Object)this.getSchemaLogFile().getName());
            return;
        }
        int retryCount = 0;
        while (true) {
            if (retryCount > config.getMaxNumOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("Can not sync schema after %s retries.", config.getMaxNumOfSyncFileRetry()));
            }
            if (!this.isSyncConnect && !this.reconnect()) {
                ++retryCount;
                continue;
            }
            if (this.tryToSyncSchema()) break;
            ++retryCount;
        }
        this.writeSyncSchemaPos(this.getSchemaPosFile());
    }

    /*
     * Exception decompiling
     */
    private boolean tryToSyncSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkDigestForSchema(String digestOfSender) throws TException {
        SyncStatus status = this.serviceClient.checkDataDigest(digestOfSender);
        if (status.code == 1 && digestOfSender.equals(status.msg)) {
            logger.info("Receiver has received schema successfully.");
            return true;
        }
        logger.error("Digest check of schema file {} failed, retry", (Object)this.getSchemaLogFile().getAbsoluteFile());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readSyncSchemaPos(File syncSchemaLogFile) {
        try {
            if (!syncSchemaLogFile.exists()) return 0;
            try (BufferedReader br = new BufferedReader(new FileReader(syncSchemaLogFile));){
                String pos = br.readLine();
                if (pos == null) return 0;
                int n = Integer.parseInt(pos);
                return n;
            }
        }
        catch (IOException e) {
            logger.error("Can not find file {}", (Object)syncSchemaLogFile.getAbsoluteFile(), (Object)e);
            return 0;
        }
        catch (NumberFormatException e) {
            logger.error("Sync schema pos is not valid", (Throwable)e);
        }
        return 0;
    }

    private void writeSyncSchemaPos(File syncSchemaLogFile) {
        try {
            if (!syncSchemaLogFile.exists()) {
                syncSchemaLogFile.createNewFile();
            }
            try (BufferedWriter br = new BufferedWriter(new FileWriter(syncSchemaLogFile));){
                br.write(Long.toString(this.schemaFilePos));
            }
        }
        catch (IOException e) {
            logger.error("Can not find file {}", (Object)syncSchemaLogFile.getAbsoluteFile(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        try {
            this.syncStatus = true;
            List<String> storageGroups = config.getStorageGroupList();
            for (Map.Entry<String, Map<Long, Set<Long>>> entry : this.allSG.entrySet()) {
                String sgName = entry.getKey();
                if (!storageGroups.isEmpty() && !storageGroups.contains(sgName)) continue;
                this.lastLocalFilesMap.putIfAbsent(sgName, new HashMap());
                this.syncLog = new SyncSenderLogger(this.getSyncLogFile());
                try {
                    SyncStatus status = this.serviceClient.init(sgName);
                    if (status.code != 1) {
                        throw new SyncConnectionException("Unable init receiver because " + status.msg);
                    }
                }
                catch (SyncConnectionException | TException e) {
                    throw new SyncConnectionException("Unable to connect to receiver", e);
                }
                logger.info("Sync process starts to transfer data of storage group {}, it has {} virtual storage groups.", (Object)sgName, (Object)entry.getValue().size());
                try {
                    for (Map.Entry<Long, Set<Long>> vgEntry : entry.getValue().entrySet()) {
                        this.lastLocalFilesMap.get(sgName).putIfAbsent(vgEntry.getKey(), new HashMap());
                        for (Long timeRangeId : vgEntry.getValue()) {
                            this.lastLocalFilesMap.get(sgName).get(vgEntry.getKey()).putIfAbsent(timeRangeId, new HashSet());
                            this.syncDeletedFilesNameInOneGroup(sgName, vgEntry.getKey(), timeRangeId, this.deletedFilesMap.getOrDefault(sgName, Collections.emptyMap()).getOrDefault(vgEntry.getKey(), Collections.emptyMap()).getOrDefault(timeRangeId, Collections.emptySet()));
                            this.syncDataFilesInOneGroup(sgName, vgEntry.getKey(), timeRangeId, this.toBeSyncedFilesMap.getOrDefault(sgName, Collections.emptyMap()).getOrDefault(vgEntry.getKey(), Collections.emptyMap()).getOrDefault(timeRangeId, Collections.emptySet()));
                        }
                    }
                }
                catch (SyncDeviceOwnerConflictException e) {
                    this.deletedFilesMap.remove(sgName);
                    this.toBeSyncedFilesMap.remove(sgName);
                    storageGroups.remove(sgName);
                    config.setStorageGroupList(storageGroups);
                    logger.error("Skip the data files of the storage group {}", (Object)sgName, (Object)e);
                }
                logger.info("Sync process finished the task to sync data of storage group {}.", (Object)sgName);
            }
        }
        catch (SyncConnectionException e) {
            logger.error("cannot finish sync process", (Throwable)e);
        }
        finally {
            if (this.syncLog != null) {
                this.syncLog.close();
            }
            this.syncStatus = false;
        }
    }

    @Override
    public void syncDeletedFilesNameInOneGroup(String sgName, Long vgId, Long timeRangeId, Set<File> deletedFilesName) throws IOException {
        if (deletedFilesName.isEmpty()) {
            logger.info("There has no deleted files to be synced in storage group {}", (Object)sgName);
            return;
        }
        this.syncLog.startSyncDeletedFilesName();
        logger.info("Start to sync names of deleted files in storage group {}", (Object)sgName);
        for (File file : deletedFilesName) {
            try {
                if (!this.isSyncConnect && !this.reconnect() || this.serviceClient.syncDeletedFileName((String)this.getFileInfoWithVgAndTimePartition((File)file)).code != 1) continue;
                logger.info("Receiver has received deleted file name {} successfully.", (Object)file.getPath());
                this.lastLocalFilesMap.get(sgName).get(vgId).get(timeRangeId).remove(file);
                this.syncLog.finishSyncDeletedFileName(file);
            }
            catch (TException e) {
                logger.error("Can not sync deleted file name {}, skip it.", (Object)file);
                this.isSyncConnect = false;
            }
        }
        logger.info("Finish to sync names of deleted files in storage group {}", (Object)sgName);
    }

    @Override
    public void syncDataFilesInOneGroup(String sgName, Long vgId, Long timeRangeId, Set<File> toBeSyncFiles) throws SyncConnectionException, IOException, SyncDeviceOwnerConflictException {
        if (toBeSyncFiles.isEmpty()) {
            logger.info("There has no new tsfiles to be synced in storage group {}", (Object)sgName);
            return;
        }
        this.syncLog.startSyncTsFiles();
        logger.info("Sync process starts to transfer data of storage group {}", (Object)sgName);
        int cnt = 0;
        for (File tsfile : toBeSyncFiles) {
            ++cnt;
            try {
                File snapshotFile = this.makeFileSnapshot(tsfile);
                this.syncSingleFile(new File(snapshotFile.getAbsolutePath() + ".resource"));
                this.syncSingleFile(snapshotFile);
                this.lastLocalFilesMap.get(sgName).get(vgId).get(timeRangeId).add(tsfile);
                this.syncLog.finishSyncTsfile(tsfile);
                logger.info("Task of synchronization has completed {}/{}.", (Object)cnt, (Object)toBeSyncFiles.size());
            }
            catch (IOException e) {
                logger.info("Tsfile {} can not make snapshot, so skip the tsfile and continue to sync other tsfiles", (Object)tsfile, (Object)e);
            }
        }
        logger.info("Sync process has finished storage group {}.", (Object)sgName);
    }

    File makeFileSnapshot(File file) throws IOException {
        File snapshotFile = SyncUtils.getSnapshotFile(file);
        if (!snapshotFile.getParentFile().exists()) {
            snapshotFile.getParentFile().mkdirs();
        }
        Path link = FileSystems.getDefault().getPath(snapshotFile.getAbsolutePath(), new String[0]);
        Path target = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
        Files.createLink(link, target);
        link = FileSystems.getDefault().getPath(snapshotFile.getAbsolutePath() + ".resource", new String[0]);
        target = FileSystems.getDefault().getPath(file.getAbsolutePath() + ".resource", new String[0]);
        Files.createLink(link, target);
        return snapshotFile;
    }

    private void syncSingleFile(File snapshotFile) throws SyncConnectionException, SyncDeviceOwnerConflictException {
        try {
            int retryCount = 0;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            this.serviceClient.initSyncData(this.getFileInfoWithVgAndTimePartition(snapshotFile));
            block14: while (true) {
                if (++retryCount > config.getMaxNumOfSyncFileRetry()) {
                    throw new SyncConnectionException(String.format("Can not sync file %s after %s tries.", snapshotFile.getAbsoluteFile(), config.getMaxNumOfSyncFileRetry()));
                }
                md.reset();
                byte[] buffer = new byte[SyncConstant.DATA_CHUNK_SIZE];
                FileInputStream fis = new FileInputStream(snapshotFile);
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(SyncConstant.DATA_CHUNK_SIZE);
                    try {
                        int dataLength;
                        while ((dataLength = fis.read(buffer)) != -1) {
                            bos.write(buffer, 0, dataLength);
                            md.update(buffer, 0, dataLength);
                            ByteBuffer buffToSend = ByteBuffer.wrap(bos.toByteArray());
                            bos.reset();
                            SyncStatus status = this.serviceClient.syncData(buffToSend);
                            if (status.code == -2) {
                                throw new SyncDeviceOwnerConflictException(status.msg);
                            }
                            if (status.code == 1) continue;
                            logger.info("Receiver failed to receive data from {} because {}, retry.", (Object)status.msg, (Object)snapshotFile.getAbsoluteFile());
                            continue block14;
                        }
                    }
                    finally {
                        bos.close();
                        continue;
                    }
                }
                finally {
                    fis.close();
                    continue;
                }
                String digestOfSender = new BigInteger(1, md.digest()).toString(16);
                SyncStatus status = this.serviceClient.checkDataDigest(digestOfSender);
                if (status.code == 1 && digestOfSender.equals(status.msg)) {
                    logger.info("Receiver has received {} successfully.", (Object)snapshotFile.getAbsoluteFile());
                    break;
                }
                logger.error("Digest check of tsfile {} failed, retry", (Object)snapshotFile.getAbsoluteFile());
            }
        }
        catch (IOException | NoSuchAlgorithmException | TException e) {
            throw new SyncConnectionException("Cannot sync data with receiver.", e);
        }
    }

    private void endSync() throws IOException {
        File currentLocalFile = this.getCurrentLogFile();
        File lastLocalFile = new File(config.getLastFileInfoPath());
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(currentLocalFile));){
            for (Map<Long, Map<Long, Set<File>>> vgCurrentLocalFiles : this.lastLocalFilesMap.values()) {
                for (Map<Long, Set<File>> currentLocalFiles : vgCurrentLocalFiles.values()) {
                    for (Set<File> files : currentLocalFiles.values()) {
                        for (File file : files) {
                            bw.write(file.getAbsolutePath());
                            bw.newLine();
                        }
                        bw.flush();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not clear sync log {}", (Object)lastLocalFile.getAbsoluteFile(), (Object)e);
        }
        lastLocalFile.delete();
        FileUtils.moveFile((File)currentLocalFile, (File)lastLocalFile);
        try {
            FileUtils.deleteDirectory((File)new File(config.getSnapshotPath()));
        }
        catch (IOException e) {
            logger.error("Can not clear snapshot directory {}", (Object)config.getSnapshotPath(), (Object)e);
        }
        this.getSyncLogFile().delete();
    }

    private File getSchemaPosFile() {
        return new File(ioTDBConfig.getSyncDir(), config.getSyncReceiverName() + File.separator + "sync_schema_pos");
    }

    private File getSchemaLogFile() {
        return new File(ioTDBConfig.getSchemaDir(), "mlog.bin");
    }

    private File getLockFile() {
        return new File(ioTDBConfig.getSyncDir(), config.getSyncReceiverName() + File.separator + "sync_lock");
    }

    private File getUuidFile() {
        return new File(ioTDBConfig.getSyncDir(), "uuid.txt");
    }

    private File getSyncLogFile() {
        return new File(config.getSenderFolderPath(), "sync.log");
    }

    private File getCurrentLogFile() {
        return new File(config.getSenderFolderPath(), "current_local_files.txt");
    }

    public void setConfig(SyncSenderConfig config) {
        SyncClient.config = config;
    }

    private String getFileInfoWithVgAndTimePartition(File file) {
        return file.getParentFile().getParentFile().getName() + "!" + file.getParentFile().getName() + "!" + file.getName();
    }

    public void setContent(SyncService.Client serviceClient, boolean isSyncConnect, Map<String, Map<Long, Set<Long>>> allSG, Map<String, Map<Long, Map<Long, Set<File>>>> toBeSyncedFilesMap, Map<String, Map<Long, Map<Long, Set<File>>>> deletedFilesMap, Map<String, Map<Long, Map<Long, Set<File>>>> lastLocalFilesMap, ISyncSenderLogger syncLog) {
        this.serviceClient = serviceClient;
        this.isSyncConnect = isSyncConnect;
        this.allSG = allSG;
        this.toBeSyncedFilesMap = toBeSyncedFilesMap;
        this.deletedFilesMap = deletedFilesMap;
        this.lastLocalFilesMap = lastLocalFilesMap;
        this.syncLog = syncLog;
    }

    private static class InstanceHolder {
        private static final SyncClient INSTANCE = new SyncClient();

        private InstanceHolder() {
        }
    }
}

