/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure.row;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableRowRecordList
implements SerializableList {
    protected static final int MIN_OBJECT_HEADER_SIZE = 8;
    protected static final int MIN_ARRAY_HEADER_SIZE = 12;
    private final SerializableList.SerializationRecorder serializationRecorder;
    private final TSDataType[] dataTypes;
    private final int internalRowRecordListCapacity;
    private final int seriesNumber;
    private List<Object[]> rowRecords;

    public static SerializableRowRecordList newSerializableRowRecordList(long queryId, TSDataType[] dataTypes, int internalRowRecordListCapacity) {
        SerializableList.SerializationRecorder recorder = new SerializableList.SerializationRecorder(queryId);
        return new SerializableRowRecordList(recorder, dataTypes, internalRowRecordListCapacity);
    }

    protected static int calculateCapacity(TSDataType[] dataTypes, float memoryLimitInMB, int byteArrayLengthForMemoryControl) throws QueryProcessException {
        int rowLength = 8;
        block8: for (TSDataType dataType : dataTypes) {
            switch (dataType) {
                case INT32: {
                    rowLength += 4;
                    continue block8;
                }
                case INT64: {
                    rowLength += 8;
                    continue block8;
                }
                case FLOAT: {
                    rowLength += 4;
                    continue block8;
                }
                case DOUBLE: {
                    rowLength += 8;
                    continue block8;
                }
                case BOOLEAN: {
                    ++rowLength;
                    continue block8;
                }
                case TEXT: {
                    rowLength += 20 + byteArrayLengthForMemoryControl;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(dataType.toString());
                }
            }
        }
        int size = (int)(memoryLimitInMB * 1048576.0f / 2.0f / (float)rowLength);
        if (size <= 0) {
            throw new QueryProcessException("Memory is not enough for current query.");
        }
        return size;
    }

    private SerializableRowRecordList(SerializableList.SerializationRecorder serializationRecorder, TSDataType[] dataTypes, int internalRowRecordListCapacity) {
        this.serializationRecorder = serializationRecorder;
        this.dataTypes = dataTypes;
        this.internalRowRecordListCapacity = internalRowRecordListCapacity;
        this.seriesNumber = dataTypes.length;
        this.init();
    }

    public int size() {
        return this.rowRecords.size();
    }

    public Object[] getRowRecord(int index) {
        return this.rowRecords.get(index);
    }

    public long getTime(int index) {
        return (Long)this.rowRecords.get(index)[this.seriesNumber];
    }

    public void put(Object[] rowRecord) {
        this.rowRecords.add(rowRecord);
    }

    @Override
    public void release() {
        this.rowRecords = null;
    }

    @Override
    public void init() {
        this.rowRecords = new ArrayList<Object[]>(this.internalRowRecordListCapacity);
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int size = this.rowRecords.size();
        this.serializationRecorder.setSerializedElementSize(size);
        int serializedByteLength = 0;
        int nullCount = 0;
        for (Object[] record : this.rowRecords) {
            if (record != null) break;
            ++nullCount;
        }
        serializedByteLength += ReadWriteIOUtils.write((int)nullCount, (OutputStream)outputStream);
        for (int i = nullCount; i < size; ++i) {
            Object[] rowRecord = this.rowRecords.get(i);
            serializedByteLength += ReadWriteIOUtils.write((long)((Long)rowRecord[this.seriesNumber]), (OutputStream)outputStream);
            serializedByteLength += this.writeFields(rowRecord, outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int i;
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        int nullCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < nullCount; ++i) {
            this.put(null);
        }
        for (i = nullCount; i < serializedElementSize; ++i) {
            Object[] rowRecord = new Object[this.seriesNumber + 1];
            rowRecord[this.seriesNumber] = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
            this.readFields(byteBuffer, rowRecord);
            this.put(rowRecord);
        }
    }

    private int writeFields(Object[] rowRecord, PublicBAOS outputStream) throws IOException {
        int serializedByteLength = 0;
        block8: for (int i = 0; i < this.seriesNumber; ++i) {
            Object field = rowRecord[i];
            boolean isNull = field == null;
            serializedByteLength += ReadWriteIOUtils.write((Boolean)isNull, (OutputStream)outputStream);
            if (isNull) continue;
            switch (this.dataTypes[i]) {
                case INT32: {
                    serializedByteLength += ReadWriteIOUtils.write((int)((Integer)field), (OutputStream)outputStream);
                    continue block8;
                }
                case INT64: {
                    serializedByteLength += ReadWriteIOUtils.write((long)((Long)field), (OutputStream)outputStream);
                    continue block8;
                }
                case FLOAT: {
                    serializedByteLength += ReadWriteIOUtils.write((float)((Float)field).floatValue(), (OutputStream)outputStream);
                    continue block8;
                }
                case DOUBLE: {
                    serializedByteLength += ReadWriteIOUtils.write((double)((Double)field), (OutputStream)outputStream);
                    continue block8;
                }
                case BOOLEAN: {
                    serializedByteLength += ReadWriteIOUtils.write((Boolean)((Boolean)field), (OutputStream)outputStream);
                    continue block8;
                }
                case TEXT: {
                    serializedByteLength += ReadWriteIOUtils.write((Binary)((Binary)field), (OutputStream)outputStream);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(this.dataTypes[i].toString());
                }
            }
        }
        return serializedByteLength;
    }

    private void readFields(ByteBuffer byteBuffer, Object[] rowRecord) {
        block8: for (int i = 0; i < this.seriesNumber; ++i) {
            boolean isNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
            if (isNull) continue;
            switch (this.dataTypes[i]) {
                case INT32: {
                    rowRecord[i] = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                    continue block8;
                }
                case INT64: {
                    rowRecord[i] = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
                    continue block8;
                }
                case FLOAT: {
                    rowRecord[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)byteBuffer));
                    continue block8;
                }
                case DOUBLE: {
                    rowRecord[i] = ReadWriteIOUtils.readDouble((ByteBuffer)byteBuffer);
                    continue block8;
                }
                case BOOLEAN: {
                    rowRecord[i] = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
                    continue block8;
                }
                case TEXT: {
                    rowRecord[i] = ReadWriteIOUtils.readBinary((ByteBuffer)byteBuffer);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(this.dataTypes[i].toString());
                }
            }
        }
    }

    @Override
    public SerializableList.SerializationRecorder getSerializationRecorder() {
        return this.serializationRecorder;
    }
}

